/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtils {
    static URLClassLoader sparkClassLoader = null;
    static URLClassLoader originClassLoader = null;
    private static Logger logger = LoggerFactory.getLogger(ClassLoaderUtils.class);

    private ClassLoaderUtils() {
    }

    public static File findFile(String dir, String ptn) {
        File[] files = new File(dir).listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().matches(ptn)) continue;
                return f;
            }
        }
        return null;
    }

    public static ClassLoader getSparkClassLoader() {
        if (sparkClassLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return sparkClassLoader;
    }

    public static void setSparkClassLoader(URLClassLoader classLoader) {
        if (sparkClassLoader != null) {
            logger.error("sparkClassLoader already initialized");
        }
        logger.info("set sparkClassLoader :" + classLoader);
        if (System.getenv("DEBUG_SPARK_CLASSLOADER") != null) {
            return;
        }
        sparkClassLoader = classLoader;
    }

    public static ClassLoader getOriginClassLoader() {
        if (originClassLoader == null) {
            logger.error("originClassLoader not init");
            return Thread.currentThread().getContextClassLoader();
        }
        return originClassLoader;
    }

    public static void setOriginClassLoader(URLClassLoader classLoader) {
        if (originClassLoader != null) {
            logger.error("originClassLoader already initialized");
        }
        logger.info("set originClassLoader :" + classLoader);
        originClassLoader = classLoader;
    }
}

