/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.event;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import lombok.Generated;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.event.ResourceDeleteEvent;
import org.apache.kylin.common.persistence.event.ResourceRelatedEvent;
import org.apache.kylin.common.util.Pair;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class Event
implements Serializable {
    private String key;
    private String instance;

    public static Event fromLog(AuditLog log) {
        ResourceRelatedEvent event;
        Pair<MetadataType, String> pair = MetadataType.splitKeyWithType(log.getResPath());
        if (log.getByteSource() == null) {
            event = new ResourceDeleteEvent(log.getResPath());
        } else {
            RawResource rawResource = new RawResource(pair.getValue(), log.getByteSource(), log.getTimestamp(), log.getMvcc());
            rawResource.setContentDiff(log.isDiffFlag() ? rawResource.getContent() : null);
            event = new ResourceCreateOrUpdateEvent(log.getResPath(), rawResource);
        }
        event.setKey(pair.getValue());
        event.setInstance(log.getInstance());
        return event;
    }

    @Generated
    public Event() {
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getInstance() {
        return this.instance;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$instance = this.getInstance();
        String other$instance = other.getInstance();
        return !(this$instance == null ? other$instance != null : !this$instance.equals(other$instance));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Event(key=" + this.getKey() + ", instance=" + this.getInstance() + ")";
    }
}

