/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.rest.response.ErrorResponse;
import org.springframework.http.server.ServletServerHttpRequest;

public class HttpUtil {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final Charset DEFAULT_CONTENT_CHARSET = StandardCharsets.UTF_8;

    private HttpUtil() {
    }

    public static String getFullRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        if (StringUtils.isNotBlank((CharSequence)request.getQueryString())) {
            if (url.lastIndexOf("?") > -1) {
                return url + "&" + request.getQueryString();
            }
            return url + "?" + request.getQueryString();
        }
        return request.getRequestURL().toString();
    }

    public static void setErrorResponse(HttpServletRequest request, HttpServletResponse response, int statusCode, Exception ex) throws IOException {
        response.setStatus(statusCode);
        response.setContentType(DEFAULT_CONTENT_TYPE);
        ErrorResponse errorResponse = new ErrorResponse(HttpUtil.getFullRequestUrl(request), ex);
        String errorStr = JsonUtil.writeValueAsIndentString((Object)((Object)errorResponse));
        response.setCharacterEncoding(DEFAULT_CONTENT_CHARSET.name());
        byte[] responseData = errorStr.getBytes(DEFAULT_CONTENT_CHARSET);
        ServletOutputStream writer = response.getOutputStream();
        response.setContentLength(responseData.length);
        writer.write(responseData, 0, responseData.length);
        writer.flush();
        writer.close();
    }

    public static String formatRequest(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("Url: ").append(HttpUtil.getFullRequestUrl(request)).append("\n");
        sb.append("Headers: ").append(new ServletServerHttpRequest(request).getHeaders()).append("\n");
        sb.append("RemoteAddr: ").append(request.getRemoteAddr()).append("\n");
        sb.append("RemoteUser: ").append(request.getRemoteUser()).append("\n");
        sb.append("Session: ").append(HttpUtil.formatSession(request.getSession(false))).append("\n");
        Object attr = request.getAttribute("traceId");
        if (attr != null) {
            sb.append("TraceId: ").append(attr).append("\n");
        }
        return sb.toString();
    }

    public static String formatSession(HttpSession session) {
        return String.format(Locale.ROOT, "Id=%s; createTime=%s; lastAccessedTime=%s", session.getId(), session.getCreationTime(), session.getLastAccessedTime());
    }
}

