/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security.config;

import java.lang.reflect.InvocationTargetException;
import org.apache.kylin.rest.service.OpenUserGroupService;
import org.apache.kylin.rest.service.OpenUserService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AuthenticationProvider;

@Profile(value={"custom"})
@Configuration
public class CustomProfileConfiguration {
    @Value(value="${kylin.security.custom.user-service-class-name}")
    private String userClassName;
    @Value(value="${kylin.security.custom.user-group-service-class-name}")
    private String userGroupClassName;
    @Value(value="${kylin.security.custom.authentication-provider-class-name}")
    private String authenticationProviderClassName;

    @Bean(value={"userService"})
    public OpenUserService userService() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> serviceClass = Class.forName(this.userClassName);
        return (OpenUserService)serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Bean(value={"userGroupService"})
    public OpenUserGroupService userGroupService() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        Class<?> serviceClass = Class.forName(this.userGroupClassName);
        return (OpenUserGroupService)serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Bean(value={"customAuthProvider"})
    public AuthenticationProvider customAuthProvider() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        Class<?> serviceClass = Class.forName(this.authenticationProviderClassName);
        return (AuthenticationProvider)serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

