/*
 * Decompiled with CFR 0.152.
 */
package alluxio.uri;

import alluxio.uri.EmbeddedLogicalAuthority;
import alluxio.uri.MultiMasterAuthority;
import alluxio.uri.NoAuthority;
import alluxio.uri.SingleMasterAuthority;
import alluxio.uri.UnknownAuthority;
import alluxio.uri.ZookeeperAuthority;
import alluxio.uri.ZookeeperLogicalAuthority;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Authority
extends Comparable<Authority>,
Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(Authority.class);
    public static final Pattern LOGICAL_MASTER_AUTH = Pattern.compile("^ebj@([a-zA-Z_\\-0-9.]+)$");
    public static final Pattern LOGICAL_ZOOKEEPER_AUTH = Pattern.compile("^zk@([a-zA-Z_\\-0-9.]+)$");
    public static final Pattern SINGLE_MASTER_AUTH = Pattern.compile("^([^:,;]+):(\\d+)$");
    public static final Pattern ZOOKEEPER_AUTH = Pattern.compile("^zk@([^:,;+]+:\\d+([,;+][^:,;+]+:\\d+)*)$");
    public static final Pattern MULTI_MASTERS_AUTH = Pattern.compile("^[^:,;+]+:\\d+([,;+][^:,;+]+:\\d+)+$");

    public static Authority fromString(String authority) {
        if (authority == null || authority.length() == 0) {
            return NoAuthority.INSTANCE;
        }
        Matcher matcher = ZOOKEEPER_AUTH.matcher(authority);
        if (matcher.matches()) {
            return new ZookeeperAuthority(matcher.group(1).replaceAll("[;+]", ","));
        }
        matcher = SINGLE_MASTER_AUTH.matcher(authority);
        if (matcher.matches()) {
            return new SingleMasterAuthority(matcher.group(1), Integer.parseInt(matcher.group(2)));
        }
        matcher = MULTI_MASTERS_AUTH.matcher(authority);
        if (matcher.matches()) {
            return new MultiMasterAuthority(authority.replaceAll("[;+]", ","));
        }
        matcher = LOGICAL_ZOOKEEPER_AUTH.matcher(authority);
        if (matcher.matches()) {
            return new ZookeeperLogicalAuthority(matcher.group(1));
        }
        matcher = LOGICAL_MASTER_AUTH.matcher(authority);
        if (matcher.matches()) {
            return new EmbeddedLogicalAuthority(matcher.group(1));
        }
        return new UnknownAuthority(authority);
    }

    @Override
    default public int compareTo(Authority o) {
        return this.toString().compareTo(o.toString());
    }
}

