/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.MetricsSystem;
import alluxio.metrics.sink.Sink;
import alluxio.shaded.client.com.codahale.metrics.ConsoleReporter;
import alluxio.shaded.client.com.codahale.metrics.MetricRegistry;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

@ThreadSafe
public final class ConsoleSink
implements Sink {
    private static final int CONSOLE_DEFAULT_PERIOD = 10;
    private static final String CONSOLE_DEFAULT_UNIT = "SECONDS";
    private static final String CONSOLE_KEY_PERIOD = "period";
    private static final String CONSOLE_KEY_UNIT = "unit";
    private ConsoleReporter mReporter;
    private Properties mProperties;

    public ConsoleSink(Properties properties, MetricRegistry registry) {
        this.mProperties = properties;
        this.mReporter = ConsoleReporter.forRegistry(registry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build();
        MetricsSystem.checkMinimalPollingPeriod(this.getPollUnit(), this.getPollPeriod());
    }

    @Override
    public void start() {
        this.mReporter.start(this.getPollPeriod(), this.getPollUnit());
    }

    @Override
    public void stop() {
        this.mReporter.stop();
    }

    @Override
    public void report() {
        this.mReporter.report();
    }

    private int getPollPeriod() {
        String period = this.mProperties.getProperty(CONSOLE_KEY_PERIOD);
        return period != null ? Integer.parseInt(period) : 10;
    }

    private TimeUnit getPollUnit() {
        String unit = this.mProperties.getProperty(CONSOLE_KEY_UNIT);
        if (unit == null) {
            unit = CONSOLE_DEFAULT_UNIT;
        }
        return TimeUnit.valueOf(unit.toUpperCase());
    }
}

