/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.FileSystemUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.engine.spark.source.SparkSqlUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.snapshot.SnapshotJobUtils;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.rest.model.SnapshotSourceTableStats;
import org.apache.kylin.rest.response.SnapshotSourceTableStatsResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@Service(value="snapshotSourceTableStatsService")
public class SnapshotSourceTableStatsService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapshotSourceTableStatsService.class);
    private static final String FILES_SIZE = "files_size";
    private static final String FILES_MODIFICATION_TIMES = "files_modification_times";

    public Boolean saveSnapshotViewMapping(String project) {
        try {
            List tables = SnapshotJobUtils.getSnapshotTables((KylinConfig)this.getConfig(), (String)project);
            SessionCatalog catalog = SparderEnv.getSparkSession().sessionState().catalog();
            HashMap viewMapping = Maps.newHashMap();
            for (TableDesc tableDesc : tables) {
                if (!tableDesc.isView()) continue;
                TableIdentifier tableIdentifier = TableIdentifier.apply((String)tableDesc.getName(), (Option)Option.apply((Object)tableDesc.getDatabase()));
                CatalogTable tableMetadata = catalog.getTempViewOrPermanentTableMetadata(tableIdentifier);
                Set<String> sourceTablesTmp = this.getSnapshotSourceTables(tableMetadata);
                HashSet sourceTables = Sets.newHashSet();
                for (String sourceTable : sourceTablesTmp) {
                    String[] split = StringUtils.split((String)sourceTable, (String)".");
                    String source = split.length < 2 ? "default." + sourceTable : sourceTable;
                    sourceTables.add(source);
                }
                viewMapping.put(tableDesc.getIdentity(), sourceTables);
            }
            FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
            String pathStr = this.getConfig().getSnapshotAutoRefreshDir(project) + "view_mapping";
            Path snapshotTablesPath = new Path(pathStr);
            try (FSDataOutputStream out = fileSystem.create(snapshotTablesPath, true);){
                out.write(JsonUtil.writeValueAsBytes((Object)viewMapping));
            }
            log.debug("save snapshot view mapping path : {}", (Object)pathStr);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private Set<String> getSnapshotSourceTables(CatalogTable tableMetadata) {
        Set<Object> viewSourceTables = Sets.newHashSet();
        try {
            viewSourceTables = SparkSqlUtil.getViewOrignalTables((String)tableMetadata.qualifiedName(), (SparkSession)SparderEnv.getSparkSession()).stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            log.info("snapshot[{}] view original tables: [{}]", (Object)tableMetadata.qualifiedName(), (Object)viewSourceTables);
        }
        catch (Exception e) {
            log.error("snapshot[{}] get view original tables error", (Object)tableMetadata.qualifiedName(), (Object)e);
        }
        return viewSourceTables;
    }

    public SnapshotSourceTableStatsResponse checkSourceTableStats(String project, String database, String table, String snapshotPartitionCol) {
        return this.checkSourceTableStats(project, database, table, snapshotPartitionCol, null);
    }

    public SnapshotSourceTableStatsResponse checkSourceTableStats(String project, String database, String table, String snapshotPartitionCol, String catalogName) {
        try {
            boolean needRefresh;
            CopyOnWriteArrayList needRefreshPartitions = Lists.newCopyOnWriteArrayList();
            if (StringUtils.isEmpty((CharSequence)catalogName)) {
                SessionCatalog catalog = SparderEnv.getSparkSession().sessionState().catalog();
                TableIdentifier tableIdentifier = TableIdentifier.apply((String)table, (Option)Option.apply((Object)database));
                CatalogTable tableMetadata = catalog.getTempViewOrPermanentTableMetadata(tableIdentifier);
                needRefresh = this.checkTable(project, catalog, tableMetadata, needRefreshPartitions);
            } else {
                KylinConfigExt projectConfig = NProjectManager.getInstance((KylinConfig)this.getConfig()).getProject(project).getConfig();
                Identifier identifier = Identifier.of((String[])database.split("\\."), (String)table);
                needRefresh = this.checkCatalogTable(project, (KylinConfig)projectConfig, catalogName, identifier);
            }
            SnapshotSourceTableStatsResponse response = this.createSnapshotSourceTableStatsResponse(snapshotPartitionCol, needRefreshPartitions, needRefresh);
            log.info("Project[{}] Snapshot[{}] refresh check and save snapshot table location files response: needRefresh[{}], needRefreshPartitions[{}]", new Object[]{project, table, response.getNeedRefresh(), response.getNeedRefreshPartitionsValue()});
            return response;
        }
        catch (Exception e) {
            log.info("Project[{}] [{}.{}] refresh check and save snapshot table location files failed", new Object[]{project, database, table});
            log.error(e.getMessage(), (Throwable)e);
            return new SnapshotSourceTableStatsResponse(false);
        }
    }

    private SnapshotSourceTableStatsResponse createSnapshotSourceTableStatsResponse(String snapshotPartitionCol, List<CatalogTablePartition> needRefreshPartitions, boolean needRefresh) {
        SnapshotSourceTableStatsResponse response = new SnapshotSourceTableStatsResponse(needRefresh);
        if (needRefresh && StringUtils.isNotBlank((CharSequence)snapshotPartitionCol)) {
            Set<String> partitionsValue = needRefreshPartitions.stream().map(partition -> SnapshotSourceTableStatsService.getPrimaryPartitionValue(snapshotPartitionCol, partition)).filter(Objects::nonNull).filter(Option::isDefined).map(Option::get).collect(Collectors.toSet());
            response.setNeedRefreshPartitionsValue(partitionsValue);
        }
        return response;
    }

    public static Option<String> getPrimaryPartitionValue(String snapshotPartitionCol, CatalogTablePartition partition) {
        scala.collection.immutable.Map spec = partition.spec();
        if (spec.contains((Object)snapshotPartitionCol)) {
            return spec.get((Object)snapshotPartitionCol);
        }
        if (spec.contains((Object)snapshotPartitionCol.toLowerCase(Locale.ROOT))) {
            return spec.get((Object)snapshotPartitionCol.toLowerCase(Locale.ROOT));
        }
        if (spec.contains((Object)snapshotPartitionCol.toUpperCase(Locale.ROOT))) {
            return spec.get((Object)snapshotPartitionCol.toUpperCase(Locale.ROOT));
        }
        return null;
    }

    public Boolean checkTable(String project, SessionCatalog catalog, CatalogTable tableMetadata, List<CatalogTablePartition> needRefreshPartitions) throws IOException {
        KylinConfigExt projectConfig = NProjectManager.getInstance((KylinConfig)this.getConfig()).getProject(project).getConfig();
        String tableIdentity = tableMetadata.qualifiedName().toLowerCase(Locale.ROOT);
        if (!tableMetadata.partitionColumnNames().isEmpty()) {
            return this.checkPartitionHiveTable(project, catalog, tableMetadata, needRefreshPartitions, (KylinConfig)projectConfig, tableIdentity);
        }
        return this.checkHiveTable(project, tableMetadata, (KylinConfig)projectConfig, tableIdentity);
    }

    public boolean checkCatalogTable(String project, KylinConfig projectConfig, String catalogName, Identifier identifier) throws IOException, NoSuchTableException {
        CatalogPlugin catalog = SparderEnv.getSparkSession().sessionState().catalogManager().catalog(catalogName);
        if (catalog instanceof TableCatalog) {
            TableCatalog tableCatalog = (TableCatalog)catalog;
            Table table = tableCatalog.loadTable(identifier);
            String location = (String)table.properties().get("location");
            if (tableCatalog.getClass().toString().contains("iceberg")) {
                location = location + "/metadata";
            }
            return this.checkTableLocation(project, location, projectConfig, catalogName + "." + identifier.toString());
        }
        throw new KylinRuntimeException("unsupported catalog:" + catalog);
    }

    public boolean checkHiveTable(String project, CatalogTable tableMetadata, KylinConfig projectConfig, String tableIdentity) throws IOException {
        String location = tableMetadata.location().getPath();
        return this.checkTableLocation(project, location, projectConfig, tableIdentity);
    }

    private boolean checkTableLocation(String project, String location, KylinConfig projectConfig, String tableIdentity) throws IOException {
        if (this.checkSnapshotSourceTableStatsJsonFile(project, tableIdentity)) {
            log.info("skip checkPartitionHiveTable: last cron task was stopped manually");
            return true;
        }
        Pair<Boolean, Map<String, SnapshotSourceTableStats>> jsonFilePair = this.getSnapshotSourceTableStatsJsonFromHDFS(project, tableIdentity);
        Boolean snapshotSourceTableStatsJsonExist = (Boolean)jsonFilePair.getFirst();
        Map snapshotSourceTableStatsJson = (Map)jsonFilePair.getSecond();
        ArrayList filesStatus = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)location)) {
            return projectConfig.isSnapshotNullLocationAutoRefreshEnabled();
        }
        boolean needRefresh = this.checkLocation(location, filesStatus, snapshotSourceTableStatsJson, projectConfig);
        if (Boolean.FALSE.equals(snapshotSourceTableStatsJsonExist) || Boolean.TRUE.equals(needRefresh)) {
            Map<String, SnapshotSourceTableStats> newSnapshotSourceTableStatsJson = this.createSnapshotSourceTableStats(location, projectConfig, filesStatus);
            this.writeSourceTableStats(project, tableIdentity, newSnapshotSourceTableStatsJson);
        }
        if (Boolean.FALSE.equals(snapshotSourceTableStatsJsonExist)) {
            return projectConfig.isSnapshotFirstAutoRefreshEnabled();
        }
        return needRefresh;
    }

    public boolean checkSnapshotSourceTableStatsJsonFile(String project, String tableIdentity) throws IOException {
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        Path snapshotTablesPath = this.sourceTableStatsFile(tableIdentity, project);
        Path markFilePath = new Path(this.getConfig().getSnapshotAutoRefreshDir(project) + "_mark");
        if (fileSystem.exists(snapshotTablesPath) && fileSystem.exists(markFilePath)) {
            FileStatus snapshotTableFileStatus = fileSystem.getFileStatus(snapshotTablesPath);
            FileStatus markFilePathFileStatus = fileSystem.getFileStatus(markFilePath);
            return markFilePathFileStatus.getModificationTime() < snapshotTableFileStatus.getModificationTime();
        }
        return false;
    }

    public Pair<Boolean, Map<String, SnapshotSourceTableStats>> getSnapshotSourceTableStatsJsonFromHDFS(String project, String tableIdentity) throws IOException {
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        Path snapshotTablesPath = this.sourceTableStatsFile(tableIdentity, project);
        log.info("SnapshotSourceTableStats path : [{}]", (Object)snapshotTablesPath);
        Map result = Maps.newHashMap();
        if (fileSystem.exists(snapshotTablesPath)) {
            try (FSDataInputStream inputStream = fileSystem.open(snapshotTablesPath);){
                result = (Map)JsonUtil.readValue((InputStream)inputStream, (TypeReference)new TypeReference<Map<String, SnapshotSourceTableStats>>(){});
            }
            catch (IOException e) {
                log.error("read SnapshotSourceTableStats path[{}] to SourceTableStats has error", (Object)snapshotTablesPath, (Object)e);
            }
            return new Pair((Object)true, (Object)result);
        }
        return new Pair((Object)false, (Object)result);
    }

    public Path sourceTableStatsFile(String tableIdentity, String project) {
        return new Path(this.getConfig().getSnapshotAutoRefreshDir(project) + "source_table_stats" + "/" + tableIdentity);
    }

    public boolean checkLocation(String location, List<FileStatus> filesStatus, Map<String, SnapshotSourceTableStats> snapshotSourceTableStatsJson, KylinConfig config) throws IOException {
        log.info("check table/partition location: {}", (Object)location);
        filesStatus.addAll(this.getLocationFileStatus(location, config));
        SnapshotSourceTableStats sourceTableStats = snapshotSourceTableStatsJson.get(location);
        if (sourceTableStats == null) {
            log.debug("sourceTableStats is null, sourceTableStatsStatus length is [{}]", (Object)filesStatus.size());
            return CollectionUtils.isNotEmpty(filesStatus);
        }
        if (sourceTableStats.getFilesCount().intValue() != filesStatus.size()) {
            log.debug("sourceTableStats FileCount is [{}], sourceTableStatsStatus length is [{}]", (Object)sourceTableStats.getFilesCount(), (Object)filesStatus.size());
            return true;
        }
        Map<String, List<Long>> tableFilesModifyTimesAndSize = this.getTableFilesModifyTimesAndSize(filesStatus, config);
        if (!CollectionUtils.containsAll((Collection)tableFilesModifyTimesAndSize.get(FILES_MODIFICATION_TIMES), sourceTableStats.getFilesModificationTime()) || !CollectionUtils.containsAll(sourceTableStats.getFilesModificationTime(), (Collection)tableFilesModifyTimesAndSize.get(FILES_MODIFICATION_TIMES))) {
            log.debug("files_modification_times: sourceTableStats is [{}], sourceTableStatsStatus is [{}]", sourceTableStats.getFilesModificationTime(), tableFilesModifyTimesAndSize.get(FILES_MODIFICATION_TIMES));
            return true;
        }
        log.debug("files_size: sourceTableStats is [{}], sourceTableStatsStatus is [{}]", sourceTableStats.getFilesSize(), tableFilesModifyTimesAndSize.get(FILES_SIZE));
        return !CollectionUtils.containsAll((Collection)tableFilesModifyTimesAndSize.get(FILES_SIZE), sourceTableStats.getFilesSize()) || !CollectionUtils.containsAll(sourceTableStats.getFilesSize(), (Collection)tableFilesModifyTimesAndSize.get(FILES_SIZE));
    }

    public Map<String, SnapshotSourceTableStats> createSnapshotSourceTableStats(String location, KylinConfig config, List<FileStatus> locationFilesStatus) {
        HashMap newSnapshotSourceTableStatsJson = Maps.newHashMap();
        SnapshotSourceTableStats sourceTableStats = new SnapshotSourceTableStats();
        ArrayList filesSize = Lists.newArrayList();
        ArrayList filesModificationTime = Lists.newArrayList();
        locationFilesStatus.stream().limit(config.getSnapshotAutoRefreshFetchFilesCount()).forEach(fileStatus -> {
            filesSize.add(fileStatus.getLen());
            filesModificationTime.add(fileStatus.getModificationTime());
        });
        sourceTableStats.setFilesSize(filesSize);
        sourceTableStats.setFilesModificationTime(filesModificationTime);
        sourceTableStats.setFilesCount(locationFilesStatus.size());
        newSnapshotSourceTableStatsJson.put(location, sourceTableStats);
        return newSnapshotSourceTableStatsJson;
    }

    public void writeSourceTableStats(String project, String tableIdentity, Map<String, SnapshotSourceTableStats> snapshotSourceTableStatsJson) {
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        Path snapshotTablesPath = this.sourceTableStatsFile(tableIdentity, project);
        try (FSDataOutputStream out = fileSystem.create(snapshotTablesPath, true);){
            out.write(JsonUtil.writeValueAsBytes(snapshotSourceTableStatsJson));
        }
        catch (IOException e) {
            log.error("overwrite SourceTableStats to path[{}] failed!", (Object)snapshotTablesPath, (Object)e);
            try {
                fileSystem.delete(snapshotTablesPath, true);
            }
            catch (IOException ignore) {
                log.error("Write SourceTableStats failed! Error for delete file: {}", (Object)snapshotTablesPath, (Object)e);
            }
        }
    }

    public boolean checkPartitionHiveTable(String project, SessionCatalog catalog, CatalogTable tableMetadata, List<CatalogTablePartition> needRefreshPartitions, KylinConfig projectConfig, String tableIdentity) throws IOException {
        List partitions = JavaConverters.seqAsJavaList((Seq)catalog.listPartitions(tableMetadata.identifier(), Option.empty()));
        if (this.checkSnapshotSourceTableStatsJsonFile(project, tableIdentity)) {
            List needCheckPartitions = partitions.stream().sorted((ctp1, ctp2) -> Long.compare(ctp2.createTime(), ctp1.createTime())).limit(projectConfig.getSnapshotAutoRefreshFetchPartitionsCount()).collect(Collectors.toList());
            needRefreshPartitions.addAll(needCheckPartitions);
            log.info("skip checkPartitionHiveTable: last cron task was stopped manually");
            return true;
        }
        Pair<Boolean, Map<String, SnapshotSourceTableStats>> jsonFilePair = this.getSnapshotSourceTableStatsJsonFromHDFS(project, tableIdentity);
        Boolean snapshotSourceTableStatsJsonExist = (Boolean)jsonFilePair.getFirst();
        Map snapshotSourceTableStatsJson = (Map)jsonFilePair.getSecond();
        HashMap needSavePartitionsFilesStatus = Maps.newHashMap();
        boolean needRefresh = this.checkPartitionsLocation(partitions, snapshotSourceTableStatsJson, needRefreshPartitions, needSavePartitionsFilesStatus, projectConfig);
        if (Boolean.FALSE.equals(snapshotSourceTableStatsJsonExist) || Boolean.TRUE.equals(needRefresh)) {
            HashMap newSnapshotSourceTableStatsJson = Maps.newHashMap();
            for (CatalogTablePartition partition : partitions) {
                this.createPartitionSnapshotSourceTableStats(partition, needSavePartitionsFilesStatus, newSnapshotSourceTableStatsJson, projectConfig);
            }
            this.writeSourceTableStats(project, tableIdentity, newSnapshotSourceTableStatsJson);
        }
        if (Boolean.FALSE.equals(snapshotSourceTableStatsJsonExist)) {
            return projectConfig.isSnapshotFirstAutoRefreshEnabled();
        }
        return needRefresh;
    }

    public boolean checkPartitionsLocation(List<CatalogTablePartition> partitions, Map<String, SnapshotSourceTableStats> snapshotSourceTableStatsJson, List<CatalogTablePartition> needRefreshPartitions, Map<String, List<FileStatus>> needSavePartitionsFilesStatus, KylinConfig config) throws IOException {
        List<CatalogTablePartition> needCheckPartitions = partitions.stream().sorted((ctp1, ctp2) -> Long.compare(ctp2.createTime(), ctp1.createTime())).limit(config.getSnapshotAutoRefreshFetchPartitionsCount()).collect(Collectors.toList());
        this.putNeedSavePartitionsFilesStatus(needCheckPartitions, needSavePartitionsFilesStatus, config);
        if (partitions.size() != snapshotSourceTableStatsJson.size()) {
            needRefreshPartitions.addAll(needCheckPartitions);
            log.debug("sourceTableStats size is [{}], partitions size is [{}]", (Object)snapshotSourceTableStatsJson.size(), (Object)partitions.size());
            return true;
        }
        boolean result = false;
        for (CatalogTablePartition partition : needCheckPartitions) {
            String location = partition.location().getPath();
            SnapshotSourceTableStats sourceTableStats = snapshotSourceTableStatsJson.get(location);
            if (sourceTableStats != null && sourceTableStats.getCreateTime().longValue() == partition.createTime()) continue;
            needRefreshPartitions.add(partition);
            log.debug("sourceTableStats is {}, partition create is [{}]", (Object)sourceTableStats, (Object)partition.createTime());
            result = true;
        }
        if (result) {
            return true;
        }
        for (CatalogTablePartition partition : needCheckPartitions) {
            ArrayList filesStatus = Lists.newArrayList();
            if (!this.checkLocation(partition.location().getPath(), filesStatus, snapshotSourceTableStatsJson, config)) continue;
            needRefreshPartitions.add(partition);
            result = true;
        }
        return result;
    }

    public void putNeedSavePartitionsFilesStatus(List<CatalogTablePartition> partitions, Map<String, List<FileStatus>> locationsFileStatusMap, KylinConfig config) throws IOException {
        for (CatalogTablePartition partition : partitions) {
            List<FileStatus> filesStatus = this.getLocationFileStatus(partition.location().getPath(), config);
            locationsFileStatusMap.put(partition.location().getPath(), filesStatus);
        }
    }

    public List<FileStatus> getLocationFileStatus(String location, KylinConfig config) throws IOException {
        FileSystem fileSystem = StringUtils.isBlank((CharSequence)config.getWriteClusterWorkingDir()) ? HadoopUtil.getWorkingFileSystem() : HadoopUtil.getWriteClusterFileSystem();
        Path sourceTableStatsPath = new Path(location);
        String pathSchema = sourceTableStatsPath.toUri().getScheme();
        String fileSchema = fileSystem.getUri().getScheme();
        if (pathSchema != null && !pathSchema.equalsIgnoreCase(fileSchema)) {
            fileSystem = sourceTableStatsPath.getFileSystem(SparderEnv.getHadoopConfiguration());
        }
        if (!fileSystem.exists(sourceTableStatsPath)) {
            return Collections.emptyList();
        }
        FileStatus[] fileStatuses = FileSystemUtil.listStatus((FileSystem)fileSystem, (Path)sourceTableStatsPath);
        return Arrays.stream(fileStatuses).sorted((fs1, fs2) -> Long.compare(fs2.getModificationTime(), fs1.getModificationTime())).collect(Collectors.toList());
    }

    public Map<String, List<Long>> getTableFilesModifyTimesAndSize(List<FileStatus> fileStatuses, KylinConfig config) {
        ArrayList fileModificationTimes = Lists.newArrayList();
        ArrayList fileSizes = Lists.newArrayList();
        fileStatuses.stream().limit(config.getSnapshotAutoRefreshFetchFilesCount()).forEach(fileStatus -> {
            fileModificationTimes.add(fileStatus.getModificationTime());
            fileSizes.add(fileStatus.getLen());
        });
        HashMap result = Maps.newHashMap();
        result.put(FILES_MODIFICATION_TIMES, fileModificationTimes);
        result.put(FILES_SIZE, fileSizes);
        return result;
    }

    public void createPartitionSnapshotSourceTableStats(CatalogTablePartition partition, Map<String, List<FileStatus>> locationsFileStatusMap, Map<String, SnapshotSourceTableStats> snapshotSourceTableStatsJson, KylinConfig config) {
        String location = partition.location().getPath();
        SnapshotSourceTableStats sourceTableStats = snapshotSourceTableStatsJson.computeIfAbsent(location, key -> new SnapshotSourceTableStats());
        ArrayList filesSize = Lists.newArrayList();
        ArrayList filesModificationTime = Lists.newArrayList();
        List<FileStatus> partitionFileStatuses = locationsFileStatusMap.getOrDefault(location, Lists.newArrayList());
        partitionFileStatuses.stream().limit(config.getSnapshotAutoRefreshFetchFilesCount()).forEach(fileStatus -> {
            filesSize.add(fileStatus.getLen());
            filesModificationTime.add(fileStatus.getModificationTime());
        });
        sourceTableStats.setFilesSize(filesSize);
        sourceTableStats.setFilesModificationTime(filesModificationTime);
        sourceTableStats.setFilesCount(partitionFileStatuses.size());
        sourceTableStats.setCreateTime(partition.createTime());
        snapshotSourceTableStatsJson.put(location, sourceTableStats);
    }
}

