/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetailsManager;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.metadata.table.InternalTablePartition;

public final class GlutenCacheUtils {
    public static String generateCacheTableCommand(KylinConfig config, String project, String table, String start, List<String> columns, boolean isAsync) {
        InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)config, (String)project);
        InternalTableDesc internalTable = internalTableManager.getInternalTableDesc(table);
        if (Objects.isNull(internalTable)) {
            throw new KylinRuntimeException(String.format(Locale.ROOT, "InternalTable [%s] not exist", table));
        }
        String location = internalTable.generateInternalTableLocation();
        InternalTablePartition tablePartition = internalTable.getTablePartition();
        String filterCommand = "";
        if (Objects.nonNull(tablePartition) && StringUtils.isNotBlank((CharSequence)start)) {
            String partitionColumn = tablePartition.getPartitionColumns()[0];
            String datePartitionFormat = tablePartition.getDatePartitionFormat();
            String formatStart = DateFormat.formatToTimeStr((long)Long.parseLong(start), (String)datePartitionFormat);
            filterCommand = String.format(Locale.ROOT, "AFTER %s AS OF '%s'", partitionColumn, formatStart);
        }
        String selectColumns = "*";
        if (CollectionUtils.isNotEmpty(columns)) {
            Set internalTableColumns = Arrays.stream(internalTable.getColumns()).map(ColumnDesc::getName).collect(Collectors.toSet());
            Sets.SetView notExistColumns = Sets.difference((Set)Sets.newHashSet(columns), internalTableColumns);
            if (CollectionUtils.isNotEmpty((Collection)notExistColumns)) {
                throw new KylinRuntimeException(String.format(Locale.ROOT, "InternalTable[%s] column[%s] not exist", table, notExistColumns));
            }
            selectColumns = String.join((CharSequence)",", columns);
        }
        String async = isAsync ? "ASYNC" : "";
        return String.format(Locale.ROOT, "CACHE DATA %s SELECT %s FROM '%s' %s", async, selectColumns, location, filterCommand);
    }

    public static Set<String> generateModelCacheCommands(KylinConfig config, String project, String modelId, List<String> targetSegments) {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        NDataModel dataModelDesc = modelManager.getDataModelDesc(modelId);
        HashSet cachePaths = Sets.newHashSet();
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        NDataflow dataflow = dfMgr.getDataflow(modelId);
        Segments segments = dataflow.getSegments((Set)Sets.newHashSet(targetSegments));
        switch (dataModelDesc.getStorageType()) {
            case V1: {
                Set segmentPath = segments.stream().map(seg -> dataflow.getSegmentHdfsPath(seg.getId())).collect(Collectors.toSet());
                cachePaths.addAll(segmentPath);
                break;
            }
            case DELTA: {
                NDataLayoutDetailsManager layoutDetailsManager = NDataLayoutDetailsManager.getInstance((KylinConfig)config, (String)project);
                Set indexLocations = segments.stream().map(NDataSegment::getLayoutIds).flatMap(Collection::stream).collect(Collectors.toSet()).stream().map(id -> layoutDetailsManager.getNDataLayoutDetails(modelId, id.longValue()).getLocation()).collect(Collectors.toSet());
                cachePaths.addAll(indexLocations);
                break;
            }
            default: {
                throw new KylinRuntimeException(String.format(Locale.ROOT, "Model StorageType[%s] not support load gluten cache", dataModelDesc.getStorageType()));
            }
        }
        return cachePaths.stream().map(path -> String.format(Locale.ROOT, "CACHE FILES %s SELECT * FROM '%s' CACHEPROPERTIES (recursive=true)", "", path)).collect(Collectors.toSet());
    }

    public static Set<String> generateModelCacheCommandsByIndexes(KylinConfig config, String project, String modelId, List<Long> indexes) {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        NDataModel dataModelDesc = modelManager.getDataModelDesc(modelId);
        HashSet cachePaths = Sets.newHashSet();
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        NDataflow df = dfMgr.getDataflow(modelId);
        Set cacheIndexes = df.getIndexPlan().getAllLayouts().stream().map(LayoutEntity::getId).filter(id -> CollectionUtils.isEmpty((Collection)indexes) || indexes.contains(id)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(indexes) && indexes.size() != cacheIndexes.size()) {
            Sets.SetView notExistIndexes = Sets.difference((Set)Sets.newHashSet(indexes), cacheIndexes);
            throw new KylinRuntimeException(String.format(Locale.ROOT, "Model[%s] indexes[%s] not exist", modelId, notExistIndexes));
        }
        if (Objects.requireNonNull(dataModelDesc.getStorageType()) != NDataModel.DataStorageType.DELTA) {
            throw new KylinRuntimeException(String.format(Locale.ROOT, "Model StorageType[%s] not support load gluten cache by indexes", dataModelDesc.getStorageType()));
        }
        NDataLayoutDetailsManager layoutDetailsManager = NDataLayoutDetailsManager.getInstance((KylinConfig)config, (String)project);
        Set indexLocations = cacheIndexes.stream().map(id -> layoutDetailsManager.getNDataLayoutDetails(modelId, id.longValue()).getLocation()).collect(Collectors.toSet());
        cachePaths.addAll(indexLocations);
        return cachePaths.stream().map(path -> String.format(Locale.ROOT, "CACHE FILES %s SELECT * FROM '%s' CACHEPROPERTIES (recursive=true)", "ASYNC", path)).collect(Collectors.toSet());
    }

    public static Set<String> generateModelCacheCommandsBySegments(KylinConfig config, String project, String modelId, Segments<NDataSegment> segments) {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        NDataModel dataModelDesc = modelManager.getDataModelDesc(modelId);
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        NDataflow dataflow = dfMgr.getDataflow(modelId);
        HashSet cachePaths = Sets.newHashSet();
        if (Objects.requireNonNull(dataModelDesc.getStorageType()) != NDataModel.DataStorageType.V1) {
            throw new KylinRuntimeException(String.format(Locale.ROOT, "Model StorageType[%s] not support load gluten cache by segments", dataModelDesc.getStorageType()));
        }
        Set segmentPath = segments.stream().map(seg -> dataflow.getSegmentHdfsPath(seg.getId())).collect(Collectors.toSet());
        cachePaths.addAll(segmentPath);
        return cachePaths.stream().map(path -> String.format(Locale.ROOT, "CACHE FILES %s SELECT * FROM '%s' CACHEPROPERTIES (recursive=true)", "ASYNC", path)).collect(Collectors.toSet());
    }

    @Generated
    private GlutenCacheUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

