/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.model.planner;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;

public class CuboIdToLayoutUtils {
    public static Set<List<Integer>> convertCuboIdsToAggIndexColOrders(Map<BigInteger, Long> cuboids, RuleBasedIndex ruleBasedIndex) {
        HashSet<List<Integer>> result = new HashSet<List<Integer>>();
        List aggregationGroups = ruleBasedIndex != null ? ruleBasedIndex.getAggregationGroups() : Lists.newArrayList();
        for (NAggregationGroup group : aggregationGroups) {
            ArrayList dimensionOrder = Lists.newArrayList((Object[])group.getIncludes());
            ArrayList measuresIds = Lists.newArrayList((Object[])group.getMeasures());
            Set<List<Integer>> colOrders = CuboIdToLayoutUtils.convertCuboIdsToColOrders(cuboids, ruleBasedIndex.countOfIncludeDimension(), measuresIds, ruleBasedIndex.getRowKeyIdToColumnId(), dimensionOrder);
            result.addAll(colOrders);
        }
        for (NAggregationGroup group : aggregationGroups) {
            ArrayList colOrders = Lists.newArrayList();
            colOrders.addAll(Lists.newArrayList((Object[])group.getIncludes()));
            colOrders.addAll(Lists.newArrayList((Object[])group.getMeasures()));
            result.add(colOrders);
        }
        return result;
    }

    protected static Set<List<Integer>> convertCuboIdsToColOrders(Map<BigInteger, Long> cuboids, int dimensionCount, List<Integer> measuresIds, Map<Integer, Integer> rowkeyIdToColumnId, List<Integer> sortOfDims) {
        HashSet<List<Integer>> result = new HashSet<List<Integer>>();
        for (BigInteger cuboid : cuboids.keySet()) {
            List<Integer> colOrder = CuboIdToLayoutUtils.converCuboidToDimensionColOrder(cuboid, dimensionCount, rowkeyIdToColumnId, sortOfDims);
            if (colOrder.isEmpty()) continue;
            colOrder.addAll(measuresIds);
            result.add(colOrder);
        }
        return result;
    }

    public static List<Integer> converCuboidToDimensionColOrder(BigInteger cuboid, int maxDimensionCount, Map<Integer, Integer> rowkeyIdToColumnId, final List<Integer> sortOfDims) {
        ArrayList<Integer> colOrder = new ArrayList<Integer>();
        for (int rowkeyId = 0; rowkeyId < maxDimensionCount; ++rowkeyId) {
            int rightShift = maxDimensionCount - rowkeyId - 1;
            boolean exist = cuboid.testBit(rightShift);
            if (!exist) continue;
            if (!rowkeyIdToColumnId.containsKey(rowkeyId)) {
                throw new RuntimeException("Can't find the column id from the rowkey id");
            }
            int columnId = rowkeyIdToColumnId.get(rowkeyId);
            if (sortOfDims.indexOf(columnId) < 0) {
                colOrder.clear();
                break;
            }
            colOrder.add(columnId);
        }
        if (!colOrder.isEmpty()) {
            Collections.sort(colOrder, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    int index1 = sortOfDims.indexOf(o1);
                    int index2 = sortOfDims.indexOf(o2);
                    return index1 - index2;
                }
            });
        }
        return colOrder;
    }
}

