/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkCleanupAfterMergeStep;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.NSparkMergingStep;
import org.apache.kylin.engine.spark.job.StepEnum;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableParams;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.job.JobBucket;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkMergingJob
extends DefaultExecutableOnModel {
    private static final Logger logger = LoggerFactory.getLogger(NSparkMergingJob.class);

    public NSparkMergingJob() {
    }

    public NSparkMergingJob(Object notSetId) {
        super(notSetId);
    }

    public static NSparkMergingJob merge(NDataSegment mergedSegment, Set<LayoutEntity> layouts, String submitter, String jobId) {
        return NSparkMergingJob.merge(mergedSegment, layouts, submitter, jobId, null, null);
    }

    public static NSparkMergingJob merge(NDataSegment mergedSegment, Set<LayoutEntity> layouts, String submitter, String jobId, Set<Long> partitions, Set<JobBucket> buckets) {
        Preconditions.checkArgument((mergedSegment != null ? 1 : 0) != 0);
        Preconditions.checkArgument((submitter != null ? 1 : 0) != 0);
        NDataflow df = mergedSegment.getDataflow();
        if (layouts == null) {
            layouts = Sets.newHashSet((Iterable)df.getIndexPlan().getAllLayouts());
        }
        NSparkMergingJob job = new NSparkMergingJob();
        job.setName(JobTypeEnum.INDEX_MERGE.toString());
        job.setJobType(JobTypeEnum.INDEX_MERGE);
        job.setId(jobId);
        job.setTargetSubject(mergedSegment.getModel().getUuid());
        job.setTargetSegments(Lists.newArrayList((Object[])new String[]{String.valueOf(mergedSegment.getId())}));
        job.setProject(mergedSegment.getProject());
        job.setSubmitter(submitter);
        if (CollectionUtils.isNotEmpty(partitions)) {
            job.setTargetPartitions(partitions);
            job.setParam("partitionIds", job.getTargetPartitions().stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        if (CollectionUtils.isNotEmpty(buckets)) {
            job.setParam("buckets", ExecutableParams.toBucketParam(buckets));
        }
        job.setParam("jobId", jobId);
        job.setParam("project", df.getProject());
        job.setParam("targetModel", job.getTargetSubject());
        job.setParam("dataflowId", df.getId());
        job.setParam("layoutIds", NSparkCubingUtil.ids2Str((Set)NSparkCubingUtil.toLayoutIds((Set)layouts)));
        job.setParam("segmentIds", String.join((CharSequence)",", job.getTargetSegments()));
        job.setParam("dataRangeStart", mergedSegment.getSegRange().getStart().toString());
        job.setParam("dataRangeEnd", mergedSegment.getSegRange().getEnd().toString());
        KylinConfigExt config = df.getConfig();
        StepEnum.RESOURCE_DETECT.create((DefaultExecutable)job, (KylinConfig)config);
        StepEnum.MERGING.create((DefaultExecutable)job, (KylinConfig)config);
        AbstractExecutable cleanStep = StepEnum.CLEANUP_AFTER_MERGE.create((DefaultExecutable)job, (KylinConfig)config);
        Segments mergingSegments = df.getMergingSegments(mergedSegment);
        cleanStep.setParam("segmentIds", String.join((CharSequence)",", NSparkCubingUtil.toSegmentIds((Segments)mergingSegments)));
        StepEnum.UPDATE_METADATA.create((DefaultExecutable)job, (KylinConfig)config);
        if (config.isIndexPreloadCacheEnabled()) {
            StepEnum.LOAD_GLUTEN_CACHE.create((DefaultExecutable)job, (KylinConfig)config);
        }
        return job;
    }

    public Set<String> getMetadataDumpList(KylinConfig config) {
        String dataflowId = this.getParam("dataflowId");
        return NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject()).getDataflow(dataflowId).collectPrecalculationResource();
    }

    public NSparkMergingStep getSparkMergingStep() {
        return (NSparkMergingStep)this.getTask(NSparkMergingStep.class);
    }

    public NResourceDetectStep getResourceDetectStep() {
        return (NResourceDetectStep)this.getTask(NResourceDetectStep.class);
    }

    public NSparkCleanupAfterMergeStep getCleanUpAfterMergeStep() {
        return (NSparkCleanupAfterMergeStep)this.getTask(NSparkCleanupAfterMergeStep.class);
    }

    public void cancelJob() {
        NDataflowManager nDataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflow dataflow = nDataflowManager.getDataflow(this.getSparkMergingStep().getDataflowId());
        if (dataflow == null) {
            logger.debug("Dataflow is null, maybe model is deleted?");
            return;
        }
        ArrayList<NDataSegment> toRemovedSegments = new ArrayList<NDataSegment>();
        for (String id : this.getSparkMergingStep().getSegmentIds()) {
            NDataSegment segment = dataflow.getSegment(id);
            if (segment == null || SegmentStatusEnum.READY == segment.getStatus() || SegmentStatusEnum.WARNING == segment.getStatus()) continue;
            toRemovedSegments.add(segment);
        }
        if (toRemovedSegments.isEmpty()) {
            logger.warn("Segment related to job {} can not be found, maybe job has been canceled.", (Object)this.getJobId());
            return;
        }
        NDataflowUpdate nDataflowUpdate = new NDataflowUpdate(dataflow.getUuid());
        nDataflowUpdate.setToRemoveSegs(toRemovedSegments.toArray(new NDataSegment[0]));
        NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject()).updateDataflow(nDataflowUpdate);
    }

    static {
        JobFactory.register((String)"MERGE_JOB_FACTORY", (JobFactory)new MergingJobFactory());
    }

    static class MergingJobFactory
    extends JobFactory {
        private MergingJobFactory() {
        }

        protected NSparkMergingJob create(JobFactory.JobBuildParams jobBuildParams) {
            if (jobBuildParams.getSegments() == null || jobBuildParams.getSegments().size() != 1) {
                return null;
            }
            return NSparkMergingJob.merge((NDataSegment)jobBuildParams.getSegments().iterator().next(), jobBuildParams.getLayouts(), jobBuildParams.getSubmitter(), jobBuildParams.getJobId(), jobBuildParams.getPartitions(), jobBuildParams.getBuckets());
        }
    }
}

