/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.StageExecutable;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.spark.sql.datasource.storage.StorageStore;
import org.apache.spark.sql.datasource.storage.StorageStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkCubingStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkCubingStep.class);

    public NSparkCubingStep(String sparkSubmitClassName) {
        this.setSparkSubmitClassName(sparkSubmitClassName);
        this.setName("Load Data To Index");
    }

    public NSparkCubingStep(Object notSetId) {
        super(notSetId);
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        NDataflow df = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject()).getDataflow(this.getDataflowId());
        dumpList.addAll(df.collectPrecalculationResource());
        dumpList.addAll(this.getLogicalViewMetaDumpList(config));
        return dumpList;
    }

    @Override
    public boolean needMergeMetadata() {
        return true;
    }

    public Set<String> getDependencies(KylinConfig config) {
        String dataflowId = this.getDataflowId();
        Set<String> segmentIds = this.getSegmentIds();
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject());
        NDataflow dataflow = dfMgr.getDataflow(dataflowId);
        IndexPlan indexPlan = dataflow.getIndexPlan();
        HashSet result = Sets.newHashSet();
        StorageStore storageStore = StorageStoreFactory.create((NDataModel.DataStorageType)dataflow.getModel().getStorageType());
        for (String segId : segmentIds) {
            NDataSegment seg = dfMgr.getDataflow(dataflowId).getSegment(segId);
            for (LayoutEntity layout : indexPlan.getAllLayouts()) {
                String path = "/" + storageStore.getStoragePathWithoutPrefix(this.project, dataflowId, segId, layout.getId());
                result.add(new Path(path).getParent().toString());
            }
        }
        NDataModel model = indexPlan.getModel();
        model.getJoinTables().forEach(lookupDesc -> {
            TableDesc tableDesc = lookupDesc.getTableRef().getTableDesc();
            boolean isLookupTable = model.isLookupTable(lookupDesc.getTableRef());
            if (isLookupTable) {
                String tablePath = "/" + tableDesc.getProject() + "/table_snapshot" + "/" + tableDesc.getName();
                result.add(tablePath);
            }
        });
        return result;
    }

    protected ExecutableState adjustState(ExecutableState originalState) {
        if (this.hasWarningStage()) {
            return ExecutableState.WARNING;
        }
        return super.adjustState(originalState);
    }

    protected boolean hasWarningStage() {
        ExecutableManager executableManager = this.getManager();
        Map<String, List<StageExecutable>> stagesMap = this.getStagesMap();
        for (Map.Entry<String, List<StageExecutable>> entry : stagesMap.entrySet()) {
            String segmentId = entry.getKey();
            List<StageExecutable> stages = entry.getValue();
            boolean hasWarning = stages.stream().anyMatch(stage -> executableManager.getOutput(stage.getId(), segmentId).getState() == ExecutableState.WARNING);
            if (!hasWarning) continue;
            return true;
        }
        return false;
    }

    @Generated
    public NSparkCubingStep() {
    }

    public static class Mockup {
        public static void main(String[] args) {
            logger.info(Mockup.class + ".main() invoked, args: " + Arrays.toString(args));
        }
    }
}

