/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.engine.spark.job.LoadCacheStep;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.utils.GlutenCacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelIndexLoadCacheStep
extends LoadCacheStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelIndexLoadCacheStep.class);

    public ModelIndexLoadCacheStep() {
    }

    public ModelIndexLoadCacheStep(Object notSetId) {
        super(notSetId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecuteResult doWork(JobContext context) throws ExecuteException {
        try (SetLogCategory ignore = new SetLogCategory("build");){
            AbstractExecutable parent = this.getParent();
            String project = parent.getProject();
            String modelId = parent.getTargetModelId();
            List targetSegments = parent.getTargetSegments();
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            Set<String> cacheCommands = GlutenCacheUtils.generateModelCacheCommands(config, project, modelId, targetSegments);
            if (CollectionUtils.isNotEmpty(cacheCommands)) {
                log.info("Model[{}] cache commands is [{}]", (Object)modelId, (Object)String.join((CharSequence)";", cacheCommands));
                this.routeCacheToAllQueryNode(project, cacheCommands);
            } else {
                log.warn("Model[{}] cache commands is blank", (Object)modelId);
            }
            ExecuteResult executeResult = ExecuteResult.createSucceed();
            return executeResult;
        }
        catch (Throwable throwable6) {
            log.warn("ModelIndexLoadCache routeCacheToAllQueryNode failed.", throwable6);
            return ExecuteResult.createError((Throwable)throwable6);
        }
    }
}

