/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.substrait.rel.IcebergLocalFilesBuilder;
import org.apache.gluten.substrait.rel.IcebergLocalFilesNode;
import org.apache.gluten.substrait.rel.LocalFilesNode;
import org.apache.gluten.substrait.rel.SplitInfo;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkBatchQueryScan;
import org.apache.iceberg.spark.source.SparkInputPartition;
import org.apache.iceberg.spark.source.TypeUtil$;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.softaffinity.SoftAffinity$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public final class GlutenIcebergSourceUtil$ {
    public static GlutenIcebergSourceUtil$ MODULE$;

    static {
        new GlutenIcebergSourceUtil$();
    }

    public SplitInfo genSplitInfo(InputPartition inputPartition, int index, StructType readPartitionSchema) {
        InputPartition inputPartition2 = inputPartition;
        if (!(inputPartition2 instanceof SparkInputPartition)) {
            throw new UnsupportedOperationException("Only support iceberg SparkInputPartition.");
        }
        SparkInputPartition sparkInputPartition = (SparkInputPartition)inputPartition2;
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<Long> starts = new ArrayList<Long>();
        ArrayList<Long> lengths = new ArrayList<Long>();
        ArrayList<Map<String, String>> partitionColumns = new ArrayList<Map<String, String>>();
        ArrayList<java.util.List<DeleteFile>> deleteFilesList = new ArrayList<java.util.List<DeleteFile>>();
        ObjectRef fileFormat = ObjectRef.create((Object)LocalFilesNode.ReadFileFormat.UnknownFormat);
        Iterable tasks = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(sparkInputPartition.taskGroup().tasks()).asScala();
        this.asFileScanTask((List<ScanTask>)tasks.toList()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            GlutenIcebergSourceUtil$.$anonfun$genSplitInfo$1(paths, starts, lengths, partitionColumns, readPartitionSchema, deleteFilesList, fileFormat, task);
            return BoxedUnit.UNIT;
        });
        String[] preferredLoc = SoftAffinity$.MODULE$.getFilePartitionLocations((String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(paths).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), inputPartition.preferredLocations());
        IcebergLocalFilesNode icebergLocalFilesNode = IcebergLocalFilesBuilder.makeIcebergLocalFiles(Predef$.MODULE$.int2Integer(index), paths, starts, lengths, partitionColumns, (LocalFilesNode.ReadFileFormat)fileFormat.elem, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])preferredLoc)).toList()).asJava(), deleteFilesList);
        return icebergLocalFilesNode;
    }

    public LocalFilesNode.ReadFileFormat getFileFormat(Scan sparkScan) {
        Object object = new Object();
        try {
            Scan scan = sparkScan;
            if (scan instanceof SparkBatchQueryScan) {
                SparkBatchQueryScan sparkBatchQueryScan = (SparkBatchQueryScan)scan;
                Buffer tasks = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(sparkBatchQueryScan.tasks()).asScala();
                this.asFileScanTask((List<ScanTask>)tasks.toList()).foreach((Function1 & Serializable & scala.Serializable)task -> {
                    GlutenIcebergSourceUtil$.$anonfun$getFileFormat$1(object, task);
                    return BoxedUnit.UNIT;
                });
                throw new GlutenNotSupportException("Iceberg Only support parquet and orc file format.");
            }
            throw new GlutenNotSupportException("Only support iceberg SparkBatchQueryScan.");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (LocalFilesNode.ReadFileFormat)ex.value();
        }
    }

    public StructType getReadPartitionSchema(Scan sparkScan) {
        Object object = new Object();
        try {
            Scan scan = sparkScan;
            if (scan instanceof SparkBatchQueryScan) {
                SparkBatchQueryScan sparkBatchQueryScan = (SparkBatchQueryScan)scan;
                Buffer tasks = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(sparkBatchQueryScan.tasks()).asScala();
                this.asFileScanTask((List<ScanTask>)tasks.toList()).foreach((Function1 & Serializable & scala.Serializable)task -> {
                    PartitionSpec spec = task.spec();
                    if (spec.isPartitioned()) {
                        Set readFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkBatchQueryScan.readSchema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
                        Set tableFields = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.schema().columns()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Buffer$.MODULE$.canBuildFrom())).toSet();
                        Set voidTransformFields = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sparkBatchQueryScan.table().spec().fields()).asScala()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GlutenIcebergSourceUtil$.$anonfun$getReadPartitionSchema$4(f)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Buffer$.MODULE$.canBuildFrom())).toSet();
                        Buffer partitionFields = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.partitionType().fields()).asScala()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GlutenIcebergSourceUtil$.$anonfun$getReadPartitionSchema$6(tableFields, readFields, f)))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GlutenIcebergSourceUtil$.$anonfun$getReadPartitionSchema$7(voidTransformFields, f)));
                        partitionFields.foreach((Function1 & Serializable & scala.Serializable)field -> {
                            TypeUtil$.MODULE$.validatePartitionColumnType(field.type().typeId());
                            return BoxedUnit.UNIT;
                        });
                        Schema icebergSchema = new Schema((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionFields.toList()).asJava());
                        throw new NonLocalReturnControl(object, (Object)SparkSchemaUtil.convert((Schema)icebergSchema));
                    }
                    throw new NonLocalReturnControl(object, (Object)new StructType());
                });
                throw new UnsupportedOperationException("Failed to get partition schema from iceberg SparkBatchQueryScan.");
            }
            throw new UnsupportedOperationException("Only support iceberg SparkBatchQueryScan.");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (StructType)ex.value();
        }
    }

    private List<FileScanTask> asFileScanTask(List<ScanTask> tasks) {
        List list;
        if (tasks.forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isFileScanTask()))) {
            list = (List)tasks.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.asFileScanTask(), List$.MODULE$.canBuildFrom());
        } else if (tasks.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GlutenIcebergSourceUtil$.$anonfun$asFileScanTask$3(x$6)))) {
            list = (List)tasks.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$7.asCombinedScanTask().tasks()).asScala(), List$.MODULE$.canBuildFrom());
        } else {
            throw new UnsupportedOperationException("Only support iceberg CombinedScanTask and FileScanTask.");
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> getPartitionColumns(FileScanTask task, StructType readPartitionSchema) {
        void var3_3;
        block0: {
            HashMap partitionColumns = new HashMap();
            Set readPartitionFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readPartitionSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
            PartitionSpec spec = task.spec();
            StructLike partition = task.partition();
            if (!spec.isPartitioned()) break block0;
            Buffer partitionFields = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.partitionType().fields()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)readPartitionFields.contains((Object)((Types.NestedField)f._1()).name())));
            partitionFields.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Types.NestedField field = (Types.NestedField)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Object partitionValue = partition.get(index, field.type().typeId().javaClass());
                Type partitionType = field.type();
                String string = partitionValue != null ? partitionColumns.put(field.name(), TypeUtil$.MODULE$.getPartitionValueString(partitionType, partitionValue)) : partitionColumns.put(field.name(), ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME());
                return string;
            });
        }
        return var3_3;
    }

    public LocalFilesNode.ReadFileFormat convertFileFormat(FileFormat icebergFileFormat) {
        LocalFilesNode.ReadFileFormat readFileFormat;
        FileFormat fileFormat = icebergFileFormat;
        if (FileFormat.PARQUET.equals(fileFormat)) {
            readFileFormat = LocalFilesNode.ReadFileFormat.ParquetReadFormat;
        } else if (FileFormat.ORC.equals(fileFormat)) {
            readFileFormat = LocalFilesNode.ReadFileFormat.OrcReadFormat;
        } else {
            throw new GlutenNotSupportException("Iceberg Only support parquet and orc file format.");
        }
        return readFileFormat;
    }

    public static final /* synthetic */ void $anonfun$genSplitInfo$1(ArrayList paths$1, ArrayList starts$1, ArrayList lengths$1, ArrayList partitionColumns$1, StructType readPartitionSchema$1, ArrayList deleteFilesList$1, ObjectRef fileFormat$1, FileScanTask task) {
        paths$1.add(BackendsApiManager$.MODULE$.getTransformerApiInstance().encodeFilePathIfNeed(((Object)task.file().path()).toString()));
        starts$1.add(Predef$.MODULE$.long2Long(task.start()));
        lengths$1.add(Predef$.MODULE$.long2Long(task.length()));
        partitionColumns$1.add(MODULE$.getPartitionColumns(task, readPartitionSchema$1));
        deleteFilesList$1.add(task.deletes());
        LocalFilesNode.ReadFileFormat currentFileFormat = MODULE$.convertFileFormat(task.file().format());
        LocalFilesNode.ReadFileFormat readFileFormat = (LocalFilesNode.ReadFileFormat)fileFormat$1.elem;
        LocalFilesNode.ReadFileFormat readFileFormat2 = LocalFilesNode.ReadFileFormat.UnknownFormat;
        if (!(readFileFormat != null ? !readFileFormat.equals(readFileFormat2) : readFileFormat2 != null)) {
            fileFormat$1.elem = currentFileFormat;
        } else {
            LocalFilesNode.ReadFileFormat readFileFormat3 = (LocalFilesNode.ReadFileFormat)fileFormat$1.elem;
            LocalFilesNode.ReadFileFormat readFileFormat4 = currentFileFormat;
            if (readFileFormat3 == null ? readFileFormat4 != null : !readFileFormat3.equals(readFileFormat4)) {
                throw new UnsupportedOperationException(new StringBuilder(67).append("Only one file format is supported, ").append("find different file format ").append((LocalFilesNode.ReadFileFormat)fileFormat$1.elem).append(" and ").append(currentFileFormat).toString());
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getFileFormat$1(Object nonLocalReturnKey1$1, FileScanTask task) {
        FileFormat fileFormat = task.file().format();
        if (FileFormat.PARQUET.equals(fileFormat)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)LocalFilesNode.ReadFileFormat.ParquetReadFormat);
        }
        if (FileFormat.ORC.equals(fileFormat)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)LocalFilesNode.ReadFileFormat.OrcReadFormat);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getReadPartitionSchema$4(PartitionField f) {
        return f.transform().isVoid();
    }

    public static final /* synthetic */ boolean $anonfun$getReadPartitionSchema$6(Set tableFields$1, Set readFields$1, Types.NestedField f) {
        return !tableFields$1.contains((Object)f.name()) || readFields$1.contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$getReadPartitionSchema$7(Set voidTransformFields$1, Types.NestedField f) {
        return !voidTransformFields$1.contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$asFileScanTask$3(ScanTask x$6) {
        return x$6 instanceof CombinedScanTask;
    }

    private GlutenIcebergSourceUtil$() {
        MODULE$ = this;
    }
}

