/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.logging;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfigMultithreadingTest;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.logging.log4j.ThreadContext;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.test.util.ReflectionTestUtils;

class SetLogCategoryTest {
    SetLogCategoryTest() {
    }

    @AfterEach
    @BeforeEach
    void beforeAndAfter() {
        ThreadContext.remove((String)"logCategory");
    }

    @Test
    void testMulti() throws Exception {
        ArrayList callables = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            Callable<String> callable = () -> {
                this.checkSetLogCategory();
                return "ok";
            };
            callables.add(callable);
        }
        KylinConfigMultithreadingTest.concurrentTest(100L, 10, callables);
    }

    private void checkSetLogCategory() {
        this.checkResult(null, Lists.newArrayList(), 0);
        String category0 = RandomUtil.randomUUIDStr();
        try (SetLogCategory logCategory = new SetLogCategory(category0);){
            this.checkResult(category0, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory}), 0);
        }
        this.checkResult(null, Lists.newArrayList(), 0);
        String category1 = RandomUtil.randomUUIDStr();
        String category2 = RandomUtil.randomUUIDStr();
        String category3 = RandomUtil.randomUUIDStr();
        String category4 = RandomUtil.randomUUIDStr();
        String category5 = RandomUtil.randomUUIDStr();
        try (SetLogCategory logCategory1 = new SetLogCategory(category1);){
            this.checkResult(category1, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory1}), 0);
            try (SetLogCategory logCategory2 = new SetLogCategory(category2);){
                this.checkResult(category2, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory1, logCategory2}), 1);
            }
            this.checkResult(category1, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory1}), 0);
            var10_16 = null;
            try (SetLogCategory logCategory3 = new SetLogCategory(category3);){
                this.checkResult(category3, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory1, logCategory3}), 1);
                try (SetLogCategory logCategory4 = new SetLogCategory(category4);){
                    this.checkResult(category4, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory1, logCategory3, logCategory4}), 2);
                    try (SetLogCategory logCategory5 = new SetLogCategory(category5);){
                        this.checkResult(category5, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory1, logCategory3, logCategory4, logCategory5}), 3);
                    }
                    this.checkResult(category4, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory1, logCategory3, logCategory4}), 2);
                }
                this.checkResult(category3, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory1, logCategory3}), 1);
            }
            catch (Throwable throwable) {
                var10_16 = throwable;
                throw throwable;
            }
            this.checkResult(category1, Lists.newArrayList((Object[])new SetLogCategory[]{logCategory1}), 0);
        }
        this.checkResult(null, Lists.newArrayList(), 0);
    }

    private void checkResult(String category, List<SetLogCategory> logCategories, int size) {
        this.checkCategory(category);
        this.checkCategoryThreadLocal(logCategories, size);
    }

    private void checkCategory(String category) {
        Awaitility.await().pollDelay(new Duration((long)RandomUtil.nextInt((int)90, (int)100), TimeUnit.MILLISECONDS)).until(() -> true);
        Assertions.assertEquals((Object)category, (Object)ThreadContext.get((String)"logCategory"));
    }

    private void checkCategoryThreadLocal(List<SetLogCategory> logCategories, int size) {
        for (SetLogCategory logCategory : logCategories) {
            ThreadLocal categoryThreadLocal = (ThreadLocal)ReflectionTestUtils.getField((Object)logCategory, (String)"categoryThreadLocal");
            Assertions.assertNotNull((Object)categoryThreadLocal);
            Assertions.assertEquals((int)size, (int)((Deque)categoryThreadLocal.get()).size());
        }
        ThreadLocal categoryThreadLocalStatic = (ThreadLocal)ReflectionTestUtils.getField(SetLogCategory.class, (String)"categoryThreadLocal");
        Assertions.assertNotNull((Object)categoryThreadLocalStatic);
        Assertions.assertEquals((int)size, (int)((Deque)categoryThreadLocalStatic.get()).size());
    }
}

