/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.dict;

import com.alibaba.nacos.common.JustForTest;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.spark.dict.IllegalDictEncodeValueException;
import org.apache.spark.dict.NGlobalDictMetaInfo;
import org.apache.spark.dict.NGlobalDictS3Store;
import org.apache.spark.dict.NGlobalDictStore;
import org.apache.spark.dict.NGlobalDictStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBucketDictionary {
    protected static final Logger logger = LoggerFactory.getLogger(NBucketDictionary.class);
    private String workingDir;
    private int bucketId;
    private long buildVersion;
    private Object2LongMap<String> absoluteDictMap;
    private Object2LongMap<String> relativeDictMap;

    private void initDictMap(int bucketId, NGlobalDictMetaInfo metainfo, boolean isForColumnEncoding, long buildVersion, NGlobalDictStore globalDictStore) throws IOException {
        Long[] versions = globalDictStore.listAllVersions();
        logger.debug("versions.length is {}", (Object)versions.length);
        if (versions.length == 0) {
            this.absoluteDictMap = new Object2LongOpenHashMap();
        } else if (buildVersion == -1L || !Arrays.asList(versions).contains(buildVersion)) {
            logger.info("Initializes dict map with the latest version:{}", (Object)versions[versions.length - 1]);
            this.absoluteDictMap = globalDictStore.getBucketDict(versions[versions.length - 1], metainfo, bucketId, isForColumnEncoding);
        } else {
            logger.info("Initializes dict map with the specified version:{}", (Object)buildVersion);
            this.absoluteDictMap = globalDictStore.getBucketDict(buildVersion, metainfo, bucketId, isForColumnEncoding);
        }
        this.relativeDictMap = new Object2LongOpenHashMap();
    }

    private void initDictMap(String baseDir, int bucketId, NGlobalDictMetaInfo metainfo, boolean isForColumnEncoding, long buildVersion) throws IOException {
        NGlobalDictStore globalDictStore = NGlobalDictStoreFactory.getResourceStore(baseDir);
        this.initDictMap(bucketId, metainfo, isForColumnEncoding, buildVersion, globalDictStore);
    }

    @JustForTest
    private void initDictMapForS3Test(String baseDir, int bucketId, NGlobalDictMetaInfo metainfo, boolean isForColumnEncoding, long buildVersion) throws IOException {
        NGlobalDictS3Store globalDictStore = new NGlobalDictS3Store(baseDir);
        this.initDictMap(bucketId, metainfo, isForColumnEncoding, buildVersion, globalDictStore);
    }

    @JustForTest
    NBucketDictionary(String baseDir, String workingDir, int bucketId, NGlobalDictMetaInfo metainfo, boolean isForColumnEncoding, long buildVersion, boolean justForTest) throws IOException {
        this.workingDir = workingDir;
        this.bucketId = bucketId;
        this.buildVersion = buildVersion;
        this.initDictMapForS3Test(baseDir, bucketId, metainfo, isForColumnEncoding, this.buildVersion);
    }

    NBucketDictionary(String baseDir, String workingDir, int bucketId, NGlobalDictMetaInfo metainfo, boolean isForColumnEncoding, long buildVersion) throws IOException {
        this.workingDir = workingDir;
        this.bucketId = bucketId;
        this.buildVersion = buildVersion;
        this.initDictMap(baseDir, bucketId, metainfo, isForColumnEncoding, this.buildVersion);
    }

    NBucketDictionary(String workingDir) {
        this.workingDir = workingDir;
        this.absoluteDictMap = new Object2LongOpenHashMap();
        this.relativeDictMap = new Object2LongOpenHashMap();
    }

    public void addRelativeValue(String value) {
        if (null == value) {
            return;
        }
        if (this.absoluteDictMap.containsKey((Object)value)) {
            return;
        }
        this.relativeDictMap.put((Object)value, (long)this.relativeDictMap.size() + 1L);
    }

    public void addAbsoluteValue(String value, long encodeValue) {
        this.absoluteDictMap.put((Object)value, encodeValue);
    }

    public long encode(Object value) {
        long encodeValue = this.absoluteDictMap.getLong((Object)value.toString());
        if (encodeValue == 0L) {
            throw new IllegalDictEncodeValueException(String.format(Locale.ROOT, "DFTable encode key:%s with error value:%s", value, encodeValue));
        }
        return encodeValue;
    }

    public void saveBucketDict(int bucketId) throws IOException {
        this.writeBucketCurrDict(bucketId);
        this.writeBucketPrevDict(bucketId);
    }

    private void writeBucketPrevDict(int bucketId) throws IOException {
        if (this.absoluteDictMap.isEmpty()) {
            return;
        }
        NGlobalDictStore globalDictStore = NGlobalDictStoreFactory.getResourceStore(this.workingDir);
        globalDictStore.writeBucketPrevDict(this.workingDir, bucketId, this.absoluteDictMap);
    }

    private void writeBucketCurrDict(int bucketId) throws IOException {
        if (this.relativeDictMap.isEmpty()) {
            return;
        }
        NGlobalDictStore globalDictStore = NGlobalDictStoreFactory.getResourceStore(this.workingDir);
        globalDictStore.writeBucketCurrDict(this.workingDir, bucketId, this.relativeDictMap);
    }

    public Object2LongMap<String> getAbsoluteDictMap() {
        return this.absoluteDictMap;
    }

    public Object2LongMap<String> getRelativeDictMap() {
        return this.relativeDictMap;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(int bucketId) {
        this.bucketId = bucketId;
    }
}

