/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.JobAddedNotifier;
import org.apache.kylin.common.scheduler.JobReadyNotifier;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.dao.JobInfoDao;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.ChainedStageExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.DefaultOutput;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.execution.StageExecutable;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.rest.JobMapperFilter;
import org.apache.kylin.job.runners.JobCheckUtil;
import org.apache.kylin.job.scheduler.JdbcJobScheduler;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.job.util.JobInfoUtil;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutableManager.class);
    private static final Logger logger = LoggerFactory.getLogger(ExecutableManager.class);
    private static final Object DUMMY_OBJECT = new Object();
    private static final String PARSE_ERROR_MSG = "Error parsing the executablePO: ";
    private static final int LOG_DEFAULT_DISPLAY_HEAD_AND_TAIL_SIZE = 100;
    private static final String SHOULD_DESTROY_PROCESS_SIGNAL = "SHOULD_DESTROY_PROCESS_SIGNAL";
    private final KylinConfig config;
    private String project;
    private JobInfoDao jobInfoDao;
    private static final Set<String> REMOVE_INFO = Sets.newHashSet((Object[])new String[]{"yarn_application_id", "yarn_application_tracking_url", "yarn_job_wait_time", "yarn_job_run_time", "queue_name", "cores", "memory"});

    public static ExecutableManager getInstance(KylinConfig config, String project) {
        if (null == project) {
            throw new IllegalStateException();
        }
        return (ExecutableManager)config.getManager(project, ExecutableManager.class);
    }

    static ExecutableManager newInstance(KylinConfig config, String project) {
        return new ExecutableManager(config, project);
    }

    private ExecutableManager(KylinConfig config, String project) {
        log.trace("Using metadata url: {}", (Object)config);
        this.config = config;
        this.project = project;
        this.jobInfoDao = JobContextUtil.getJobInfoDao(this.config);
    }

    public static ExecutablePO toPO(AbstractExecutable executable, String project) {
        HashSet segments;
        ExecutablePO result = new ExecutablePO();
        result.setProject(project);
        result.setName(executable.getName());
        result.setUuid(executable.getId());
        result.setType(executable.getClass().getName());
        result.setParams(executable.getParams());
        result.setJobType(executable.getJobType());
        result.setTargetModel(executable.getTargetSubject());
        result.setTargetSegments(executable.getTargetSegments());
        result.setTargetPartitions(executable.getTargetPartitions());
        result.getOutput().setResumable(executable.isResumable());
        result.setPriority(executable.getPriority());
        result.setTag(executable.getTag());
        result.setJobSchedulerMode(executable.getJobSchedulerMode());
        result.setPreviousStep(executable.getPreviousStep());
        result.setNextSteps(executable.getNextSteps());
        Map<String, Object> runTimeInfo = executable.getRunTimeInfo();
        if (runTimeInfo != null && runTimeInfo.size() > 0 && (segments = (HashSet)runTimeInfo.get("runtimeInfo")) != null) {
            result.getSegments().addAll(segments);
        }
        if (executable instanceof ChainedExecutable) {
            ExecutableHandler handler;
            ArrayList tasks = Lists.newArrayList();
            for (AbstractExecutable task : ((ChainedExecutable)((Object)executable)).getTasks()) {
                tasks.add(ExecutableManager.toPO(task, project));
            }
            result.setTasks(tasks);
            if (executable instanceof DefaultExecutableOnModel && (handler = ((DefaultExecutableOnModel)executable).getHandler()) != null) {
                result.setHandlerType(handler.getClass().getName());
            }
        }
        if (executable instanceof ChainedStageExecutable) {
            HashMap taskMap = Maps.newHashMap();
            Map<String, List<StageExecutable>> tasksMap = Optional.ofNullable(((ChainedStageExecutable)((Object)executable)).getStagesMap()).orElse(Maps.newHashMap());
            for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                List executables = entry.getValue().stream().map(stage -> ExecutableManager.toPO(stage, project)).collect(Collectors.toList());
                taskMap.put(entry.getKey(), executables);
            }
            if (MapUtils.isNotEmpty((Map)taskMap)) {
                result.setStagesMap(taskMap);
            }
        }
        return result;
    }

    private ExecutablePO copyForWrite(ExecutablePO po) {
        return po;
    }

    public void checkAndSubmitCronJob(String factory, JobTypeEnum jobType) {
        List<JobInfo> processingJobs = this.fetchJobsByFilter(JobMapperFilter.builder().jobNames(Collections.singletonList(jobType.name())).project(this.project).statuses(Arrays.asList(ExecutableState.PENDING, ExecutableState.READY, ExecutableState.RUNNING, ExecutableState.PAUSED)).build());
        if (processingJobs.size() > 1) {
            log.warn("There are too many jobs in pending/ready/running/paused state, skip submitting job:{} for project:{}", (Object)jobType, (Object)this.project);
            return;
        }
        if (processingJobs.size() == 1) {
            log.info("The last job has not finished, skip submitting job:{} for project:{}", (Object)jobType, (Object)this.project);
            return;
        }
        AbstractExecutable cronJob = JobFactory.createJobWithDefaultParams(factory, jobType);
        if (cronJob != null) {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project).addJob(cronJob);
                return null;
            }, (String)this.project);
        } else {
            log.warn("Cannot create cron job:{} for project:{}", (Object)jobType, (Object)this.project);
        }
    }

    public void addJob(AbstractExecutable executable) {
        ExecutablePO po = ExecutableManager.toPO(executable, this.project);
        this.addJob(po);
    }

    public void addJob(ExecutablePO executablePO) {
        String jobType;
        ExecutablePO copy = this.copyForWrite(executablePO);
        this.addJobOutput(copy);
        this.jobInfoDao.addJob(copy);
        String string = jobType = copy.getJobType() == null ? "" : copy.getJobType().name();
        if (KylinConfig.getInstanceFromEnv().isUTEnv()) {
            EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new JobReadyNotifier(this.project));
            EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new JobAddedNotifier(this.project, jobType));
        } else {
            UnitOfWork.get().doAfterUnit(() -> {
                EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new JobReadyNotifier(this.project));
                EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new JobAddedNotifier(this.project, jobType));
            });
        }
    }

    private void addJobOutput(ExecutablePO executable) {
        ExecutableOutputPO executableOutputPO = new ExecutableOutputPO();
        executable.setOutput(executableOutputPO);
        if (CollectionUtils.isNotEmpty(executable.getTasks())) {
            for (ExecutablePO executablePO : executable.getTasks()) {
                this.addJobOutput(executablePO);
            }
        }
        if (MapUtils.isNotEmpty(executable.getStagesMap())) {
            for (Map.Entry entry : executable.getStagesMap().entrySet()) {
                ((List)entry.getValue()).forEach(this::addJobOutput);
            }
        }
    }

    public void updateJobOutput(String taskOrJobId, ExecutableState newStatus) {
        this.updateJobOutput(taskOrJobId, newStatus, null, null, null);
    }

    public void updateJobOutput(String taskOrJobId, ExecutableState newStatus, Map<String, String> updateInfo) {
        this.updateJobOutput(taskOrJobId, newStatus, updateInfo, null, null);
    }

    public void updateJobOutput(String taskOrJobId, ExecutableState newStatus, Map<String, String> updateInfo, Set<String> removeInfo, String output) {
        this.updateJobOutput(taskOrJobId, newStatus, updateInfo, removeInfo, output, 0L);
    }

    public void updateJobOutput(String taskOrJobId, ExecutableState newStatus, Map<String, String> updateInfo, Set<String> removeInfo, String output, long byteSize) {
        this.updateJobOutput(taskOrJobId, newStatus, updateInfo, removeInfo, output, byteSize, null);
    }

    public void updateJobOutput(String taskOrJobId, ExecutableState newStatus, Map<String, String> updateInfo, Set<String> removeInfo, String output, long byteSize, String failedMsg) {
        String jobId = ExecutableManager.extractJobId(taskOrJobId);
        HashMap shouldDestroyProcessSignalMap = Maps.newHashMap();
        this.jobInfoDao.updateJob(jobId, job -> {
            ExecutablePO taskOrJob = Objects.equals(taskOrJobId, jobId) ? job : (ExecutablePO)job.getTasks().stream().filter(po -> po.getId().equals(taskOrJobId)).findFirst().orElse(null);
            ExecutableOutputPO jobOutput = taskOrJob.getOutput();
            this.assertOutputNotNull(jobOutput, taskOrJobId);
            ExecutableState oldStatus = ExecutableState.valueOf(jobOutput.getStatus());
            if (newStatus != null && oldStatus != newStatus) {
                if (!ExecutableState.isValidStateTransfer(oldStatus, newStatus)) {
                    logger.warn("[UNEXPECTED_THINGS_HAPPENED] wrong job state transfer! There is no valid state transfer from: {} to: {}, job id: {}", new Object[]{oldStatus, newStatus, taskOrJobId});
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_STATE_TRANSFER_ILLEGAL, new Object[0]);
                }
                jobOutput.setStatus(String.valueOf((Object)newStatus));
                this.updateJobStatus(jobOutput, oldStatus, newStatus);
                logger.info("Job id: {} from {} to {}", new Object[]{taskOrJobId, oldStatus, newStatus});
            }
            HashMap info = Maps.newHashMap(jobOutput.getInfo());
            Optional.ofNullable(updateInfo).ifPresent(info::putAll);
            Optional.ofNullable(removeInfo).ifPresent(set -> set.forEach(info::remove));
            if (ExecutableState.READY == newStatus) {
                Optional.ofNullable(REMOVE_INFO).ifPresent(set -> set.forEach(info::remove));
            }
            if (this.hasRunningJob(jobId)) {
                String oldNodeInfo = (String)info.get("node_info");
                String newNodeInfo = this.config.getServerAddress();
                if (Objects.nonNull(oldNodeInfo) && !Objects.equals(oldNodeInfo, newNodeInfo) && !Objects.equals(taskOrJobId, jobId)) {
                    logger.info("The node running job has changed. Job id: {}, Step name: {}, Switch from {} to {}.", new Object[]{jobId, taskOrJob.getName(), oldNodeInfo, newNodeInfo});
                }
                info.put("node_info", newNodeInfo);
                info.put("host_name", AddressUtil.getHostName());
            }
            jobOutput.setInfo(info);
            String appId = (String)info.get("yarn_application_id");
            if (StringUtils.isNotEmpty((CharSequence)appId)) {
                logger.info("Add application id {} to {}.", (Object)appId, (Object)jobId);
                job.addYarnApplicationJob(appId);
            }
            Optional.ofNullable(output).ifPresent(jobOutput::setContent);
            jobOutput.setLastModified(System.currentTimeMillis());
            if (byteSize > 0L) {
                jobOutput.setByteSize(byteSize);
            }
            jobOutput.setFailedMsg(failedMsg);
            if (this.needDestroyProcess(oldStatus, newStatus)) {
                logger.debug("need kill {}, from {} to {}", new Object[]{taskOrJobId, oldStatus, newStatus});
                shouldDestroyProcessSignalMap.put(SHOULD_DESTROY_PROCESS_SIGNAL, true);
            }
            return true;
        });
        if (shouldDestroyProcessSignalMap.getOrDefault(SHOULD_DESTROY_PROCESS_SIGNAL, false).booleanValue()) {
            this.destroyProcess(taskOrJobId);
        }
    }

    private boolean hasRunningJob(String jobId) {
        JobContext jobContext = JobContextUtil.getJobContext(this.config);
        JdbcJobScheduler jobScheduler = jobContext.getJobScheduler();
        return null != jobScheduler && jobScheduler.getRunningJob().containsKey(jobId);
    }

    public static String extractJobId(String taskOrJobId) {
        String[] jobIdPair = taskOrJobId.split("_");
        return jobIdPair[0];
    }

    private void assertOutputNotNull(ExecutableOutputPO output, String idOrPath) {
        Preconditions.checkArgument((output != null ? 1 : 0) != 0, (Object)("there is no related output for job :" + idOrPath));
    }

    private void assertOutputNotNull(ExecutableOutputPO output, String idOrPath, String segmentOrStepId) {
        Preconditions.checkArgument((output != null ? 1 : 0) != 0, (Object)("there is no related output for job :" + idOrPath + " , segmentOrStep : " + segmentOrStepId));
    }

    public void cancelJobSubTasks(AbstractExecutable executable) {
        if (executable instanceof DefaultExecutable) {
            List<AbstractExecutable> subTasks = ((DefaultExecutable)executable).getTasks();
            subTasks.forEach(task -> {
                if (ExecutableState.RUNNING == task.getStatus()) {
                    logger.info("Cancel subtask [{}]", (Object)task.getDisplayName());
                    task.cancelJob();
                }
            });
        }
    }

    private void updateJobStatus(ExecutableOutputPO jobOutput, ExecutableState oldStatus, ExecutableState newStatus) {
        long time = System.currentTimeMillis();
        if (oldStatus == ExecutableState.RUNNING) {
            jobOutput.addEndTime(time);
            jobOutput.addDuration(time);
            return;
        }
        switch (newStatus) {
            case RUNNING: {
                jobOutput.addStartTime(time);
                jobOutput.addLastRunningStartTime(time);
                break;
            }
            case SKIP: 
            case SUICIDAL: 
            case DISCARDED: {
                jobOutput.addStartTime(time);
                jobOutput.addEndTime(time);
                break;
            }
        }
    }

    private boolean needDestroyProcess(ExecutableState from, ExecutableState to) {
        if (from != ExecutableState.RUNNING || to == null) {
            return false;
        }
        return to == ExecutableState.PAUSED || to == ExecutableState.READY || to == ExecutableState.DISCARDED || to == ExecutableState.ERROR || to == ExecutableState.SUICIDAL;
    }

    public void destroyProcess(String jobId) {
        EventBusFactory.getInstance().postSync((Object)new CliCommandExecutor.JobKilled(jobId));
    }

    public void destroyAllProcess() {
        if (KylinConfig.getInstanceFromEnv().isUTEnv()) {
            return;
        }
        List<String> jobs = this.getJobs();
        for (String job : jobs) {
            this.destroyProcess(job);
        }
    }

    private void killRemoteProcess(ExecutablePO executablePO, CliCommandExecutor exe) {
        if (!executablePO.getOutput().getStatus().equalsIgnoreCase(ExecutableState.RUNNING.toString())) {
            return;
        }
        Map<String, String> info = executablePO.getOutput().getInfo();
        String pid = info.get("process_id");
        if (StringUtils.isNotEmpty((CharSequence)pid)) {
            String nodeInfo = info.get("node_info");
            String host = nodeInfo.split(":")[0];
            if (!host.equals(AddressUtil.getLocalInstance().split(":")[0]) && !host.equals(this.config.getServerAddress().split(":")[0])) {
                exe.setRunAtRemote(host, this.config.getRemoteSSHPort(), this.config.getRemoteSSHUsername(), this.config.getRemoteSSHPassword());
            } else {
                exe.setRunAtRemote(null, this.config.getRemoteSSHPort(), this.config.getRemoteSSHUsername(), this.config.getRemoteSSHPassword());
            }
            try {
                logger.info("will kill job pid is {}", (Object)pid);
                exe.execute("kill -9 " + pid, null);
            }
            catch (ShellException e) {
                logger.warn("failed to kill remote driver {} on {}", new Object[]{nodeInfo, pid, e});
            }
        }
    }

    public CliCommandExecutor getCliCommandExecutor() {
        CliCommandExecutor exec = new CliCommandExecutor();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        exec.setRunAtRemote(config.getRemoteHadoopCliHostname(), config.getRemoteSSHPort(), config.getRemoteSSHUsername(), config.getRemoteSSHPassword());
        return exec;
    }

    public void checkJobCanBeDeleted(AbstractExecutable executable) {
        ExecutableState status = executable.getStatusInMem();
        if (ExecutableState.SUCCEED != status && ExecutableState.DISCARDED != status && ExecutableState.SUICIDAL != status) {
            throw new IllegalStateException("Cannot drop running job " + executable.getDisplayName() + ", please discard it first.");
        }
    }

    public AbstractExecutable getJob(String id) {
        if (id == null) {
            return null;
        }
        ExecutablePO executablePO = this.jobInfoDao.getExecutablePOByUuid(id);
        return this.getJob(id, executablePO);
    }

    public AbstractExecutable getJob(String id, ExecutablePO executablePO) {
        if (id == null || executablePO == null || !id.equals(executablePO.getId())) {
            return null;
        }
        try {
            return this.fromPO(executablePO);
        }
        catch (Exception e) {
            logger.error(PARSE_ERROR_MSG, (Throwable)e);
            return null;
        }
    }

    public AbstractExecutable fromPO(ExecutablePO executablePO) {
        if (executablePO == null) {
            logger.warn("executablePO is null");
            return null;
        }
        String type = executablePO.getType();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)type), (Object)("Cannot parse this job: " + executablePO.getId() + ", the type is empty"));
        try {
            Class clazz = ClassUtil.forName((String)type, AbstractExecutable.class);
            Constructor constructor = clazz.getConstructor(Object.class);
            AbstractExecutable result = (AbstractExecutable)constructor.newInstance(DUMMY_OBJECT);
            result.setId(executablePO.getUuid());
            result.setName(executablePO.getName());
            String jobProject = null == executablePO.getProject() ? this.project : executablePO.getProject();
            result.setProject(jobProject);
            result.setParams(executablePO.getParams());
            result.setJobType(executablePO.getJobType());
            result.setTargetSubject(executablePO.getTargetModel());
            result.setTargetSegments(executablePO.getTargetSegments());
            result.setResumable(executablePO.getOutput().isResumable());
            result.setTargetPartitions(executablePO.getTargetPartitions());
            result.setPriority(executablePO.getPriority());
            result.setTag(executablePO.getTag());
            result.setPo(executablePO);
            result.setJobSchedulerMode(executablePO.getJobSchedulerMode());
            result.setPreviousStep(executablePO.getPreviousStep());
            result.setNextSteps(executablePO.getNextSteps());
            List<ExecutablePO> tasks = executablePO.getTasks();
            if (tasks != null && !tasks.isEmpty()) {
                String handlerType;
                Preconditions.checkArgument((boolean)(result instanceof ChainedExecutable));
                for (ExecutablePO subTask : tasks) {
                    AbstractExecutable abstractExecutable = this.fromPO(subTask);
                    if (abstractExecutable instanceof ChainedStageExecutable && MapUtils.isNotEmpty(subTask.getStagesMap())) {
                        for (Map.Entry<String, List<ExecutablePO>> entry : subTask.getStagesMap().entrySet()) {
                            List<StageExecutable> executables = entry.getValue().stream().map(po -> {
                                AbstractExecutable executable = this.fromPO((ExecutablePO)((Object)po));
                                return (StageExecutable)executable;
                            }).collect(Collectors.toList());
                            ((ChainedStageExecutable)((Object)abstractExecutable)).setStageMapWithSegment(entry.getKey(), executables);
                        }
                    }
                    ((ChainedExecutable)((Object)result)).addTask(abstractExecutable);
                }
                if (result instanceof DefaultExecutableOnModel && (handlerType = executablePO.getHandlerType()) != null) {
                    Class hClazz = ClassUtil.forName((String)handlerType, ExecutableHandler.class);
                    Constructor hConstructor = hClazz.getConstructor(String.class, String.class, String.class, String.class, String.class);
                    String segmentId = CollectionUtils.isNotEmpty(result.getTargetSegments()) ? result.getTargetSegments().get(0) : null;
                    ExecutableHandler executableHandler = (ExecutableHandler)hConstructor.newInstance(this.project, result.getTargetSubject(), result.getSubmitter(), segmentId, result.getId());
                    ((DefaultExecutableOnModel)result).setHandler(executableHandler);
                }
            }
            return result;
        }
        catch (Throwable e) {
            logger.error("Cannot parse this job...", e);
            throw new IllegalStateException("Cannot parse this job: " + executablePO.getId(), e);
        }
    }

    public long getCreateTime(String id) {
        ExecutablePO executablePO = this.jobInfoDao.getExecutablePOByUuid(ExecutableManager.extractJobId(id));
        if (executablePO == null) {
            return 0L;
        }
        return executablePO.getOutput().getCreateTime();
    }

    public Output getOutput(String id) {
        ExecutableOutputPO jobOutput = this.getJobOutput(id);
        this.assertOutputNotNull(jobOutput, id);
        return this.parseOutput(jobOutput);
    }

    public Output getOutput(String id, String segmentId) {
        ExecutableOutputPO jobOutput = this.getJobOutput(id, segmentId);
        this.assertOutputNotNull(jobOutput, id, segmentId);
        return this.parseOutput(jobOutput);
    }

    public Output getOutput(String id, ExecutablePO executablePO, String segmentId) {
        ExecutableOutputPO jobOutput = this.getJobOutput(id, executablePO, segmentId);
        this.assertOutputNotNull(jobOutput, id, segmentId);
        return this.parseOutput(jobOutput);
    }

    public Output getOutput(String id, ExecutablePO executablePO) {
        ExecutableOutputPO jobOutput = this.getJobOutput(id, executablePO);
        this.assertOutputNotNull(jobOutput, id);
        return this.parseOutput(jobOutput);
    }

    @VisibleForTesting
    public ExecutableOutputPO getJobOutput(String taskOrJobId) {
        String jobId = ExecutableManager.extractJobId(taskOrJobId);
        ExecutablePO executablePO = this.jobInfoDao.getExecutablePOByUuid(jobId);
        ExecutableOutputPO jobOutput = this.getExecutableOutputPO(taskOrJobId, executablePO);
        this.assertOutputNotNull(jobOutput, taskOrJobId);
        return jobOutput;
    }

    public ExecutableOutputPO getJobOutput(String taskOrJobId, String segmentId) {
        String jobId = ExecutableManager.extractJobId(taskOrJobId);
        ExecutablePO executablePO = this.jobInfoDao.getExecutablePOByUuid(jobId);
        return this.getJobOutput(taskOrJobId, executablePO, segmentId);
    }

    public ExecutableOutputPO getJobOutput(String taskOrJobId, ExecutablePO executablePO) {
        String jobId = ExecutableManager.extractJobId(taskOrJobId);
        ExecutableOutputPO jobOutput = this.getExecutableOutputPO(taskOrJobId, executablePO);
        this.assertOutputNotNull(jobOutput, taskOrJobId);
        return jobOutput;
    }

    public ExecutableOutputPO getJobOutput(String taskOrJobId, ExecutablePO executablePO, String segmentId) {
        String jobId = ExecutableManager.extractJobId(taskOrJobId);
        ExecutableOutputPO jobOutput = this.getExecutableOutputPO(taskOrJobId, executablePO);
        if (Objects.isNull(jobOutput)) {
            logger.trace("get job output from taskOrJobId : {} and segmentId : {}", (Object)taskOrJobId, (Object)segmentId);
            Map stageMap = executablePO.getTasks().stream().map(ExecutablePO::getStagesMap).filter(map -> MapUtils.isNotEmpty((Map)map) && map.containsKey(segmentId)).findFirst().orElse(Maps.newHashMap());
            jobOutput = ((List)stageMap.getOrDefault(segmentId, Lists.newArrayList())).stream().filter(po -> po.getId().equals(taskOrJobId)).findFirst().map(ExecutablePO::getOutput).orElse(null);
        }
        this.assertOutputNotNull(jobOutput, taskOrJobId, segmentId);
        return jobOutput;
    }

    private DefaultOutput parseOutput(ExecutableOutputPO jobOutput) {
        DefaultOutput result = new DefaultOutput();
        result.setExtra(jobOutput.getInfo());
        result.setState(ExecutableState.valueOf(jobOutput.getStatus()));
        result.setVerboseMsg(jobOutput.getContent());
        result.setVerboseMsgStream(jobOutput.getContentStream());
        result.setLastModified(jobOutput.getLastModified());
        result.setStartTime(jobOutput.getStartTime());
        result.setEndTime(jobOutput.getEndTime());
        result.setWaitTime(jobOutput.getWaitTime());
        result.setDuration(jobOutput.getDuration());
        result.setLastRunningStartTime(jobOutput.getLastRunningStartTime());
        result.setCreateTime(jobOutput.getCreateTime());
        result.setByteSize(jobOutput.getByteSize());
        result.setShortErrMsg(jobOutput.getFailedMsg());
        result.setFailedStepId(jobOutput.getFailedStepId());
        result.setFailedSegmentId(jobOutput.getFailedSegmentId());
        result.setFailedStack(jobOutput.getFailedStack());
        result.setFailedReason(jobOutput.getFailedReason());
        return result;
    }

    public ExecutableOutputPO getExecutableOutputPO(String taskOrJobId, ExecutablePO executablePO) {
        ExecutableOutputPO jobOutput = Objects.isNull((Object)executablePO) ? new ExecutableOutputPO() : (Objects.equals(taskOrJobId, executablePO.getId()) ? executablePO.getOutput() : (ExecutableOutputPO)executablePO.getTasks().stream().filter(po -> po.getId().equals(taskOrJobId)).findFirst().map(ExecutablePO::getOutput).orElse(null));
        return jobOutput;
    }

    public void updateJobError(String taskOrJobId, String failedStepId, String failedSegmentId, String failedStack, String failedReason) {
        String jobId = ExecutableManager.extractJobId(taskOrJobId);
        this.jobInfoDao.updateJob(jobId, job -> {
            long errorTaskAndNotFailedStepIdTaskCount;
            ExecutableOutputPO jobOutput = job.getOutput();
            List<ExecutablePO> subTasks = job.getTasks();
            if (null != subTasks && (errorTaskAndNotFailedStepIdTaskCount = subTasks.stream().filter(task -> ExecutableState.valueOf(task.getOutput().getStatus()) == ExecutableState.ERROR).filter(task -> !StringUtils.startsWith((CharSequence)failedStepId, (CharSequence)task.getId())).count()) != 0L) {
                return false;
            }
            if (jobOutput.getFailedReason() == null || failedReason == null) {
                jobOutput.setFailedStepId(failedStepId);
                jobOutput.setFailedSegmentId(failedSegmentId);
                jobOutput.setFailedStack(failedStack);
                jobOutput.setFailedReason(failedReason);
            }
            return true;
        });
    }

    public void resumeJob(String jobId) {
        this.resumeJob(jobId, false);
    }

    public void resumeJob(String jobId, boolean force) {
        JobContextUtil.withTxAndRetry(() -> {
            this.resumeJob(jobId, this.getJob(jobId), force);
            return true;
        });
    }

    public void resumeJob(String jobId, AbstractExecutable job) {
        this.resumeJob(jobId, job, false);
    }

    public void cancelRemoteJob(ExecutablePO executablePO) {
        if (executablePO.getOutput().getStatus().equalsIgnoreCase(ExecutableState.RUNNING.toString())) {
            // empty if block
        }
    }

    private void resumeJob(String jobId, AbstractExecutable job, boolean force) {
        this.updateJobError(jobId, null, null, null, null);
        if (Objects.isNull(job)) {
            return;
        }
        if (!job.getStatusInMem().isNotProgressing() && !force) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_UPDATE_STATUS_FAILED, new Object[]{"RESUME", jobId, job.getStatusInMem()});
        }
        if (job instanceof DefaultExecutable) {
            List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
            tasks.stream().filter(task -> task.getStatusInMem().isNotProgressing() || task.getStatusInMem() == ExecutableState.RUNNING).forEach(task -> this.updateJobOutput(task.getId(), ExecutableState.READY));
            tasks.forEach(task -> {
                Map<String, List<StageExecutable>> tasksMap;
                if (task instanceof ChainedStageExecutable && MapUtils.isNotEmpty(tasksMap = ((ChainedStageExecutable)((Object)task)).getStagesMap())) {
                    for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                        Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).stream().filter(stage -> stage.getStatusInMem((String)entry.getKey()) == ExecutableState.RUNNING || stage.getStatusInMem((String)entry.getKey()).isNotProgressing()).forEach(stage -> this.updateStageStatus(stage.getId(), (String)entry.getKey(), ExecutableState.READY, null, null));
                    }
                }
            });
        }
        this.updateJobOutput(jobId, ExecutableState.READY);
    }

    public void publishJob(String jobId, AbstractExecutable job) {
        if (Objects.isNull(job) || job.getStatusInMem() != ExecutableState.READY) {
            return;
        }
        JobContextUtil.withTxAndRetry(() -> {
            if (job instanceof DefaultExecutable) {
                List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
                tasks.stream().filter(task -> task.getStatusInMem() == ExecutableState.READY).forEach(task -> this.updateJobOutput(task.getId(), ExecutableState.PENDING));
                tasks.forEach(task -> {
                    Map<String, List<StageExecutable>> tasksMap;
                    if (task instanceof ChainedStageExecutable && MapUtils.isNotEmpty(tasksMap = ((ChainedStageExecutable)((Object)task)).getStagesMap())) {
                        for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                            Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).stream().filter(stage -> stage.getStatusInMem((String)entry.getKey()) == ExecutableState.READY).forEach(stage -> this.updateStageStatus(stage.getId(), (String)entry.getKey(), ExecutableState.PENDING, null, null));
                        }
                    }
                });
            }
            this.updateJobOutput(jobId, ExecutableState.PENDING);
            return true;
        });
    }

    public void updateStageStatus(String taskOrJobId, String segmentId, ExecutableState newStatus, Map<String, String> updateInfo, String failedMsg) {
        JobContextUtil.withTxAndRetry(() -> {
            this.updateStageStatus(taskOrJobId, segmentId, newStatus, updateInfo, failedMsg, false);
            return true;
        });
    }

    public void updateStageStatus(String taskOrJobId, String segmentId, ExecutableState newStatus, Map<String, String> updateInfo, String failedMsg, Boolean isRestart) {
        String jobId = ExecutableManager.extractJobId(taskOrJobId);
        this.jobInfoDao.updateJob(jobId, job -> {
            List collect = job.getTasks().stream().map(ExecutablePO::getStagesMap).filter(MapUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return false;
            }
            Map stageMapFromSegment = collect.stream().filter(map -> map.containsKey(segmentId)).findFirst().orElse(null);
            if (MapUtils.isNotEmpty((Map)stageMapFromSegment)) {
                ExecutablePO stage = ((List)stageMapFromSegment.getOrDefault(segmentId, Lists.newArrayList())).stream().filter(po -> po.getId().equals(taskOrJobId)).findFirst().orElse(null);
                if (stage == null) {
                    return false;
                }
                ExecutableOutputPO stageOutput = stage.getOutput();
                this.assertOutputNotNull(stageOutput, taskOrJobId, segmentId);
                return this.setStageOutput(stageOutput, taskOrJobId, newStatus, updateInfo, failedMsg, isRestart);
            }
            for (Map stageMap : collect) {
                for (Map.Entry entry : stageMap.entrySet()) {
                    ExecutablePO stage = ((List)entry.getValue()).stream().filter(po -> po.getId().equals(taskOrJobId)).findFirst().orElse(null);
                    if (null == stage) {
                        return false;
                    }
                    ExecutableOutputPO stageOutput = stage.getOutput();
                    this.assertOutputNotNull(stageOutput, taskOrJobId);
                    boolean flag = this.setStageOutput(stageOutput, taskOrJobId, newStatus, updateInfo, failedMsg, isRestart);
                    if (flag) continue;
                    return false;
                }
            }
            return true;
        });
    }

    public boolean setStageOutput(ExecutableOutputPO jobOutput, String taskOrJobId, ExecutableState newStatus, Map<String, String> updateInfo, String failedMsg, Boolean isRestart) {
        ExecutableState oldStatus = ExecutableState.valueOf(jobOutput.getStatus());
        if (newStatus != null && oldStatus != newStatus) {
            if (!ExecutableState.isValidStateTransfer(oldStatus, newStatus)) {
                logger.warn("[UNEXPECTED_THINGS_HAPPENED] wrong job state transfer! There is no valid state transfer from: {} to: {}, job id: {}", new Object[]{oldStatus, newStatus, taskOrJobId});
            }
            if (oldStatus == ExecutableState.PAUSED && newStatus == ExecutableState.ERROR || oldStatus == ExecutableState.SKIP && newStatus == ExecutableState.SUCCEED || oldStatus == ExecutableState.WARNING && newStatus == ExecutableState.SUCCEED || oldStatus == ExecutableState.DISCARDED) {
                return false;
            }
            if (isRestart.booleanValue() || oldStatus != ExecutableState.SUCCEED && oldStatus != ExecutableState.SKIP) {
                jobOutput.setStatus(String.valueOf((Object)newStatus));
                this.updateJobStatus(jobOutput, oldStatus, newStatus);
                logger.info("Job id: {} from {} to {}", new Object[]{taskOrJobId, oldStatus, newStatus});
            }
        }
        HashMap info = Maps.newHashMap(jobOutput.getInfo());
        Optional.ofNullable(updateInfo).ifPresent(map -> {
            int indexSuccessCount = Integer.parseInt(map.getOrDefault("indexSuccessCount", "0"));
            info.put("indexSuccessCount", String.valueOf(indexSuccessCount));
            String warningCode = (String)map.get("warning_code");
            if (warningCode != null) {
                info.put("warning_code", warningCode);
            }
        });
        jobOutput.setInfo(info);
        jobOutput.setLastModified(System.currentTimeMillis());
        jobOutput.setFailedMsg(failedMsg);
        return true;
    }

    public void restartJob(String jobId) {
        JobContextUtil.withTxAndRetry(() -> {
            this.restartJob(jobId, this.getJob(jobId));
            return true;
        });
    }

    public void restartJob(String jobId, AbstractExecutable jobToRestart) {
        this.updateJobError(jobId, null, null, null, null);
        if (Objects.isNull(jobToRestart)) {
            return;
        }
        if (jobToRestart.getStatusInMem().isFinalState()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_UPDATE_STATUS_FAILED, new Object[]{"RESTART", jobId, jobToRestart.getStatusInMem()});
        }
        this.updateJobReady(jobId, jobToRestart);
        this.jobInfoDao.updateJob(jobId, job -> {
            job.getOutput().setResumable(false);
            job.getOutput().resetTime();
            job.getTasks().forEach(task -> {
                task.getOutput().setResumable(false);
                task.getOutput().resetTime();
                if (MapUtils.isNotEmpty(task.getStagesMap())) {
                    for (Map.Entry<String, List<ExecutablePO>> entry : task.getStagesMap().entrySet()) {
                        Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).forEach(executablePO -> {
                            executablePO.getOutput().setResumable(false);
                            executablePO.getOutput().resetTime();
                            HashMap stageInfo = Maps.newHashMap(executablePO.getOutput().getInfo());
                            stageInfo.put("indexSuccessCount", "0");
                            executablePO.getOutput().setInfo(stageInfo);
                        });
                    }
                }
            });
            return true;
        });
    }

    private void updateJobReady(String jobId, AbstractExecutable job) {
        if (job == null) {
            return;
        }
        if (job instanceof DefaultExecutable) {
            List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
            tasks.stream().filter(task -> task.getStatusInMem() != ExecutableState.READY).forEach(task -> this.updateJobOutput(task.getId(), ExecutableState.READY));
            tasks.forEach(task -> {
                Map<String, List<StageExecutable>> tasksMap;
                if (task instanceof ChainedStageExecutable && MapUtils.isNotEmpty(tasksMap = ((ChainedStageExecutable)((Object)task)).getStagesMap())) {
                    for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                        Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).stream().filter(stage -> stage.getStatusInMem((String)entry.getKey()) != ExecutableState.READY).forEach(stage -> this.updateStageStatus(stage.getId(), (String)entry.getKey(), ExecutableState.READY, null, null, true));
                    }
                }
            });
        }
        HashMap info = Maps.newHashMap();
        info.put("waiteTime", "{}");
        this.updateJobOutput(jobId, ExecutableState.READY, info);
    }

    public void discardJob(String jobId, AbstractExecutable job) {
        if (job == null) {
            return;
        }
        JobContextUtil.withTxAndRetry(() -> {
            if (job instanceof DefaultExecutable) {
                List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
                tasks.forEach(task -> {
                    Map<String, List<StageExecutable>> tasksMap;
                    if (task instanceof ChainedStageExecutable && MapUtils.isNotEmpty(tasksMap = ((ChainedStageExecutable)((Object)task)).getStagesMap())) {
                        for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                            Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).forEach(stage -> this.updateStageStatus(stage.getId(), (String)entry.getKey(), ExecutableState.DISCARDED, null, null));
                        }
                    }
                });
            }
            this.updateJobOutput(jobId, ExecutableState.DISCARDED);
            job.cancelJob();
            return true;
        });
    }

    public void pauseJob(String jobId) {
        JobContextUtil.withTxAndRetry(() -> {
            ExecutablePO executablePO = this.jobInfoDao.getExecutablePOByUuid(jobId);
            this.pauseJob(jobId, executablePO, this.fromPO(executablePO));
            return true;
        });
    }

    public void pauseJob(String jobId, ExecutablePO executablePO, AbstractExecutable job) {
        JobContextUtil.withTxAndRetry(() -> {
            if (job == null) {
                return false;
            }
            if (!job.getStatusInMem().isProgressing()) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_UPDATE_STATUS_FAILED, new Object[]{"PAUSE", jobId, job.getStatusInMem()});
            }
            this.updateStagePaused(job);
            Map<String, String> info = this.getWaiteTime(executablePO, job);
            this.updateJobOutput(jobId, ExecutableState.PAUSED, info, null, null, 0L, null);
            job.onExecuteStopHook();
            return true;
        });
    }

    public void errorJob(String jobId) {
        JobContextUtil.withTxAndRetry(() -> {
            AbstractExecutable job = this.getJob(jobId);
            this.errorJob(jobId, job);
            return true;
        });
    }

    private void errorJob(String jobId, AbstractExecutable job) {
        if (job == null) {
            return;
        }
        if (job instanceof DefaultExecutable) {
            List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
            tasks.stream().filter(task -> task.getStatus() != ExecutableState.ERROR).filter(task -> task.getStatus() != ExecutableState.SUCCEED).forEach(task -> this.updateJobOutput(task.getId(), ExecutableState.ERROR));
            tasks.forEach(task -> {
                Map<String, List<StageExecutable>> tasksMap;
                if (task instanceof ChainedStageExecutable && MapUtils.isNotEmpty(tasksMap = ((ChainedStageExecutable)((Object)task)).getStagesMap())) {
                    for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                        Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).stream().filter(stage -> stage.getStatus((String)entry.getKey()) != ExecutableState.ERROR && stage.getStatus((String)entry.getKey()) != ExecutableState.SUCCEED).forEach(stage -> this.updateStageStatus(stage.getId(), (String)entry.getKey(), ExecutableState.ERROR, null, null));
                    }
                }
            });
        }
        this.updateJobOutput(jobId, ExecutableState.ERROR);
    }

    public void updateStagePaused(AbstractExecutable job) {
        if (job instanceof DefaultExecutable) {
            List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
            tasks.forEach(task -> {
                Map<String, List<StageExecutable>> tasksMap;
                if (task instanceof ChainedStageExecutable && MapUtils.isNotEmpty(tasksMap = ((ChainedStageExecutable)((Object)task)).getStagesMap())) {
                    for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                        Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).stream().filter(stage -> stage.getStatus((String)entry.getKey()) == ExecutableState.RUNNING).forEach(stage -> this.updateStageStatus(stage.getId(), (String)entry.getKey(), ExecutableState.PAUSED, null, null));
                    }
                }
            });
        }
    }

    public Map<String, String> getWaiteTime(ExecutablePO executablePO, AbstractExecutable job) {
        try {
            Map<String, String> oldInfo = Optional.ofNullable(job.getOutput().getExtra()).orElse(Maps.newHashMap());
            HashMap info = Maps.newHashMap(oldInfo);
            if (job instanceof DefaultExecutable) {
                Map waiteTime = JsonUtil.readValueAsMap((String)info.getOrDefault("waiteTime", "{}"));
                List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
                for (AbstractExecutable task : tasks) {
                    Map.Entry<String, List<StageExecutable>> entry;
                    String segmentId;
                    long waitTime = task.getWaitTime();
                    long oldWaitTime = Long.parseLong(waiteTime.getOrDefault(task.getId(), "0"));
                    waiteTime.put(task.getId(), String.valueOf(waitTime + oldWaitTime));
                    if (!(task instanceof ChainedStageExecutable)) continue;
                    ChainedStageExecutable stageExecutable = (ChainedStageExecutable)((Object)task);
                    Map<String, List<StageExecutable>> stageMap = Optional.ofNullable(stageExecutable.getStagesMap()).orElse(Maps.newHashMap());
                    long taskStartTime = task.getStartTime();
                    Iterator<Map.Entry<String, List<StageExecutable>>> iterator = stageMap.entrySet().iterator();
                    while (iterator.hasNext() && !waiteTime.containsKey(segmentId = (entry = iterator.next()).getKey())) {
                        List<StageExecutable> stageExecutables = Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList());
                        if (!CollectionUtils.isNotEmpty(stageExecutables)) continue;
                        StageExecutable firstStage = stageExecutables.get(0);
                        long firstStageStartTime = this.getOutput(firstStage.getId(), executablePO, segmentId).getStartTime();
                        long stageWaiteTIme = firstStageStartTime - taskStartTime > 0L ? firstStageStartTime - taskStartTime : 0L;
                        long oldStageWaiteTIme = Long.parseLong(waiteTime.getOrDefault(segmentId, "0"));
                        waiteTime.put(segmentId, String.valueOf(stageWaiteTIme + oldStageWaiteTIme));
                    }
                }
                info.put("waiteTime", JsonUtil.writeValueAsString((Object)waiteTime));
            }
            return info;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void discardJob(String jobId) {
        this.discardJob(jobId, this.getJob(jobId));
    }

    public void deleteAllJobsOfProject() {
        JobContextUtil.withTxAndRetry(() -> {
            this.jobInfoDao.deleteJobsByProject(this.project);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobOutputToHDFS(String resPath, ExecutableOutputPO obj) {
        FSDataOutputStream dout = null;
        try {
            Path path = new Path(resPath);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            dout = fs.create(path, true);
            if (KylinConfig.getInstanceFromEnv().isJobTmpDirALLPermissionEnabled()) {
                fs.setPermission(path.getParent(), new FsPermission(FsAction.ALL, FsAction.READ, FsAction.ALL));
            }
            JsonUtil.writeValue((OutputStream)dout, (Object)obj);
            IOUtils.closeQuietly((OutputStream)dout);
        }
        catch (Exception e) {
            logger.error("update job output [{}] to HDFS failed.", (Object)resPath, (Object)e);
        }
        finally {
            IOUtils.closeQuietly(dout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableOutputPO getJobOutputFromHDFS(String resPath) {
        ExecutableOutputPO executableOutputPO;
        FileSystem fs;
        Path path;
        FSDataInputStream din;
        block5: {
            din = null;
            path = new Path(resPath);
            fs = HadoopUtil.getWorkingFileSystem();
            if (fs.exists(path)) break block5;
            ExecutableOutputPO executableOutputPO2 = new ExecutableOutputPO();
            executableOutputPO2.setContent("job output not found, please check kylin.log");
            ExecutableOutputPO executableOutputPO3 = executableOutputPO2;
            IOUtils.closeQuietly((InputStream)din);
            return executableOutputPO3;
        }
        try {
            din = fs.open(path);
            executableOutputPO = (ExecutableOutputPO)JsonUtil.readValue((InputStream)din, ExecutableOutputPO.class);
        }
        catch (Exception e) {
            ExecutableOutputPO executableOutputPO4;
            try {
                logger.error("get job output [{}] from HDFS failed.", (Object)resPath, (Object)e);
                ExecutableOutputPO executableOutputPO5 = new ExecutableOutputPO();
                executableOutputPO5.setContent("job output broken, please check kylin.log");
                executableOutputPO4 = executableOutputPO5;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(din);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)din);
            return executableOutputPO4;
        }
        IOUtils.closeQuietly((InputStream)din);
        return executableOutputPO;
    }

    public void makeStageSuccess(String taskOrJobId) {
        JobContextUtil.withTxAndRetry(() -> {
            String jobId = ExecutableManager.extractJobId(taskOrJobId);
            AbstractExecutable job = this.getJob(jobId);
            this.makeStageSuccess(taskOrJobId, job);
            return true;
        });
    }

    private void makeStageSuccess(String taskOrJobId, AbstractExecutable job) {
        if (job == null) {
            return;
        }
        if (job instanceof DefaultExecutable) {
            List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
            tasks.forEach(task -> {
                Map<String, List<StageExecutable>> tasksMap;
                if (task instanceof ChainedStageExecutable && StringUtils.equals((CharSequence)taskOrJobId, (CharSequence)task.getId()) && MapUtils.isNotEmpty(tasksMap = ((ChainedStageExecutable)((Object)task)).getStagesMap())) {
                    for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                        Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).stream().filter(stage -> stage.getStatus((String)entry.getKey()) != ExecutableState.SUCCEED).forEach(stage -> this.updateStageStatus(stage.getId(), (String)entry.getKey(), ExecutableState.SUCCEED, null, null));
                    }
                }
            });
        }
    }

    public void makeStageError(String taskOrJobId) {
        JobContextUtil.withTxAndRetry(() -> {
            String jobId = ExecutableManager.extractJobId(taskOrJobId);
            AbstractExecutable job = this.getJob(jobId);
            this.makeStageError(taskOrJobId, job);
            return true;
        });
    }

    private void makeStageError(String taskOrJobId, AbstractExecutable job) {
        if (job == null) {
            return;
        }
        if (job instanceof DefaultExecutable) {
            List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
            tasks.forEach(task -> {
                Map<String, List<StageExecutable>> tasksMap;
                if (task instanceof ChainedStageExecutable && StringUtils.equals((CharSequence)taskOrJobId, (CharSequence)task.getId()) && MapUtils.isNotEmpty(tasksMap = ((ChainedStageExecutable)((Object)task)).getStagesMap())) {
                    for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                        Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).stream().filter(stage -> stage.getStatus((String)entry.getKey()) == ExecutableState.RUNNING).forEach(stage -> this.updateStageStatus(stage.getId(), (String)entry.getKey(), ExecutableState.ERROR, null, null));
                    }
                }
            });
        }
    }

    public long countCuttingInJobByModel(String model, AbstractExecutable job) {
        return this.getPartialExecutables(model).stream().filter(e -> e.getTargetSubject() != null).filter(e -> e.getTargetSubject().equals(model)).filter(executable -> executable.getCreateTime() > job.getCreateTime()).count();
    }

    public List<AbstractExecutable> getAllExecutables() {
        ArrayList ret = Lists.newArrayList();
        for (ExecutablePO po : this.jobInfoDao.getJobs(this.project)) {
            try {
                AbstractExecutable ae = this.fromPO(po);
                ret.add(ae);
            }
            catch (Exception e) {
                logger.error(PARSE_ERROR_MSG, (Throwable)e);
            }
        }
        return ret;
    }

    public List<AbstractExecutable> getPartialExecutables(String modelId) {
        ArrayList ret = Lists.newArrayList();
        List<ExecutablePO> executablePOList = this.getExecutablePOByModelId(this.project, modelId);
        for (ExecutablePO po : executablePOList) {
            try {
                AbstractExecutable ae = this.fromPO(po);
                ret.add(ae);
            }
            catch (Exception e) {
                logger.error(PARSE_ERROR_MSG, (Throwable)e);
            }
        }
        return ret;
    }

    private List<ExecutablePO> getExecutablePOByModelId(String project, String modelId) {
        List<JobInfo> jobInfoList;
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        jobMapperFilter.setProject(project);
        if (null != modelId) {
            jobMapperFilter.setModelIds(Lists.newArrayList((Object[])new String[]{modelId}));
        }
        if (CollectionUtils.isEmpty(jobInfoList = this.jobInfoDao.getJobInfoListByFilter(jobMapperFilter))) {
            return Lists.newArrayList();
        }
        return jobInfoList.stream().map(jobInfo -> JobInfoUtil.deserializeExecutablePO(jobInfo)).collect(Collectors.toList());
    }

    public long countByModelAndStatus(String model, Predicate<ExecutableState> predicate) {
        return this.countByModelAndStatus(model, predicate, null);
    }

    public long countByModelAndStatus(String model, Predicate<ExecutableState> predicate, JobTypeEnum ... jobTypes) {
        return this.listExecByModelAndStatus(model, predicate, jobTypes).size();
    }

    public List<AbstractExecutable> listExecByModelAndStatus(String model, Predicate<ExecutableState> predicate, JobTypeEnum ... jobTypes) {
        return this.listExecutablePOByModelAndStatus(model, predicate, jobTypes).stream().map(this::fromPO).collect(Collectors.toList());
    }

    public List<ExecutablePO> listExecutablePOByModelAndStatus(String model, Predicate<ExecutableState> predicate, List<ExecutablePO> jobs, JobTypeEnum ... jobTypes) {
        boolean allPass = Array.isEmpty((Object[])jobTypes);
        return jobs.stream().filter(job -> null == model || null != job.getTargetModel() && job.getTargetModel().equals(model)).filter(job -> predicate.test(ExecutableState.valueOf(job.getOutput().getStatus()))).filter(job -> allPass || Lists.newArrayList((Object[])jobTypes).contains((Object)job.getJobType())).collect(Collectors.toList());
    }

    public List<ExecutablePO> listExecutablePOByModelAndStatus(String model, Predicate<ExecutableState> predicate, JobTypeEnum ... jobTypes) {
        return this.listExecutablePOByModelAndStatus(model, predicate, this.getExecutablePOByModelId(this.project, model), jobTypes);
    }

    public void setJobResumable(String taskOrJobId) {
        JobContextUtil.withTxAndRetry(() -> {
            String jobId = ExecutableManager.extractJobId(taskOrJobId);
            AbstractExecutable job = this.getJob(jobId);
            this.setJobResumable(taskOrJobId, job);
            return true;
        });
    }

    private void setJobResumable(String taskOrJobId, AbstractExecutable job) {
        String jobId = ExecutableManager.extractJobId(taskOrJobId);
        if (Objects.isNull(job)) {
            return;
        }
        if (Objects.equals(taskOrJobId, jobId)) {
            this.jobInfoDao.updateJob(jobId, executablePO -> {
                executablePO.getOutput().setResumable(true);
                return true;
            });
        } else {
            this.jobInfoDao.updateJob(jobId, executablePO -> {
                executablePO.getTasks().stream().filter(o -> Objects.equals(taskOrJobId, o.getId())).forEach(t -> t.getOutput().setResumable(true));
                return true;
            });
        }
    }

    public List<AbstractExecutable> listMultiPartitionModelExec(String model, Predicate<ExecutableState> predicate, JobTypeEnum jobType, Set<Long> targetPartitions, Set<String> segmentIds) {
        return this.getPartialExecutables(model).stream().filter(e -> e.getTargetSubject() != null).filter(e -> e.getTargetSubject().equals(model)).filter(e -> predicate.test(e.getStatusInMem())).filter(e -> {
            boolean checkAllPartition;
            boolean bl = checkAllPartition = CollectionUtils.isEmpty((Collection)targetPartitions) || JobTypeEnum.INDEX_REFRESH == e.getJobType() || JobTypeEnum.INDEX_REFRESH == jobType || JobTypeEnum.INDEX_BUILD == e.getJobType() || JobTypeEnum.INDEX_BUILD == jobType;
            if (checkAllPartition) {
                return true;
            }
            return !Sets.intersection(e.getTargetPartitions(), (Set)targetPartitions).isEmpty();
        }).filter(e -> {
            if (CollectionUtils.isEmpty((Collection)segmentIds)) {
                return true;
            }
            return !Sets.intersection(new HashSet<String>(e.getTargetSegments()), (Set)segmentIds).isEmpty();
        }).collect(Collectors.toList());
    }

    public List<ExecutablePO> getExecutablePOsByStatus(List<String> jobIds, List<ExecutableState> executableStates) {
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        jobMapperFilter.setProject(this.project);
        if (CollectionUtils.isNotEmpty(jobIds)) {
            jobMapperFilter.setJobIds(jobIds);
        }
        if (CollectionUtils.isNotEmpty(executableStates)) {
            jobMapperFilter.setStatuses(executableStates);
        }
        List<JobInfo> jobInfoList = this.jobInfoDao.getJobInfoListByFilter(jobMapperFilter);
        return jobInfoList.stream().map(jobInfo -> JobInfoUtil.deserializeExecutablePO(jobInfo)).collect(Collectors.toList());
    }

    public List<ExecutablePO> getExecutablePOsByStatus(List<ExecutableState> statuses) {
        return this.getExecutablePOsByStatus(null, statuses);
    }

    public List<AbstractExecutable> getExecutablesByStatus(List<String> jobIds, List<ExecutableState> statuses) {
        return this.getExecutablePOsByStatus(jobIds, statuses).stream().map(this::fromPO).collect(Collectors.toList());
    }

    public List<AbstractExecutable> getExecutablesByStatus(ExecutableState status) {
        return this.getExecutablesByStatus(null, Lists.newArrayList((Object[])new ExecutableState[]{status}));
    }

    public List<AbstractExecutable> getExecutablesByJobType(Set<JobTypeEnum> RELATED_JOBS) {
        List<String> jobTypeNames = RELATED_JOBS.stream().map(jobTypeEnum -> jobTypeEnum.name()).collect(Collectors.toList());
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        jobMapperFilter.setJobNames(jobTypeNames);
        List<JobInfo> jobInfoList = this.jobInfoDao.getJobInfoListByFilter(jobMapperFilter);
        return jobInfoList.stream().map(jobInfo -> JobInfoUtil.deserializeExecutablePO(jobInfo)).map(this::fromPO).collect(Collectors.toList());
    }

    public ExecutablePO getExecutablePO(String jobId) {
        return this.jobInfoDao.getExecutablePOByUuid(jobId);
    }

    public List<String> getJobs() {
        return this.getAllJobs().stream().sorted(Comparator.comparing(RootPersistentEntity::getCreateTime)).sorted(Comparator.comparing(ExecutablePO::getPriority)).map(RootPersistentEntity::resourceName).collect(Collectors.toList());
    }

    public List<ExecutablePO> getAllJobs() {
        return this.jobInfoDao.getJobs(this.project);
    }

    public List<ExecutablePO> getAllJobs(long timeStartInMillis, long timeEndInMillis) {
        return this.jobInfoDao.getJobs(this.project, timeStartInMillis, timeEndInMillis);
    }

    public List<AbstractExecutable> getAllExecutables(long timeStartInMillis, long timeEndInMillis) {
        return this.getAllJobs(timeStartInMillis, timeEndInMillis).stream().map(executablePO -> this.fromPO((ExecutablePO)((Object)executablePO))).collect(Collectors.toList());
    }

    public Output getOutputFromHDFSByJobId(String jobId) {
        return this.getOutputFromHDFSByJobId(jobId, jobId);
    }

    public Output getOutputFromHDFSByJobId(String jobId, String stepId) {
        return this.getOutputFromHDFSByJobId(jobId, stepId, 100);
    }

    public Output getOutputFromHDFSByJobId(String jobId, String stepId, int nLines) {
        String outputStorePath = KylinConfig.getInstanceFromEnv().getJobTmpOutputStorePath(this.project, stepId);
        ExecutableOutputPO jobOutput = this.getJobOutputFromHDFS(outputStorePath);
        this.assertOutputNotNull(jobOutput, outputStorePath);
        if (Objects.nonNull(jobOutput.getLogPath())) {
            if (this.isHdfsPathExists(jobOutput.getLogPath())) {
                if (nLines == 100) {
                    jobOutput.setContent(this.getSampleDataFromHDFS(jobOutput.getLogPath(), nLines));
                } else {
                    jobOutput.setContentStream(this.getLogStream(jobOutput.getLogPath()));
                }
            } else if (StringUtils.isEmpty((CharSequence)jobOutput.getContent()) && Objects.nonNull(this.getJob(jobId)) && this.getJob(jobId).getStatusInMem() == ExecutableState.RUNNING) {
                jobOutput.setContent("Wait a moment ... ");
            }
        }
        return this.parseOutput(jobOutput);
    }

    public InputStream getLogStream(String resPath) {
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            Path path = new Path(resPath);
            if (!fs.exists(path)) {
                return null;
            }
            return fs.open(path);
        }
        catch (IOException e) {
            logger.error("get FileSystem from hdfs log file [{}] failed!", (Object)resPath, (Object)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DOWNLOAD_FILE, (Throwable)e);
        }
    }

    public boolean isHdfsPathExists(String hdfsPath) {
        if (StringUtils.isBlank((CharSequence)hdfsPath)) {
            return false;
        }
        Path path = new Path(hdfsPath);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        try {
            return fs.exists(path);
        }
        catch (IOException e) {
            logger.error("check the hdfs path [{}] exists failed, ", (Object)hdfsPath, (Object)e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public String getSampleDataFromHDFS(String resPath, int nLines) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getSampleDataFromBothHDFS(String firstPath, String lastPath, int nLines) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String tailHdfsFileInputStream(FSDataInputStream hdfsDin, long startPos, long endPos, int nLines) throws IOException {
        int bytesRead;
        Preconditions.checkNotNull((Object)hdfsDin);
        Preconditions.checkArgument((startPos < endPos && startPos >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((nLines >= 0 ? 1 : 0) != 0);
        ArrayDeque<String> deque = new ArrayDeque<String>();
        int buffSize = 8192;
        byte[] byteBuf = new byte[buffSize];
        long pos = endPos;
        hdfsDin.seek(pos - 1L);
        int lastChar = hdfsDin.read();
        if (10 == lastChar) {
            --pos;
        }
        if ((bytesRead = (int)((pos - startPos) % (long)buffSize)) == 0) {
            bytesRead = buffSize;
        }
        pos -= (long)bytesRead;
        int lines = nLines;
        while (lines > 0 && pos >= startPos) {
            int last = bytesRead = hdfsDin.read(pos, byteBuf, 0, bytesRead);
            for (int i = bytesRead - 1; i >= 0 && lines > 0; --i) {
                if (byteBuf[i] != 10) continue;
                deque.push(new String(byteBuf, i, last - i, StandardCharsets.UTF_8));
                --lines;
                last = i;
            }
            if (lines > 0 && last > 0) {
                deque.push(new String(byteBuf, 0, last, StandardCharsets.UTF_8));
            }
            bytesRead = buffSize;
            pos -= (long)bytesRead;
        }
        StringBuilder sb = new StringBuilder();
        while (!deque.isEmpty()) {
            sb.append((String)deque.pop());
        }
        return sb.length() > 0 && sb.charAt(0) == '\n' ? sb.substring(1) : sb.toString();
    }

    @VisibleForTesting
    public List<AbstractExecutable> getRunningExecutables(String project, String model) {
        if (StringUtils.isNotBlank((CharSequence)model)) {
            return this.listExecByModelAndStatus(model, ExecutableState::isRunning, null);
        }
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        ArrayList runningStates = Lists.newArrayList();
        for (ExecutableState executableState : ExecutableState.values()) {
            if (!executableState.isRunning()) continue;
            runningStates.add(executableState);
        }
        jobMapperFilter.setStatuses(runningStates);
        jobMapperFilter.setProject(project);
        return this.jobInfoDao.getJobInfoListByFilter(jobMapperFilter).stream().map(jobInfo -> JobInfoUtil.deserializeExecutablePO(jobInfo)).map(this::fromPO).collect(Collectors.toList());
    }

    public void deleteJob(String jobId) {
        this.checkJobCanBeDeleted(this.fromPO(this.jobInfoDao.getExecutablePOByUuid(jobId)));
        this.jobInfoDao.dropJob(jobId);
    }

    public void deleteJobByIdList(List<String> jobIdList) {
        this.jobInfoDao.dropJobByIdList(jobIdList);
    }

    @VisibleForTesting
    public void deleteAllJob() {
        this.jobInfoDao.dropAllJobs();
    }

    public void suicideJob(String jobId) {
        JobContextUtil.withTxAndRetry(() -> {
            AbstractExecutable job = this.getJob(jobId);
            this.suicideJob(jobId, job);
            return true;
        });
    }

    private void suicideJob(String jobId, AbstractExecutable job) {
        if (job == null) {
            return;
        }
        if (job instanceof DefaultExecutable) {
            List<AbstractExecutable> tasks = ((DefaultExecutable)job).getTasks();
            tasks.stream().filter(task -> task.getStatus() != ExecutableState.SUICIDAL).filter(task -> task.getStatus() != ExecutableState.SUCCEED).forEach(task -> this.updateJobOutput(task.getId(), ExecutableState.SUICIDAL));
            tasks.forEach(task -> {
                Map<String, List<StageExecutable>> tasksMap;
                if (task instanceof ChainedStageExecutable && MapUtils.isNotEmpty(tasksMap = ((ChainedStageExecutable)((Object)task)).getStagesMap())) {
                    for (Map.Entry<String, List<StageExecutable>> entry : tasksMap.entrySet()) {
                        Optional.ofNullable(entry.getValue()).orElse(Lists.newArrayList()).stream().filter(stage -> stage.getStatus((String)entry.getKey()) != ExecutableState.SUICIDAL && stage.getStatus((String)entry.getKey()) != ExecutableState.SUCCEED).forEach(stage -> this.updateStageStatus(stage.getId(), (String)entry.getKey(), ExecutableState.SUICIDAL, null, null));
                    }
                }
            });
        }
        this.updateJobOutput(jobId, ExecutableState.SUICIDAL);
        job.cancelJob();
    }

    public void suicideRunningJobByJobType(String project, String targetModelId, List<String> jobType) {
        List<JobInfo> existingJobs = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project).fetchNotFinalJobsByTypes(project, jobType, Lists.newArrayList((Object[])new String[]{targetModelId}));
        ExecutableManager execMgr = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
        if (CollectionUtils.isNotEmpty(existingJobs)) {
            existingJobs.forEach(jobInfo -> execMgr.suicideJob(jobInfo.getJobId()));
        }
    }

    public void checkSuicideJobOfModel(String project, String modelId) {
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        jobMapperFilter.setProject(project);
        jobMapperFilter.setModelIds(Lists.newArrayList((Object[])new String[]{modelId}));
        jobMapperFilter.setStatuses(ExecutableState.ERROR, ExecutableState.PAUSED);
        List<JobInfo> errorJobInfoList = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project).fetchJobsByFilter(jobMapperFilter);
        if (CollectionUtils.isEmpty(errorJobInfoList)) {
            log.info("No job need to suicide, project: {}, model id: {}", (Object)project, (Object)modelId);
            return;
        }
        ExecutableManager executableManager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
        for (JobInfo jobInfo : errorJobInfoList) {
            String jobId = jobInfo.getJobId();
            JobContextUtil.withTxAndRetry(() -> {
                AbstractExecutable job = executableManager.getJob(jobId);
                if (JobCheckUtil.checkSuicide(job)) {
                    executableManager.suicideJob(jobId);
                    log.info("Suicide job: {}, project: {}, model id: {}", new Object[]{jobId, project, modelId});
                }
                return true;
            });
        }
    }

    public void resumeAllRunningJobs() {
        List<ExecutablePO> jobs = this.jobInfoDao.getJobs(this.project);
        CliCommandExecutor exe = this.getCliCommandExecutor();
        for (ExecutablePO executablePO : jobs) {
            try {
                this.jobInfoDao.updateJob(executablePO.getUuid(), this::resumeRunningJob);
            }
            catch (Exception e) {
                logger.warn("Failed to resume running job {}", (Object)executablePO.getUuid(), (Object)e);
            }
            this.killRemoteProcess(executablePO, exe);
        }
    }

    private boolean resumeRunningJob(ExecutablePO po) {
        boolean result = false;
        if (po.getOutput().getStatus().equalsIgnoreCase(ExecutableState.RUNNING.toString())) {
            HashMap info = Maps.newHashMap();
            if (Objects.nonNull(po.getOutput().getInfo())) {
                info.putAll(po.getOutput().getInfo());
            }
            Optional.ofNullable(REMOVE_INFO).ifPresent(set -> set.forEach(info::remove));
            po.getOutput().setInfo(info);
            po.getOutput().setStatus(ExecutableState.READY.toString());
            po.getOutput().addEndTime(System.currentTimeMillis());
            result = true;
        }
        for (ExecutablePO task : Optional.ofNullable(po.getTasks()).orElse(Lists.newArrayList())) {
            result = this.resumeRunningJob(task) || result;
        }
        return result;
    }

    public List<AbstractExecutable> getExecutablesByStatusList(Set<ExecutableState> statusSet) {
        Preconditions.checkNotNull(statusSet);
        ArrayList filterJobs = Lists.newArrayList(this.jobInfoDao.getJobs(this.project));
        if (CollectionUtils.isNotEmpty(statusSet)) {
            filterJobs.removeIf(job -> !statusSet.contains((Object)ExecutableState.valueOf(job.getOutput().getStatus())));
        }
        return filterJobs.stream().map(this::fromPO).collect(Collectors.toList());
    }

    public List<AbstractExecutable> getPartialExecutablesByStatusList(Set<ExecutableState> statusSet, String modelId) {
        Preconditions.checkNotNull(statusSet);
        List<ExecutablePO> filterJobs = this.getExecutablePOByModelId(this.project, modelId);
        if (CollectionUtils.isNotEmpty(statusSet)) {
            filterJobs.removeIf(job -> !statusSet.contains((Object)ExecutableState.valueOf(job.getOutput().getStatus())));
        }
        return filterJobs.stream().map(this::fromPO).collect(Collectors.toList());
    }

    public List<ExecutablePO> getRunningJobs(int priority) {
        return this.jobInfoDao.getJobs(null).stream().filter(po -> {
            Output output = this.getOutput(po.getId());
            return ExecutablePO.isHigherPriority(po.getPriority(), priority) && output.getState().isProgressing();
        }).collect(Collectors.toList());
    }

    public Set<String> getYarnApplicationJobs(String id) {
        ExecutablePO executablePO = this.jobInfoDao.getExecutablePOByUuid(id);
        String appIds = executablePO.getOutput().getInfo().getOrDefault("yarn_application_ids", "");
        return StringUtils.isEmpty((CharSequence)appIds) ? new TreeSet<String>() : new TreeSet<String>(Arrays.asList(appIds.split(",")));
    }

    public long getLastSuccessExecDurationByModel(String modelId, List<ExecutablePO> jobs, JobTypeEnum ... jobTypes) {
        List<ExecutablePO> executables = this.listExecutablePOByModelAndStatus(modelId, (ExecutableState state) -> ExecutableState.SUCCEED == state, jobs, jobTypes);
        if (CollectionUtils.isEmpty(executables)) {
            return 0L;
        }
        return executables.stream().max(Comparator.comparingLong(exec -> exec.getOutput().getEndTime())).map(exec -> AbstractExecutable.getDuration(this.getOutput(exec.getId()))).orElse(0L);
    }

    public long getMaxDurationRunningExecDurationByModel(String modelId, List<ExecutablePO> jobs, JobTypeEnum ... jobTypes) {
        List<ExecutablePO> executables = this.listExecutablePOByModelAndStatus(modelId, (ExecutableState state) -> ExecutableState.RUNNING == state, jobs, jobTypes);
        if (CollectionUtils.isEmpty(executables)) {
            return 0L;
        }
        return executables.stream().map(exec -> AbstractExecutable.getDuration(this.getOutput(exec.getId()))).max(Long::compareTo).orElse(0L);
    }

    public List<ExecutablePO> listPartialExec(String modelId, Predicate<ExecutableState> predicate, JobTypeEnum ... jobTypes) {
        if (jobTypes == null) {
            return Lists.newArrayList();
        }
        ArrayList jobTypeList = Lists.newArrayList((Object[])jobTypes);
        return this.getExecutablePOByModelId(this.project, modelId).stream().filter(job -> job.getJobType() != null).filter(job -> jobTypeList.contains((Object)job.getJobType())).filter(job -> predicate.test(ExecutableState.valueOf(job.getOutput().getStatus()))).collect(Collectors.toList());
    }

    public Output getStreamingOutputFromHDFS(String jobId) {
        return this.getStreamingOutputFromHDFS(jobId, 100);
    }

    public Output getStreamingOutputFromHDFS(String jobId, int nLines) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)jobId), (Object)"The jobId is empty");
        ExecutableOutputPO jobOutput = new ExecutableOutputPO();
        String outputStoreDirPath = KylinConfig.getInstanceFromEnv().getStreamingJobTmpOutputStorePath(this.project, jobId);
        if (!this.isHdfsPathExists(outputStoreDirPath)) {
            logger.warn("The job log file on HDFS has not been generated yet, jobId: {}, filePath: {}", (Object)jobId, (Object)outputStoreDirPath);
            jobOutput.setContent("");
            return this.parseOutput(jobOutput);
        }
        List<String> jobStartedList = this.getFilePathsFromHDFSDir(outputStoreDirPath);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(jobStartedList), (Object)("The current job has not been started and no log has been generated: " + outputStoreDirPath));
        List<String> logFilePathList = this.getFilePathsFromHDFSDir(jobStartedList.get(jobStartedList.size() - 1), false);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(logFilePathList), (Object)("There is no file in the current job HDFS directory: " + jobStartedList.get(jobStartedList.size() - 1)));
        String latestLogFilePath = logFilePathList.get(logFilePathList.size() - 1);
        String firstLogFilePath = logFilePathList.get(0);
        if (nLines == 100) {
            jobOutput.setContent(this.getSampleDataFromBothHDFS(firstLogFilePath, latestLogFilePath, 100));
        } else {
            jobOutput.setContentStream(this.mergeHdfsFile(logFilePathList));
        }
        return this.parseOutput(jobOutput);
    }

    public List<String> getFilePathsFromHDFSDir(String resPath, boolean recursive) {
        try {
            ArrayList fileList = Lists.newArrayList();
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            Path path = new Path(resPath);
            RemoteIterator files = fs.listFiles(path, recursive);
            while (files.hasNext()) {
                fileList.add(((LocatedFileStatus)files.next()).getPath().toString());
            }
            Collections.sort(fileList);
            return fileList;
        }
        catch (IOException e) {
            logger.error("get file paths from hdfs [{}] failed!", (Object)resPath, (Object)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_NOT_EXIST, (Throwable)e);
        }
    }

    public List<String> getFilePathsFromHDFSDir(String resPath) {
        try {
            FileStatus[] fileStatuses;
            ArrayList fileList = Lists.newArrayList();
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            Path path = new Path(resPath);
            for (FileStatus fileStatus : fileStatuses = fs.listStatus(path)) {
                fileList.add(fileStatus.getPath().toString());
            }
            Collections.sort(fileList);
            return fileList;
        }
        catch (IOException e) {
            logger.error("get file paths from hdfs [{}] failed!", (Object)resPath, (Object)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_NOT_EXIST, (Throwable)e);
        }
    }

    public InputStream mergeHdfsFile(List<String> logPathList) {
        Vector inputStreamVector = new Vector();
        logPathList.forEach(path -> inputStreamVector.add(this.getLogStream((String)path)));
        return new SequenceInputStream(inputStreamVector.elements());
    }

    @VisibleForTesting
    public void removeBreakPoints(String taskOrJobId) {
        String jobId = ExecutableManager.extractJobId(taskOrJobId);
        ExecutablePO executablePO = this.jobInfoDao.getExecutablePOByUuid(jobId);
        if (Objects.isNull((Object)executablePO)) {
            return;
        }
        if (Objects.equals(taskOrJobId, jobId)) {
            this.jobInfoDao.updateJob(jobId, job -> {
                job.getParams().remove("breakPointLayouts");
                return true;
            });
        } else {
            this.jobInfoDao.updateJob(jobId, job -> {
                job.getTasks().stream().filter(t -> t.getId().equals(taskOrJobId)).forEach(t -> t.getParams().remove("breakPointLayouts"));
                return true;
            });
        }
    }

    public List<JobInfo> fetchNotFinalJobsByTypes(String project, List<String> jobTypes, List<String> subjects) {
        return this.fetchJobsByTypesAndStates(project, jobTypes, subjects, ExecutableState.getNotFinalStates());
    }

    public List<JobInfo> fetchJobsByTypesAndStates(String project, List<String> jobTypes, List<String> subjects, List<ExecutableState> states) {
        JobMapperFilter mapperFilter = JobMapperFilter.builder().jobNames(jobTypes).statuses(states).subjects(subjects).project(project).build();
        return this.jobInfoDao.getJobInfoListByFilter(mapperFilter);
    }

    public List<AbstractExecutable> getNotFinalExecutablesByType(List<JobTypeEnum> jobTypeEnums) {
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        jobMapperFilter.setProject(this.project);
        jobMapperFilter.setStatuses(ExecutableState.getNotFinalStates());
        if (CollectionUtils.isNotEmpty(jobTypeEnums)) {
            jobMapperFilter.setJobNames(jobTypeEnums.stream().map(jobTypeEnum -> jobTypeEnum.name()).collect(Collectors.toList()));
        }
        List<JobInfo> jobInfoList = this.jobInfoDao.getJobInfoListByFilter(jobMapperFilter);
        return jobInfoList.stream().map(jobInfo -> this.fromPO(JobInfoUtil.deserializeExecutablePO(jobInfo))).collect(Collectors.toList());
    }

    public List<JobInfo> fetchJobsByFilter(JobMapperFilter filter) {
        return this.jobInfoDao.getJobInfoListByFilter(filter);
    }

    public List<AbstractExecutable> jobInfoToExecutable(List<JobInfo> jobInfoList) {
        return jobInfoList.stream().map(JobInfoUtil::deserializeExecutablePO).map(executablePO -> this.fromPO((ExecutablePO)((Object)executablePO))).collect(Collectors.toList());
    }
}

