/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.core.lock;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.util.ThreadUtils;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.core.lock.JdbcJobLock;
import org.apache.kylin.job.core.lock.LockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcLockClient {
    private static final Logger logger = LoggerFactory.getLogger(JdbcLockClient.class);
    private final JobContext jobContext;
    private ScheduledExecutorService scheduler;
    private Map<String, JdbcJobLock> renewalMap;

    public JdbcLockClient(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public void start() {
        this.scheduler = ThreadUtils.newDaemonThreadScheduledExecutor((int)this.jobContext.getKylinConfig().getJobLockClientRenewalMaxThreads(), (String)"JdbcJobLockClient");
        this.renewalMap = Maps.newConcurrentMap();
    }

    public void destroy() {
        if (Objects.nonNull(this.scheduler)) {
            this.scheduler.shutdownNow();
        }
        if (Objects.nonNull(this.renewalMap)) {
            this.renewalMap = null;
        }
    }

    public void stopRenew(String lockId) {
        if (Objects.nonNull(this.renewalMap)) {
            this.renewalMap.remove(lockId);
        }
    }

    public boolean tryAcquire(JdbcJobLock jobLock) throws LockException {
        boolean acquired = this.tryAcquireInternal(jobLock);
        if (acquired) {
            this.renewalMap.put(jobLock.getLockId(), jobLock);
            this.scheduler.schedule(() -> this.renewal(jobLock), jobLock.getRenewalDelaySec(), TimeUnit.SECONDS);
        }
        return acquired;
    }

    public boolean tryRelease(JdbcJobLock jobLock) throws LockException {
        try {
            int r = this.jobContext.getJobLockMapper().removeLock(jobLock.getLockId(), jobLock.getLockNode());
            boolean bl = r > 0;
            return bl;
        }
        catch (Exception e) {
            throw new LockException("Release lock failed", e);
        }
        finally {
            this.stopRenew(jobLock.getLockId());
        }
    }

    private void renewal(JdbcJobLock jobLock) {
        if (!this.renewalMap.containsKey(jobLock.getLockId())) {
            logger.info("Renewal skip released lock {}", (Object)jobLock.getLockId());
            return;
        }
        boolean acquired = false;
        try {
            acquired = this.tryAcquireInternal(jobLock);
        }
        catch (LockException e) {
            logger.error("Renewal lock failed", (Throwable)e);
        }
        if (acquired) {
            this.scheduler.schedule(() -> this.renewal(jobLock), jobLock.getRenewalDelaySec(), TimeUnit.SECONDS);
        }
    }

    private boolean tryAcquireInternal(JdbcJobLock jobLock) throws LockException {
        boolean acquired = false;
        try {
            int r = this.jobContext.getJobLockMapper().updateLock(jobLock.getLockId(), jobLock.getLockNode(), jobLock.getRenewalSec(), System.currentTimeMillis());
            boolean bl = acquired = r > 0;
            return bl;
        }
        catch (Exception e) {
            throw new LockException("Acquire lock failed", e);
        }
        finally {
            if (acquired) {
                jobLock.getAcquireListener().onSucceed();
            } else {
                jobLock.getAcquireListener().onFailed();
            }
        }
    }
}

