/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema.strategy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;
import org.apache.kylin.metadata.model.schema.strategy.SchemaChangeStrategy;

public class TableStrategy
implements SchemaChangeStrategy {
    @Override
    public List<SchemaNodeType> supportedSchemaNodeTypes() {
        return Collections.singletonList(SchemaNodeType.MODEL_TABLE);
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> missingItems(SchemaUtil.SchemaDifference difference, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return difference.getNodeDiff().entriesOnlyOnRight().entrySet().stream().filter(pair -> this.supportedSchemaNodeTypes().contains((Object)((SchemaNode.SchemaNodeIdentifier)pair.getKey()).getType())).map(pair -> this.missingItemFunction(difference, (Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode>)pair, importModels, originalModels, originalBrokenModels)).flatMap(Collection::stream).filter(schemaChange -> importModels.contains(schemaChange.getModelAlias())).collect(Collectors.toList());
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> missingItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return this.reachableModel(difference.getTargetGraph(), entry.getValue()).stream().map(modelAlias -> SchemaChangeCheckResult.ChangedItem.createUnImportableSchemaNode(((SchemaNode.SchemaNodeIdentifier)entry.getKey()).getType(), (SchemaNode)entry.getValue(), modelAlias, SchemaChangeCheckResult.UN_IMPORT_REASON.MISSING_TABLE, ((SchemaNode)entry.getValue()).getDetail(), this.hasSameName((String)modelAlias, originalModels), this.hasSameWithBroken((String)modelAlias, originalBrokenModels))).collect(Collectors.toList());
    }
}

