/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema.strategy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.guava30.shaded.common.collect.MapDifference;
import org.apache.kylin.guava30.shaded.common.graph.Graph;
import org.apache.kylin.guava30.shaded.common.graph.Graphs;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;

public interface SchemaChangeStrategy {
    public List<SchemaNodeType> supportedSchemaNodeTypes();

    default public List<SchemaChangeCheckResult.ChangedItem> missingItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return Collections.emptyList();
    }

    default public List<SchemaChangeCheckResult.ChangedItem> missingItems(SchemaUtil.SchemaDifference difference, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return Collections.emptyList();
    }

    default public List<SchemaChangeCheckResult.ChangedItem> newItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return Collections.emptyList();
    }

    default public List<SchemaChangeCheckResult.ChangedItem> newItems(SchemaUtil.SchemaDifference difference, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return difference.getNodeDiff().entriesOnlyOnRight().entrySet().stream().filter(entry -> this.supportedSchemaNodeTypes().contains((Object)((SchemaNode.SchemaNodeIdentifier)entry.getKey()).getType())).map(entry -> this.newItemFunction(difference, (Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode>)entry, importModels, originalModels, originalBrokenModels)).flatMap(Collection::stream).filter(schemaChange -> importModels.contains(schemaChange.getModelAlias())).collect(Collectors.toList());
    }

    default public List<SchemaChangeCheckResult.UpdatedItem> updateItemFunction(SchemaUtil.SchemaDifference difference, MapDifference.ValueDifference<SchemaNode> diff, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        String modelAlias = ((SchemaNode)diff.rightValue()).getSubject();
        boolean overwritable = this.overwritable(importModels, originalModels, modelAlias);
        SchemaChangeCheckResult.BaseItemParameter parameter = new SchemaChangeCheckResult.BaseItemParameter(this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels), true, true, overwritable);
        return Collections.singletonList(SchemaChangeCheckResult.UpdatedItem.getSchemaUpdate((SchemaNode)diff.leftValue(), (SchemaNode)diff.rightValue(), modelAlias, parameter));
    }

    default public List<SchemaChangeCheckResult.UpdatedItem> updateItems(SchemaUtil.SchemaDifference difference, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return difference.getNodeDiff().entriesDiffering().values().stream().filter(entry -> this.supportedSchemaNodeTypes().contains((Object)((SchemaNode)entry.leftValue()).getType())).map(diff -> this.updateItemFunction(difference, (MapDifference.ValueDifference<SchemaNode>)diff, importModels, originalModels, originalBrokenModels)).flatMap(Collection::stream).filter(schemaChange -> importModels.contains(schemaChange.getModelAlias())).collect(Collectors.toList());
    }

    default public List<SchemaChangeCheckResult.ChangedItem> reduceItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return Collections.emptyList();
    }

    default public List<SchemaChangeCheckResult.ChangedItem> reduceItems(SchemaUtil.SchemaDifference difference, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return difference.getNodeDiff().entriesOnlyOnLeft().entrySet().stream().filter(entry -> this.supportedSchemaNodeTypes().contains((Object)((SchemaNode.SchemaNodeIdentifier)entry.getKey()).getType())).map(entry -> this.reduceItemFunction(difference, (Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode>)entry, importModels, originalModels, originalBrokenModels)).flatMap(Collection::stream).filter(schemaChange -> importModels.contains(schemaChange.getModelAlias())).collect(Collectors.toList());
    }

    default public List<String> areEqual(SchemaUtil.SchemaDifference difference, Set<String> importModels) {
        return difference.getNodeDiff().entriesInCommon().values().stream().filter(schemaNode -> schemaNode.getType() == SchemaNodeType.MODEL_FACT).filter(schemaChange -> importModels.contains(schemaChange.getSubject())).map(SchemaNode::getSubject).collect(Collectors.toList());
    }

    default public boolean overwritable(Set<String> importModels, Set<String> originalModels, String modelAlias) {
        return importModels.contains(modelAlias) && originalModels.contains(modelAlias);
    }

    default public boolean hasSameName(String modelAlias, Set<String> originalModels) {
        return originalModels.contains(modelAlias);
    }

    default public Set<String> reachableModel(Graph<SchemaNode> graph, SchemaNode schemaNode) {
        return Graphs.reachableNodes(graph, (Object)schemaNode).stream().filter(SchemaNode::isModelNode).map(SchemaNode::getSubject).collect(Collectors.toSet());
    }

    default public boolean hasSameWithBroken(String modelAlias, Set<String> originalBrokenModels) {
        return originalBrokenModels.contains(modelAlias);
    }
}

