/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.graph.Graph;
import org.apache.kylin.guava30.shaded.common.graph.Graphs;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;

public class AffectedModelContext {
    @NonNull
    private final Set<SchemaNode> updatedNodes;
    private final Set<SchemaNode> shouldDeleteNodes;
    private final String project;
    private final String modelId;
    private final String modelAlias;
    private final boolean isBroken;
    private Set<Long> updatedLayouts = Sets.newHashSet();
    private Set<Long> shouldDeleteLayouts = Sets.newHashSet();
    private Set<Long> addLayouts = Sets.newHashSet();
    private Set<Integer> dimensions = Sets.newHashSet();
    private Set<Integer> measures = Sets.newHashSet();
    private Set<Integer> columns = Sets.newHashSet();
    private Set<String> computedColumns = Sets.newHashSet();
    private Map<NDataModel.Measure, NDataModel.Measure> updateIdMeasureMap = Maps.newHashMap();
    private Map<Integer, NDataModel.Measure> updateMeasureMap = Maps.newHashMap();
    Predicate<SchemaNode> deletableIndexPredicate = node -> node.getType() == SchemaNodeType.WHITE_LIST_INDEX || node.getType() == SchemaNodeType.RULE_BASED_INDEX || node.getType() == SchemaNodeType.TO_BE_DELETED_INDEX;

    public AffectedModelContext(String project, String modelId, Set<SchemaNode> updatedNodes, boolean isDelete) {
        this(project, modelId, updatedNodes, (Set<Pair<NDataModel.Measure, NDataModel.Measure>>)Sets.newHashSet(), isDelete);
    }

    public AffectedModelContext(String project, String modelId, Set<SchemaNode> updatedNodes, Set<Pair<NDataModel.Measure, NDataModel.Measure>> updateMeasures, boolean isDelete) {
        this.project = project;
        this.modelId = modelId;
        this.modelAlias = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), project).getDataModelDesc(modelId).getAlias();
        this.updatedNodes = updatedNodes;
        this.updateIdMeasureMap = updateMeasures.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        this.updateMeasureMap = updateMeasures.stream().collect(Collectors.toMap(pair -> ((NDataModel.Measure)pair.getFirst()).getId(), Pair::getSecond));
        this.shouldDeleteNodes = this.calcShouldDeletedNodes(isDelete);
        this.isBroken = isDelete ? updatedNodes.stream().anyMatch(SchemaNode::isCauseModelBroken) : false;
        this.updatedLayouts = this.filterIndexFromNodes(updatedNodes);
        this.shouldDeleteLayouts = this.filterIndexFromNodes(this.shouldDeleteNodes);
        this.columns = this.shouldDeleteNodes.stream().filter(node -> node.getType() == SchemaNodeType.MODEL_COLUMN).map(node -> Integer.parseInt(node.getDetail())).collect(Collectors.toSet());
        this.dimensions = this.shouldDeleteNodes.stream().filter(node -> node.getType() == SchemaNodeType.MODEL_DIMENSION).map(node -> Integer.parseInt(node.getDetail())).collect(Collectors.toSet());
        this.measures = this.shouldDeleteNodes.stream().filter(node -> node.getType() == SchemaNodeType.MODEL_MEASURE).map(node -> Integer.parseInt(node.getDetail())).collect(Collectors.toSet());
        this.computedColumns = this.shouldDeleteNodes.stream().filter(node -> node.getType() == SchemaNodeType.MODEL_CC).map(SchemaNode::getDetail).collect(Collectors.toSet());
    }

    public AffectedModelContext(String project, IndexPlan originIndexPlan, Set<SchemaNode> updatedNodes, Set<Pair<NDataModel.Measure, NDataModel.Measure>> updateMeasures, boolean isDelete) {
        this(project, originIndexPlan.getId(), updatedNodes, updateMeasures, isDelete);
        IndexPlan indexPlanCopy = originIndexPlan.copy();
        this.shrinkIndexPlan(indexPlanCopy);
        Set originLayoutIds = originIndexPlan.getAllLayouts().stream().map(LayoutEntity::getId).collect(Collectors.toSet());
        this.addLayouts = indexPlanCopy.getAllLayouts().stream().map(LayoutEntity::getId).filter(id -> !originLayoutIds.contains(id)).collect(Collectors.toSet());
    }

    public void shrinkIndexPlan(IndexPlan indexPlan) {
        UnaryOperator dimFilter = input -> (Integer[])Stream.of(input).filter(i -> !this.dimensions.contains(i)).toArray(Integer[]::new);
        UnaryOperator meaFilter = input -> (Integer[])Stream.of(input).map(i -> {
            if (this.updateMeasureMap.containsKey(i)) {
                i = this.updateMeasureMap.get(i).getId();
            }
            return i;
        }).filter(i -> !this.measures.contains(i)).toArray(Integer[]::new);
        indexPlan.removeLayouts(this.shouldDeleteLayouts, true, true);
        HashMap overrideIndexes = Maps.newHashMap(indexPlan.getIndexPlanOverrideIndexes());
        this.columns.forEach(overrideIndexes::remove);
        indexPlan.setIndexPlanOverrideIndexes(overrideIndexes);
        if (indexPlan.getDictionaries() != null) {
            indexPlan.setDictionaries(indexPlan.getDictionaries().stream().filter(d -> !this.columns.contains(d.getId())).collect(Collectors.toList()));
        }
        if (indexPlan.getRuleBasedIndex() == null) {
            return;
        }
        RuleBasedIndex rule = (RuleBasedIndex)JsonUtil.deepCopyQuietly((Object)indexPlan.getRuleBasedIndex(), RuleBasedIndex.class);
        rule.setLayoutIdMapping(Lists.newArrayList());
        rule.setDimensions(rule.getDimensions().stream().filter(d -> !this.dimensions.contains(d)).collect(Collectors.toList()));
        rule.setMeasures(rule.getMeasures().stream().map(i -> {
            if (this.updateMeasureMap.containsKey(i)) {
                i = this.updateMeasureMap.get(i).getId();
            }
            return i;
        }).filter(i -> !this.measures.contains(i)).collect(Collectors.toList()));
        List<NAggregationGroup> newAggGroups = rule.getAggregationGroups().stream().peek(group -> {
            group.setIncludes((Integer[])dimFilter.apply(group.getIncludes()));
            group.setMeasures((Integer[])meaFilter.apply(group.getMeasures()));
            group.getSelectRule().mandatoryDims = (Integer[])dimFilter.apply(group.getSelectRule().mandatoryDims);
            group.getSelectRule().hierarchyDims = (Integer[][])Stream.of(group.getSelectRule().hierarchyDims).map(dimFilter).filter(dims -> ((Integer[])dims).length > 0).toArray(x$0 -> new Integer[x$0][]);
            group.getSelectRule().jointDims = (Integer[][])Stream.of(group.getSelectRule().jointDims).map(dimFilter).filter(dims -> ((Integer[])dims).length > 0).toArray(x$0 -> new Integer[x$0][]);
        }).filter(group -> ArrayUtils.isNotEmpty((Object[])group.getIncludes())).collect(Collectors.toList());
        rule.setAggregationGroups(newAggGroups);
        indexPlan.setRuleBasedIndex(rule);
        if (this.updatedNodes.contains(SchemaNodeType.INDEX_AGG_SHARD.withKey(indexPlan.getModelAlias()))) {
            indexPlan.setAggShardByColumns(Lists.newArrayList());
        }
        if (this.updatedNodes.contains(SchemaNodeType.INDEX_AGG_EXTEND_PARTITION.withKey(indexPlan.getModelAlias()))) {
            indexPlan.setExtendPartitionColumns(Lists.newArrayList());
        }
    }

    private Set<Long> filterIndexFromNodes(Set<SchemaNode> nodes) {
        return nodes.stream().filter(this.deletableIndexPredicate).map(node -> Long.parseLong(node.getDetail())).collect(Collectors.toSet());
    }

    private Set<SchemaNode> calcShouldDeletedNodes(boolean isDelete) {
        HashSet result = Sets.newHashSet();
        if (isDelete) {
            return this.updatedNodes;
        }
        NDataModel model = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project).getDataModelDesc(this.modelId);
        Graph<SchemaNode> schemaNodeGraph = SchemaUtil.dependencyGraph(this.project, model);
        this.updatedNodes.stream().filter(node -> node.getType() == SchemaNodeType.MODEL_MEASURE).filter(node -> !this.updateMeasureMap.containsKey(Integer.parseInt(node.getDetail()))).forEach(node -> {
            result.add(node);
            Graphs.reachableNodes((Graph)schemaNodeGraph, (Object)node).stream().filter(this.deletableIndexPredicate).forEach(result::add);
        });
        this.updateIdMeasureMap.keySet().forEach(originalMeasure -> Graphs.reachableNodes((Graph)schemaNodeGraph, (Object)SchemaNode.ofMeasure(originalMeasure, this.modelAlias)).stream().filter(this.deletableIndexPredicate).forEach(result::add));
        return result;
    }

    public Set<String> getMeasuresKey() {
        return this.shouldDeleteNodes.stream().filter(node -> node.getType() == SchemaNodeType.MODEL_MEASURE && this.measures.contains(Integer.parseInt(node.getDetail()))).map(SchemaNode::getKey).collect(Collectors.toSet());
    }

    public Set<String> getDimensionsKey() {
        return this.shouldDeleteNodes.stream().filter(node -> node.getType() == SchemaNodeType.MODEL_DIMENSION && this.dimensions.contains(Integer.parseInt(node.getDetail()))).map(SchemaNode::getKey).collect(Collectors.toSet());
    }

    @NonNull
    @Generated
    public Set<SchemaNode> getUpdatedNodes() {
        return this.updatedNodes;
    }

    @Generated
    public Set<SchemaNode> getShouldDeleteNodes() {
        return this.shouldDeleteNodes;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getModelAlias() {
        return this.modelAlias;
    }

    @Generated
    public boolean isBroken() {
        return this.isBroken;
    }

    @Generated
    public Set<Integer> getDimensions() {
        return this.dimensions;
    }

    @Generated
    public Set<Integer> getMeasures() {
        return this.measures;
    }

    @Generated
    public Set<Integer> getColumns() {
        return this.columns;
    }

    @Generated
    public Set<String> getComputedColumns() {
        return this.computedColumns;
    }

    @Generated
    public Map<NDataModel.Measure, NDataModel.Measure> getUpdateIdMeasureMap() {
        return this.updateIdMeasureMap;
    }

    @Generated
    public Map<Integer, NDataModel.Measure> getUpdateMeasureMap() {
        return this.updateMeasureMap;
    }

    @Generated
    public Predicate<SchemaNode> getDeletableIndexPredicate() {
        return this.deletableIndexPredicate;
    }

    @Generated
    public void setUpdatedLayouts(Set<Long> updatedLayouts) {
        this.updatedLayouts = updatedLayouts;
    }

    @Generated
    public void setShouldDeleteLayouts(Set<Long> shouldDeleteLayouts) {
        this.shouldDeleteLayouts = shouldDeleteLayouts;
    }

    @Generated
    public void setAddLayouts(Set<Long> addLayouts) {
        this.addLayouts = addLayouts;
    }

    @Generated
    public void setDimensions(Set<Integer> dimensions) {
        this.dimensions = dimensions;
    }

    @Generated
    public void setMeasures(Set<Integer> measures) {
        this.measures = measures;
    }

    @Generated
    public void setColumns(Set<Integer> columns) {
        this.columns = columns;
    }

    @Generated
    public void setComputedColumns(Set<String> computedColumns) {
        this.computedColumns = computedColumns;
    }

    @Generated
    public void setUpdateIdMeasureMap(Map<NDataModel.Measure, NDataModel.Measure> updateIdMeasureMap) {
        this.updateIdMeasureMap = updateIdMeasureMap;
    }

    @Generated
    public void setUpdateMeasureMap(Map<Integer, NDataModel.Measure> updateMeasureMap) {
        this.updateMeasureMap = updateMeasureMap;
    }

    @Generated
    public void setDeletableIndexPredicate(Predicate<SchemaNode> deletableIndexPredicate) {
        this.deletableIndexPredicate = deletableIndexPredicate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AffectedModelContext)) {
            return false;
        }
        AffectedModelContext other = (AffectedModelContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<SchemaNode> this$updatedNodes = this.getUpdatedNodes();
        Set<SchemaNode> other$updatedNodes = other.getUpdatedNodes();
        if (this$updatedNodes == null ? other$updatedNodes != null : !((Object)this$updatedNodes).equals(other$updatedNodes)) {
            return false;
        }
        Set<SchemaNode> this$shouldDeleteNodes = this.getShouldDeleteNodes();
        Set<SchemaNode> other$shouldDeleteNodes = other.getShouldDeleteNodes();
        if (this$shouldDeleteNodes == null ? other$shouldDeleteNodes != null : !((Object)this$shouldDeleteNodes).equals(other$shouldDeleteNodes)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        String this$modelAlias = this.getModelAlias();
        String other$modelAlias = other.getModelAlias();
        if (this$modelAlias == null ? other$modelAlias != null : !this$modelAlias.equals(other$modelAlias)) {
            return false;
        }
        if (this.isBroken() != other.isBroken()) {
            return false;
        }
        Set<Long> this$updatedLayouts = this.getUpdatedLayouts();
        Set<Long> other$updatedLayouts = other.getUpdatedLayouts();
        if (this$updatedLayouts == null ? other$updatedLayouts != null : !((Object)this$updatedLayouts).equals(other$updatedLayouts)) {
            return false;
        }
        Set<Long> this$shouldDeleteLayouts = this.getShouldDeleteLayouts();
        Set<Long> other$shouldDeleteLayouts = other.getShouldDeleteLayouts();
        if (this$shouldDeleteLayouts == null ? other$shouldDeleteLayouts != null : !((Object)this$shouldDeleteLayouts).equals(other$shouldDeleteLayouts)) {
            return false;
        }
        Set<Long> this$addLayouts = this.getAddLayouts();
        Set<Long> other$addLayouts = other.getAddLayouts();
        if (this$addLayouts == null ? other$addLayouts != null : !((Object)this$addLayouts).equals(other$addLayouts)) {
            return false;
        }
        Set<Integer> this$dimensions = this.getDimensions();
        Set<Integer> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        Set<Integer> this$measures = this.getMeasures();
        Set<Integer> other$measures = other.getMeasures();
        if (this$measures == null ? other$measures != null : !((Object)this$measures).equals(other$measures)) {
            return false;
        }
        Set<Integer> this$columns = this.getColumns();
        Set<Integer> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Set<String> this$computedColumns = this.getComputedColumns();
        Set<String> other$computedColumns = other.getComputedColumns();
        if (this$computedColumns == null ? other$computedColumns != null : !((Object)this$computedColumns).equals(other$computedColumns)) {
            return false;
        }
        Map<NDataModel.Measure, NDataModel.Measure> this$updateIdMeasureMap = this.getUpdateIdMeasureMap();
        Map<NDataModel.Measure, NDataModel.Measure> other$updateIdMeasureMap = other.getUpdateIdMeasureMap();
        if (this$updateIdMeasureMap == null ? other$updateIdMeasureMap != null : !((Object)this$updateIdMeasureMap).equals(other$updateIdMeasureMap)) {
            return false;
        }
        Map<Integer, NDataModel.Measure> this$updateMeasureMap = this.getUpdateMeasureMap();
        Map<Integer, NDataModel.Measure> other$updateMeasureMap = other.getUpdateMeasureMap();
        if (this$updateMeasureMap == null ? other$updateMeasureMap != null : !((Object)this$updateMeasureMap).equals(other$updateMeasureMap)) {
            return false;
        }
        Predicate<SchemaNode> this$deletableIndexPredicate = this.getDeletableIndexPredicate();
        Predicate<SchemaNode> other$deletableIndexPredicate = other.getDeletableIndexPredicate();
        return !(this$deletableIndexPredicate == null ? other$deletableIndexPredicate != null : !this$deletableIndexPredicate.equals(other$deletableIndexPredicate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AffectedModelContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<SchemaNode> $updatedNodes = this.getUpdatedNodes();
        result = result * 59 + ($updatedNodes == null ? 43 : ((Object)$updatedNodes).hashCode());
        Set<SchemaNode> $shouldDeleteNodes = this.getShouldDeleteNodes();
        result = result * 59 + ($shouldDeleteNodes == null ? 43 : ((Object)$shouldDeleteNodes).hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        String $modelAlias = this.getModelAlias();
        result = result * 59 + ($modelAlias == null ? 43 : $modelAlias.hashCode());
        result = result * 59 + (this.isBroken() ? 79 : 97);
        Set<Long> $updatedLayouts = this.getUpdatedLayouts();
        result = result * 59 + ($updatedLayouts == null ? 43 : ((Object)$updatedLayouts).hashCode());
        Set<Long> $shouldDeleteLayouts = this.getShouldDeleteLayouts();
        result = result * 59 + ($shouldDeleteLayouts == null ? 43 : ((Object)$shouldDeleteLayouts).hashCode());
        Set<Long> $addLayouts = this.getAddLayouts();
        result = result * 59 + ($addLayouts == null ? 43 : ((Object)$addLayouts).hashCode());
        Set<Integer> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        Set<Integer> $measures = this.getMeasures();
        result = result * 59 + ($measures == null ? 43 : ((Object)$measures).hashCode());
        Set<Integer> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Set<String> $computedColumns = this.getComputedColumns();
        result = result * 59 + ($computedColumns == null ? 43 : ((Object)$computedColumns).hashCode());
        Map<NDataModel.Measure, NDataModel.Measure> $updateIdMeasureMap = this.getUpdateIdMeasureMap();
        result = result * 59 + ($updateIdMeasureMap == null ? 43 : ((Object)$updateIdMeasureMap).hashCode());
        Map<Integer, NDataModel.Measure> $updateMeasureMap = this.getUpdateMeasureMap();
        result = result * 59 + ($updateMeasureMap == null ? 43 : ((Object)$updateMeasureMap).hashCode());
        Predicate<SchemaNode> $deletableIndexPredicate = this.getDeletableIndexPredicate();
        result = result * 59 + ($deletableIndexPredicate == null ? 43 : $deletableIndexPredicate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AffectedModelContext(updatedNodes=" + this.getUpdatedNodes() + ", shouldDeleteNodes=" + this.getShouldDeleteNodes() + ", project=" + this.getProject() + ", modelId=" + this.getModelId() + ", modelAlias=" + this.getModelAlias() + ", isBroken=" + this.isBroken() + ", updatedLayouts=" + this.getUpdatedLayouts() + ", shouldDeleteLayouts=" + this.getShouldDeleteLayouts() + ", addLayouts=" + this.getAddLayouts() + ", dimensions=" + this.getDimensions() + ", measures=" + this.getMeasures() + ", columns=" + this.getColumns() + ", computedColumns=" + this.getComputedColumns() + ", updateIdMeasureMap=" + this.getUpdateIdMeasureMap() + ", updateMeasureMap=" + this.getUpdateMeasureMap() + ", deletableIndexPredicate=" + this.getDeletableIndexPredicate() + ")";
    }

    @Generated
    public Set<Long> getUpdatedLayouts() {
        return this.updatedLayouts;
    }

    @Generated
    public Set<Long> getShouldDeleteLayouts() {
        return this.shouldDeleteLayouts;
    }

    @Generated
    public Set<Long> getAddLayouts() {
        return this.addLayouts;
    }
}

