/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.MapUtil;
import org.apache.kylin.guava30.shaded.common.base.MoreObjects;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSortedSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.model.IStorageAware;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class LayoutEntity
implements IStorageAware,
Serializable {
    public static final long TABLE_LAYOUT_INIT_ID = 40000000001L;
    public static final long AGG_LAYOUT_INIT_ID = 19999990001L;
    @JsonBackReference
    private IndexEntity index;
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="col_order")
    private List<Integer> colOrder = Lists.newArrayList();
    @JsonProperty(value="layout_override_indexes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<Integer, String> layoutOverrideIndexes = Maps.newHashMap();
    @JsonProperty(value="shard_by_columns")
    private List<Integer> shardByColumns = Lists.newArrayList();
    @JsonProperty(value="partition_by_columns")
    private List<Integer> partitionByColumns = Lists.newArrayList();
    @JsonProperty(value="sort_by_columns")
    private List<Integer> sortByColumns = Lists.newArrayList();
    @JsonProperty(value="storage_type")
    private int storageType = 20;
    @JsonProperty(value="update_time")
    private long updateTime;
    @JsonProperty(value="manual")
    private boolean isManual = false;
    @JsonProperty(value="auto")
    private boolean isAuto = false;
    @JsonProperty(value="base")
    private boolean isBase = false;
    @JsonProperty(value="draft_version")
    private String draftVersion;
    private boolean isInProposing;
    @JsonProperty(value="index_range")
    private IndexEntity.Range indexRange;
    private ImmutableBiMap<Integer, TblColRef> orderedDimensions;
    private ImmutableBiMap<Integer, NDataModel.Measure> orderedMeasures;
    private ImmutableBiMap<Integer, TblColRef> orderedStreamingDimensions;
    private ImmutableBiMap<Integer, NDataModel.Measure> orderedStreamingMeasures;
    private boolean toBeDeleted = false;

    public ImmutableList<Integer> getDimsIds() {
        ImmutableList.Builder dimsBuilder = ImmutableList.builder();
        for (int colId : this.colOrder) {
            if (colId >= 100000) continue;
            dimsBuilder.add((Object)colId);
        }
        return dimsBuilder.build();
    }

    public ImmutableList<Integer> getMeasureIds() {
        ImmutableList.Builder measureIdBuilder = ImmutableList.builder();
        for (int colId : this.colOrder) {
            if (colId < 100000) continue;
            measureIdBuilder.add((Object)colId);
        }
        return measureIdBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBiMap<Integer, TblColRef> getOrderedDimensions() {
        if (this.orderedDimensions != null) {
            return this.orderedDimensions;
        }
        LayoutEntity layoutEntity = this;
        synchronized (layoutEntity) {
            if (this.orderedDimensions != null) {
                return this.orderedDimensions;
            }
            ImmutableBiMap.Builder dimsBuilder = ImmutableBiMap.builder();
            for (int colId : this.colOrder) {
                if (colId >= 100000) continue;
                dimsBuilder.put((Object)colId, this.index.getEffectiveDimCols().get((Object)colId));
            }
            this.orderedDimensions = dimsBuilder.build();
            return this.orderedDimensions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBiMap<Integer, NDataModel.Measure> getOrderedMeasures() {
        if (this.orderedMeasures != null) {
            return this.orderedMeasures;
        }
        LayoutEntity layoutEntity = this;
        synchronized (layoutEntity) {
            if (this.orderedMeasures != null) {
                return this.orderedMeasures;
            }
            ImmutableBiMap.Builder measureBuilder = ImmutableBiMap.builder();
            for (int colId : this.colOrder) {
                if (colId < 100000) continue;
                measureBuilder.put((Object)colId, this.index.getEffectiveMeasures().get((Object)colId));
            }
            this.orderedMeasures = measureBuilder.build();
            return this.orderedMeasures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBiMap<Integer, TblColRef> getStreamingColumns() {
        if (this.orderedStreamingDimensions != null) {
            return this.orderedStreamingDimensions;
        }
        LayoutEntity layoutEntity = this;
        synchronized (layoutEntity) {
            NDataModel model = this.getModel();
            ImmutableBiMap.Builder dimsBuilder = ImmutableBiMap.builder();
            if (model.isFusionModel()) {
                NDataModel streamingModel = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), model.getProject()).getDataModelDesc(model.getFusionId());
                ImmutableBiMap<Integer, TblColRef> streamingEffectiveCols = streamingModel.getEffectiveCols();
                for (int colId : this.colOrder) {
                    if (colId >= 100000) continue;
                    dimsBuilder.put((Object)colId, streamingEffectiveCols.get((Object)colId));
                }
            }
            this.orderedStreamingDimensions = dimsBuilder.build();
            return this.orderedStreamingDimensions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBiMap<Integer, NDataModel.Measure> getStreamingMeasures() {
        if (this.orderedStreamingMeasures != null) {
            return this.orderedStreamingMeasures;
        }
        LayoutEntity layoutEntity = this;
        synchronized (layoutEntity) {
            NDataModel model = this.getModel();
            ImmutableBiMap.Builder measuresBuilder = ImmutableBiMap.builder();
            if (model.isFusionModel()) {
                NDataModel streamingModel = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), model.getProject()).getDataModelDesc(model.getFusionId());
                ImmutableBiMap<Integer, NDataModel.Measure> streamingEffectiveMeasures = streamingModel.getEffectiveMeasures();
                for (int colId : this.colOrder) {
                    if (colId < 100000) continue;
                    measuresBuilder.put((Object)colId, streamingEffectiveMeasures.get((Object)colId));
                }
            }
            this.orderedStreamingMeasures = measuresBuilder.build();
            return this.orderedStreamingMeasures;
        }
    }

    public String getColIndexType(int colId) {
        return (String)MapUtil.getOrElse(this.layoutOverrideIndexes, (Object)colId, (Object)MapUtil.getOrElse(this.getIndex().getIndexPlan().getIndexPlanOverrideIndexes(), (Object)colId, (Object)"eq"));
    }

    public Integer getDimensionPos(TblColRef tblColRef) {
        return (Integer)this.getOrderedDimensions().inverse().get((Object)tblColRef);
    }

    public List<TblColRef> getColumns() {
        return Lists.newArrayList((Iterable)this.getOrderedDimensions().values());
    }

    public List<String> listBitmapMeasure() {
        ArrayList<String> countDistinct = new ArrayList<String>();
        this.getOrderedMeasures().forEach((a, b) -> {
            if ("bitmap".equals(b.getFunction().getReturnDataType().getName())) {
                countDistinct.add(a.toString());
            }
        });
        return countDistinct;
    }

    public NDataModel getModel() {
        return this.index.getIndexPlan().getModel();
    }

    public void setId(long id) {
        this.checkIsNotCachedAndShared();
        this.id = id;
    }

    public long getIndexId() {
        return this.getId() - this.getId() % 10000L;
    }

    public ImmutableList<Integer> getColOrder() {
        return ImmutableList.copyOf(this.colOrder);
    }

    public boolean equalsCols(LayoutEntity layout) {
        ImmutableSortedSet order1 = ImmutableSortedSet.naturalOrder().addAll(this.getColOrder()).build();
        ImmutableSortedSet order2 = ImmutableSortedSet.naturalOrder().addAll(layout.getColOrder()).build();
        return order1.equals(order2);
    }

    public void setColOrder(List<Integer> l) {
        this.checkIsNotCachedAndShared();
        this.colOrder = l;
    }

    public ImmutableMap<Integer, String> getLayoutOverrideIndexes() {
        return ImmutableMap.copyOf(this.layoutOverrideIndexes);
    }

    public void setLayoutOverrideIndexes(Map<Integer, String> m) {
        this.checkIsNotCachedAndShared();
        this.layoutOverrideIndexes = m;
    }

    public List<Integer> getShardByColumns() {
        return this.isCachedAndShared() ? Lists.newArrayList(this.shardByColumns) : this.shardByColumns;
    }

    public List<TblColRef> getShardByColumnRefs() {
        return this.shardByColumns.stream().map(id -> (TblColRef)this.getOrderedDimensions().get(id)).collect(Collectors.toList());
    }

    public void setShardByColumns(List<Integer> shardByColumns) {
        this.checkIsNotCachedAndShared();
        this.shardByColumns = shardByColumns;
    }

    public List<Integer> getPartitionByColumns() {
        return this.isCachedAndShared() ? Lists.newArrayList(this.partitionByColumns) : this.partitionByColumns;
    }

    public void setPartitionByColumns(List<Integer> partitionByColumns) {
        this.checkIsNotCachedAndShared();
        this.partitionByColumns = partitionByColumns;
    }

    public List<Integer> getSortByColumns() {
        return this.isCachedAndShared() ? Lists.newArrayList(this.sortByColumns) : this.sortByColumns;
    }

    public int getBucketNum() {
        return this.getIndex().getIndexPlan().getLayoutBucketNumMapping().get(this.id);
    }

    public void setSortByColumns(List<Integer> sortByColumns) {
        this.checkIsNotCachedAndShared();
        this.sortByColumns = sortByColumns;
    }

    public void setStorageType(int storageType) {
        this.checkIsNotCachedAndShared();
        this.storageType = storageType;
    }

    public void setIndex(IndexEntity index) {
        this.checkIsNotCachedAndShared();
        this.index = index;
    }

    public void setUpdateTime(long updateTime) {
        this.checkIsNotCachedAndShared();
        this.updateTime = updateTime;
    }

    public void setName(String name) {
        this.checkIsNotCachedAndShared();
        this.name = name;
    }

    public void setOwner(String owner) {
        this.checkIsNotCachedAndShared();
        this.owner = owner;
    }

    public void setManual(boolean manual) {
        this.checkIsNotCachedAndShared();
        this.isManual = manual;
    }

    public void setAuto(boolean auto) {
        this.checkIsNotCachedAndShared();
        this.isAuto = auto;
    }

    public boolean isExpired() {
        return !this.isAuto && !this.isManual;
    }

    public boolean isCachedAndShared() {
        return this.index != null && this.index.isCachedAndShared();
    }

    public void checkIsNotCachedAndShared() {
        if (this.index != null) {
            this.index.checkIsNotCachedAndShared();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("colOrder", (Object)this.getColOrder().toString()).toString();
    }

    public boolean isDraft() {
        return this.draftVersion != null;
    }

    public void publish() {
        this.draftVersion = null;
    }

    public boolean matchDraftVersion(String draftVersion) {
        return this.isDraft() && this.draftVersion.equals(draftVersion);
    }

    public String genUniqueContent() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("colOrder=").append(this.getColOrder().toString());
        sb.append(",sortCols=").append(this.getSortByColumns().toString());
        sb.append(",shardCols=").append(this.getShardByColumns().toString());
        sb.append("}");
        return sb.toString();
    }

    public boolean isBaseIndex() {
        return this.isBase;
    }

    public void initalId(boolean isAgg) {
        this.id = isAgg ? 19999990001L : 40000000001L;
    }

    public boolean notAssignId() {
        return this.id == 19999990001L || this.id == 40000000001L;
    }

    public void setBase(boolean base) {
        this.checkIsNotCachedAndShared();
        this.isBase = base;
        if (!base) {
            this.setAuto(true);
        }
    }

    @Generated
    public IndexEntity getIndex() {
        return this.index;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Override
    @Generated
    public int getStorageType() {
        return this.storageType;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public boolean isManual() {
        return this.isManual;
    }

    @Generated
    public boolean isAuto() {
        return this.isAuto;
    }

    @Generated
    public boolean isBase() {
        return this.isBase;
    }

    @Generated
    public String getDraftVersion() {
        return this.draftVersion;
    }

    @Generated
    public boolean isInProposing() {
        return this.isInProposing;
    }

    @Generated
    public IndexEntity.Range getIndexRange() {
        return this.indexRange;
    }

    @Generated
    public ImmutableBiMap<Integer, TblColRef> getOrderedStreamingDimensions() {
        return this.orderedStreamingDimensions;
    }

    @Generated
    public ImmutableBiMap<Integer, NDataModel.Measure> getOrderedStreamingMeasures() {
        return this.orderedStreamingMeasures;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayoutEntity)) {
            return false;
        }
        LayoutEntity other = (LayoutEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableList<Integer> this$colOrder = this.getColOrder();
        ImmutableList<Integer> other$colOrder = other.getColOrder();
        if (this$colOrder == null ? other$colOrder != null : !this$colOrder.equals(other$colOrder)) {
            return false;
        }
        ImmutableMap<Integer, String> this$layoutOverrideIndexes = this.getLayoutOverrideIndexes();
        ImmutableMap<Integer, String> other$layoutOverrideIndexes = other.getLayoutOverrideIndexes();
        if (this$layoutOverrideIndexes == null ? other$layoutOverrideIndexes != null : !this$layoutOverrideIndexes.equals(other$layoutOverrideIndexes)) {
            return false;
        }
        List<Integer> this$shardByColumns = this.getShardByColumns();
        List<Integer> other$shardByColumns = other.getShardByColumns();
        if (this$shardByColumns == null ? other$shardByColumns != null : !((Object)this$shardByColumns).equals(other$shardByColumns)) {
            return false;
        }
        List<Integer> this$sortByColumns = this.getSortByColumns();
        List<Integer> other$sortByColumns = other.getSortByColumns();
        if (this$sortByColumns == null ? other$sortByColumns != null : !((Object)this$sortByColumns).equals(other$sortByColumns)) {
            return false;
        }
        return this.getStorageType() == other.getStorageType();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LayoutEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList<Integer> $colOrder = this.getColOrder();
        result = result * 59 + ($colOrder == null ? 43 : $colOrder.hashCode());
        ImmutableMap<Integer, String> $layoutOverrideIndexes = this.getLayoutOverrideIndexes();
        result = result * 59 + ($layoutOverrideIndexes == null ? 43 : $layoutOverrideIndexes.hashCode());
        List<Integer> $shardByColumns = this.getShardByColumns();
        result = result * 59 + ($shardByColumns == null ? 43 : ((Object)$shardByColumns).hashCode());
        List<Integer> $sortByColumns = this.getSortByColumns();
        result = result * 59 + ($sortByColumns == null ? 43 : ((Object)$sortByColumns).hashCode());
        result = result * 59 + this.getStorageType();
        return result;
    }

    @Generated
    public void setDraftVersion(String draftVersion) {
        this.draftVersion = draftVersion;
    }

    @Generated
    public void setInProposing(boolean isInProposing) {
        this.isInProposing = isInProposing;
    }

    @Generated
    public void setIndexRange(IndexEntity.Range indexRange) {
        this.indexRange = indexRange;
    }

    @Generated
    public void setToBeDeleted(boolean toBeDeleted) {
        this.toBeDeleted = toBeDeleted;
    }

    @Generated
    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }
}

