/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.guava30.shaded.common.collect.ComparisonChain;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;

public class OrderedSet<T>
implements Set<T> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private final Set<T> set = Sets.newHashSet();
    private final Map<T, Integer> insertingMap = Maps.newHashMap();

    @Override
    public boolean add(T element) {
        boolean result = this.set.add(element);
        if (result) {
            this.insertingMap.putIfAbsent(element, this.set.size());
        }
        return result;
    }

    @Override
    public boolean remove(Object element) {
        boolean result = this.set.remove(element);
        if (result) {
            this.insertingMap.remove(element);
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T element : c) {
            this.add(element);
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object element : c) {
            this.remove(element);
        }
        return false;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.insertingMap.clear();
    }

    @Override
    public Iterator<T> iterator() {
        int capacity = this.capacity();
        return this.set.stream().sorted((cuboid1, cuboid2) -> ComparisonChain.start().compare(this.hash(cuboid1, capacity), this.hash(cuboid2, capacity)).compare((Comparable)this.insertingMap.get(cuboid1), (Comparable)this.insertingMap.get(cuboid2)).result()).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    public List<T> getSortedList() {
        ArrayList result = Lists.newArrayList();
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        int capacityForNewHashSet = this.capacityForNewHashSet();
        return result.stream().sorted((cuboid1, cuboid2) -> ComparisonChain.start().compare(this.hash(cuboid1, capacityForNewHashSet), this.hash(cuboid2, capacityForNewHashSet)).result()).collect(Collectors.toList());
    }

    private int hash(T cuboidDecimal, int capacity) {
        int hashSetTableSize = this.hashSetTableSize(capacity);
        int hashcode = cuboidDecimal == null ? 0 : cuboidDecimal.hashCode();
        return hashSetTableSize - 1 & (hashcode ^ hashcode >>> 16);
    }

    private int capacity() {
        return Math.max((int)((float)this.size() / 0.75f), 16);
    }

    private int capacityForNewHashSet() {
        return Math.max((int)((float)this.size() / 0.75f) + 1, 16);
    }

    private int hashSetTableSize(int capacity) {
        int n = capacity - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }
}

