/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.util.NoSuchElementException;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainKey;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPartitionTimestampCursor
implements PartitionTimestampCursor {
    protected final AbstractPageMemoryMvPartitionStorage storage;
    private final VersionChainTree versionChainTree;
    @Nullable
    private Cursor<ReadResult> cursor;
    private boolean iterationExhausted;
    @Nullable
    private ReadResult nextRead;
    @Nullable
    private RowId currentRowId;

    AbstractPartitionTimestampCursor(AbstractPageMemoryMvPartitionStorage storage) {
        this.storage = storage;
        this.versionChainTree = storage.renewableState.versionChainTree();
    }

    public boolean hasNext() {
        return this.storage.busy(() -> {
            RowId rowId;
            ReadResult result;
            this.storage.throwExceptionIfStorageNotInRunnableState();
            if (this.nextRead != null) {
                return true;
            }
            if (this.iterationExhausted) {
                return false;
            }
            this.createVersionChainCursorIfMissing();
            this.currentRowId = null;
            do {
                if (!this.cursor.hasNext()) {
                    this.iterationExhausted = true;
                    return false;
                }
                result = (ReadResult)this.cursor.next();
                rowId = result.rowId();
            } while (result.isEmpty() && !result.isWriteIntent());
            this.nextRead = result;
            this.currentRowId = rowId;
            return true;
        });
    }

    public final ReadResult next() {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfStorageNotInRunnableState();
            if (!this.hasNext()) {
                throw new NoSuchElementException("The cursor is exhausted: " + this.storage.createStorageInfo());
            }
            assert (this.nextRead != null);
            ReadResult res = this.nextRead;
            this.nextRead = null;
            return res;
        });
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    @Nullable
    public BinaryRow committed(HybridTimestamp timestamp) {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfStorageNotInRunnableState();
            if (this.currentRowId == null) {
                throw new IllegalStateException("RowId missing: " + this.storage.createStorageInfo());
            }
            ReadResult result = this.storage.findVersionChain(this.currentRowId, versionChain -> versionChain == null ? ReadResult.empty((RowId)this.currentRowId) : this.storage.findRowVersionByTimestamp((VersionChain)versionChain, timestamp));
            if (result.isEmpty()) {
                return null;
            }
            return result.binaryRow();
        });
    }

    abstract ReadResult findRowVersion(VersionChain var1);

    void createVersionChainCursorIfMissing() {
        if (this.cursor != null) {
            return;
        }
        try {
            this.cursor = this.versionChainTree.find(null, null, (BplusTree.TreeRowMapClosure)new BplusTree.TreeRowMapClosure<VersionChainKey, VersionChain, ReadResult>(){

                public ReadResult map(VersionChain treeRow) {
                    return AbstractPartitionTimestampCursor.this.findRowVersion(treeRow);
                }
            }, null);
        }
        catch (IgniteInternalCheckedException e) {
            StorageUtils.throwStorageExceptionIfItCause((IgniteInternalCheckedException)e);
            throw new StorageException("Find failed: " + this.storage.createStorageInfo(), (Throwable)e);
        }
    }
}

