/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageBuilder;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class HandshakeStartMessageImpl
implements HandshakeStartMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final UUID serverClusterId;
    @IgniteToStringInclude
    private final ClusterNodeMessage serverNode;

    private HandshakeStartMessageImpl(UUID serverClusterId, ClusterNodeMessage serverNode) {
        this.serverClusterId = serverClusterId;
        this.serverNode = serverNode;
    }

    @Override
    public UUID serverClusterId() {
        return this.serverClusterId;
    }

    @Override
    public ClusterNodeMessage serverNode() {
        return this.serverNode;
    }

    public MessageSerializer serializer() {
        return HandshakeStartMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(HandshakeStartMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HandshakeStartMessageImpl otherMessage = (HandshakeStartMessageImpl)other;
        return Objects.equals(this.serverClusterId, otherMessage.serverClusterId) && Objects.equals(this.serverNode, otherMessage.serverNode);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.serverClusterId, this.serverNode);
        return result;
    }

    public HandshakeStartMessageImpl clone() {
        try {
            return (HandshakeStartMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HandshakeStartMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.serverNode != null) {
            this.serverNode.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.serverNode != null) {
            this.serverNode.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements HandshakeStartMessageBuilder {
        private UUID serverClusterId;
        private ClusterNodeMessage serverNode;

        private Builder() {
        }

        @Override
        public HandshakeStartMessageBuilder serverClusterId(UUID serverClusterId) {
            this.serverClusterId = serverClusterId;
            return this;
        }

        @Override
        public HandshakeStartMessageBuilder serverNode(ClusterNodeMessage serverNode) {
            Objects.requireNonNull(serverNode, "serverNode is not marked @Nullable");
            this.serverNode = serverNode;
            return this;
        }

        @Override
        public UUID serverClusterId() {
            return this.serverClusterId;
        }

        @Override
        public ClusterNodeMessage serverNode() {
            return this.serverNode;
        }

        @Override
        public HandshakeStartMessage build() {
            return new HandshakeStartMessageImpl(this.serverClusterId, Objects.requireNonNull(this.serverNode, "serverNode is not marked @Nullable"));
        }
    }
}

