/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheCreateCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Argument(description="Path to the Spring XML configuration that contains 'org.apache.ignite.configuration.CacheConfiguration' beans to create caches from", example="springXmlConfigPath")
    private String springxmlconfig;
    @Argument(description="Optional flag to skip existing caches", optional=true)
    private boolean skipExisting;
    private String fileContent;

    private void readFile() {
        if (!new File(this.springxmlconfig).exists()) {
            throw new IgniteException("Failed to create caches. Spring XML configuration file not found [file=" + this.springxmlconfig + "]");
        }
        try {
            this.fileContent = U.readFileToString(this.springxmlconfig, "UTF-8");
        }
        catch (IOException e) {
            throw new IgniteException("Failed to create caches. Failed to read Spring XML configuration file [file=" + this.springxmlconfig + "]", e);
        }
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.springxmlconfig);
        U.writeString(out, this.fileContent);
        out.writeBoolean(this.skipExisting);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.springxmlconfig = U.readString(in);
        this.fileContent = U.readString(in);
        this.skipExisting = in.readBoolean();
    }

    public String springxmlconfig() {
        return this.springxmlconfig;
    }

    public void springxmlconfig(String springxmlconfig) {
        this.springxmlconfig = springxmlconfig;
        this.readFile();
    }

    public boolean skipExisting() {
        return this.skipExisting;
    }

    public void skipExisting(boolean skipExisting) {
        this.skipExisting = skipExisting;
    }

    public void fileContent(String fileContent) {
        this.fileContent = fileContent;
    }

    public String fileContent() {
        return this.fileContent;
    }
}

