/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.security.AccessControlException;
import java.util.UUID;
import org.apache.ignite.internal.processors.security.AbstractSecurityAwareExternalizable;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;
import org.apache.ignite.lang.IgniteBiPredicate;

public class SecurityAwareBiPredicate<E1, E2>
extends AbstractSecurityAwareExternalizable<IgniteBiPredicate<E1, E2>>
implements IgniteBiPredicate<E1, E2> {
    private static final long serialVersionUID = 0L;

    public SecurityAwareBiPredicate() {
    }

    public SecurityAwareBiPredicate(UUID subjectId, IgniteBiPredicate<E1, E2> original) {
        super(subjectId, original);
    }

    @Override
    public boolean apply(E1 e1, E2 e2) {
        IgniteSecurity security = this.ignite.context().security();
        OperationSecurityContext c = security.withContext(this.subjectId);
        try {
            boolean bl;
            IgniteSandbox sandbox = security.sandbox();
            boolean bl2 = bl = sandbox.enabled() ? sandbox.execute(() -> ((IgniteBiPredicate)this.original).apply(e1, e2)).booleanValue() : ((IgniteBiPredicate)this.original).apply(e1, e2);
            if (c != null) {
                c.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AccessControlException e) {
                this.logAccessDeniedMessage(e);
                throw e;
            }
        }
    }
}

