/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="checktokenmetadata", description="compares the Gossip endpointState and TokenMetadata cache; printing any mismatches found")
public class CheckTokenMetadata
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        StringBuilder sb = new StringBuilder();
        Map<String, List<String>> mismatches = probe.compareGossipAndTokenMetadata();
        for (Map.Entry<String, List<String>> e : mismatches.entrySet()) {
            sb.append("Mismatch on : ").append(e.getKey()).append("\n  Gossip tokens: ").append(e.getValue().get(0)).append("\n  TokenMetadata: ").append(e.getValue().get(1)).append('\n');
        }
        System.out.println(sb);
    }
}

