/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.sstable.SequenceBasedSSTableId;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyspaceMigrator41 {
    private static final Logger logger = LoggerFactory.getLogger(SystemKeyspaceMigrator41.class);

    private SystemKeyspaceMigrator41() {
    }

    public static void migrate() {
        SystemKeyspaceMigrator41.migratePeers();
        SystemKeyspaceMigrator41.migratePeerEvents();
        SystemKeyspaceMigrator41.migrateTransferredRanges();
        SystemKeyspaceMigrator41.migrateAvailableRanges();
        SystemKeyspaceMigrator41.migrateSSTableActivity();
    }

    @VisibleForTesting
    static void migratePeers() {
        SystemKeyspaceMigrator41.migrateTable(false, "peers", "peers_v2", new String[]{"peer", "peer_port", "data_center", "host_id", "preferred_ip", "preferred_port", "rack", "release_version", "native_address", "native_port", "schema_version", "tokens"}, row -> Collections.singletonList(new Object[]{row.has("peer") ? row.getInetAddress("peer") : null, DatabaseDescriptor.getStoragePort(), row.has("data_center") ? row.getString("data_center") : null, row.has("host_id") ? row.getUUID("host_id") : null, row.has("preferred_ip") ? row.getInetAddress("preferred_ip") : null, DatabaseDescriptor.getStoragePort(), row.has("rack") ? row.getString("rack") : null, row.has("release_version") ? row.getString("release_version") : null, row.has("rpc_address") ? row.getInetAddress("rpc_address") : null, DatabaseDescriptor.getNativeTransportPort(), row.has("schema_version") ? row.getUUID("schema_version") : null, row.has("tokens") ? row.getSet("tokens", UTF8Type.instance) : null}));
    }

    @VisibleForTesting
    static void migratePeerEvents() {
        SystemKeyspaceMigrator41.migrateTable(false, "peer_events", "peer_events_v2", new String[]{"peer", "peer_port", "hints_dropped"}, row -> Collections.singletonList(new Object[]{row.has("peer") ? row.getInetAddress("peer") : null, DatabaseDescriptor.getStoragePort(), row.has("hints_dropped") ? row.getMap("hints_dropped", TimeUUIDType.instance, Int32Type.instance) : null}));
    }

    @VisibleForTesting
    static void migrateTransferredRanges() {
        SystemKeyspaceMigrator41.migrateTable(false, "transferred_ranges", "transferred_ranges_v2", new String[]{"operation", "peer", "peer_port", "keyspace_name", "ranges"}, row -> Collections.singletonList(new Object[]{row.has("operation") ? row.getString("operation") : null, row.has("peer") ? row.getInetAddress("peer") : null, DatabaseDescriptor.getStoragePort(), row.has("keyspace_name") ? row.getString("keyspace_name") : null, row.has("ranges") ? row.getSet("ranges", BytesType.instance) : null}));
    }

    @VisibleForTesting
    static void migrateAvailableRanges() {
        SystemKeyspaceMigrator41.migrateTable(false, "available_ranges", "available_ranges_v2", new String[]{"keyspace_name", "full_ranges", "transient_ranges"}, row -> Collections.singletonList(new Object[]{row.getString("keyspace_name"), Optional.ofNullable(row.getSet("ranges", BytesType.instance)).orElse(Collections.emptySet()), Collections.emptySet()}));
    }

    @VisibleForTesting
    static void migrateSSTableActivity() {
        String prevVersionString = FBUtilities.getPreviousReleaseVersionString();
        CassandraVersion prevVersion = prevVersionString != null ? new CassandraVersion(prevVersionString) : CassandraVersion.NULL_VERSION;
        SystemKeyspaceMigrator41.migrateTable(CassandraVersion.CASSANDRA_4_1.compareTo(prevVersion) > 0, "sstable_activity", "sstable_activity_v2", new String[]{"keyspace_name", "table_name", "id", "rate_120m", "rate_15m"}, row -> Collections.singletonList(new Object[]{row.getString("keyspace_name"), row.getString("columnfamily_name"), new SequenceBasedSSTableId(row.getInt("generation")).toString(), row.has("rate_120m") ? Double.valueOf(row.getDouble("rate_120m")) : null, row.has("rate_15m") ? Double.valueOf(row.getDouble("rate_15m")) : null}));
    }

    @VisibleForTesting
    static void migrateTable(boolean truncateIfExists, String oldName, String newName, String[] columns, Function<UntypedResultSet.Row, Collection<Object[]>> transformation) {
        ColumnFamilyStore newTable = Keyspace.open("system").getColumnFamilyStore(newName);
        if (!newTable.isEmpty() && !truncateIfExists) {
            return;
        }
        if (truncateIfExists) {
            newTable.truncateBlockingWithoutSnapshot();
        }
        logger.info("{} table was empty, migrating legacy {}, if this fails you should fix the issue and then truncate {} to have it try again.", new Object[]{newName, oldName, newName});
        String query = String.format("SELECT * FROM %s.%s", "system", oldName);
        String insert = String.format("INSERT INTO %s.%s (%s) VALUES (%s)", "system", newName, StringUtils.join((Object[])columns, (String)", "), StringUtils.repeat((String)"?", (String)", ", (int)columns.length));
        UntypedResultSet rows = QueryProcessor.executeInternal(query, new Object[0]);
        int transferred = 0;
        logger.info("Migrating rows from legacy {} to {}", (Object)oldName, (Object)newName);
        for (UntypedResultSet.Row row : rows) {
            logger.debug("Transferring row {}", (Object)transferred);
            for (Object[] newRow : transformation.apply(row)) {
                QueryProcessor.executeInternal(insert, newRow);
            }
            ++transferred;
        }
        logger.info("Migrated {} rows from legacy {} to {}", new Object[]{transferred, oldName, newName});
    }
}

