/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import java.lang.reflect.InvocationTargetException;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.ProgressMonitorAdapter;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class SearchFieldsProgressDialog
implements IRunnableWithProgress {
    private static final Class<?> PKG = SearchFieldsProgressDialog.class;
    private final IVariables variables;
    private TransformMeta transformMeta;
    private boolean before;
    private PipelineMeta pipelineMeta;
    private IRowMeta fields;

    public SearchFieldsProgressDialog(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, boolean before) {
        this.variables = variables;
        this.pipelineMeta = pipelineMeta;
        this.transformMeta = transformMeta;
        this.before = before;
        this.fields = null;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int size = this.pipelineMeta.findPreviousTransforms(this.transformMeta, false).size();
        try {
            if (this.before) {
                monitor.beginTask(BaseMessages.getString(PKG, (String)"SearchFieldsProgressDialog.Dialog.SearchInputFields.Message", (String[])new String[0]), size);
                this.fields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta, (IProgressMonitor)new ProgressMonitorAdapter(monitor));
            } else {
                monitor.beginTask(BaseMessages.getString(PKG, (String)"SearchFieldsProgressDialog.Dialog.SearchOutputFields.Message", (String[])new String[0]), size);
                this.fields = this.pipelineMeta.getTransformFields(this.variables, this.transformMeta, (IProgressMonitor)new ProgressMonitorAdapter(monitor));
            }
        }
        catch (HopTransformException kse) {
            throw new InvocationTargetException(kse, BaseMessages.getString(PKG, (String)"SearchFieldsProgressDialog.Log.UnableToGetFields", (String[])new String[]{this.transformMeta.toString(), kse.getMessage()}));
        }
        monitor.done();
    }

    public boolean isBefore() {
        return this.before;
    }

    public void setBefore(boolean before) {
        this.before = before;
    }

    public IRowMeta getFields() {
        return this.fields;
    }

    public void setFields(IRowMeta fields) {
        this.fields = fields;
    }

    public TransformMeta getTransformMeta() {
        return this.transformMeta;
    }

    public void setTransformMeta(TransformMeta transformMeta) {
        this.transformMeta = transformMeta;
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public void setPipelineMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
    }
}

