/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.Closeable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.filesystem.FileMergingCheckpointStateOutputStream;

public interface FileMergingSnapshotManager
extends Closeable {
    public void initFileSystem(FileSystem var1, Path var2, Path var3, Path var4, int var5) throws IllegalArgumentException;

    public void registerSubtaskForSharedStates(SubtaskKey var1);

    public FileMergingCheckpointStateOutputStream createCheckpointStateOutputStream(SubtaskKey var1, long var2, CheckpointedStateScope var4);

    public Path getManagedDir(SubtaskKey var1, CheckpointedStateScope var2);

    public static final class SubtaskKey {
        final String operatorIDString;
        final int subtaskIndex;
        final int parallelism;
        final int hashCode;

        public SubtaskKey(OperatorID operatorID, TaskInfo taskInfo) {
            this(operatorID.toHexString(), taskInfo.getIndexOfThisSubtask(), taskInfo.getNumberOfParallelSubtasks());
        }

        @VisibleForTesting
        public SubtaskKey(String operatorIDString, int subtaskIndex, int parallelism) {
            this.operatorIDString = operatorIDString;
            this.subtaskIndex = subtaskIndex;
            this.parallelism = parallelism;
            int hash = operatorIDString.hashCode();
            hash = 31 * hash + subtaskIndex;
            this.hashCode = hash = 31 * hash + parallelism;
        }

        public String getManagedDirName() {
            return String.format("%s_%d_%d_", this.operatorIDString, this.subtaskIndex, this.parallelism).replaceAll("[^a-zA-Z0-9\\-]", "_");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubtaskKey that = (SubtaskKey)o;
            return this.hashCode == that.hashCode && this.subtaskIndex == that.subtaskIndex && this.parallelism == that.parallelism && this.operatorIDString.equals(that.operatorIDString);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return String.format("%s(%d/%d)", this.operatorIDString, this.subtaskIndex, this.parallelism);
        }
    }
}

