/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.LanguageModelChatData;
import org.apache.hop.pipeline.transforms.languagemodelchat.LanguageModelChatMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.LanguageModel;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.LanguageModelFacade;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.i18nUtil;

public class LanguageModelChat
extends BaseTransform<LanguageModelChatMeta, LanguageModelChatData> {
    public static final int OVER_ALLOCATE_SIZE = 10;
    private static final Class<?> PKG = LanguageModelChat.class;
    public static final String CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD = "LanguageModelChat.Exception.CouldnotFindField";
    public static final String CONST_MODEL_TYPE = "model_type";
    private Map<LanguageModel, LanguageModelFacade> facadeMap = new ConcurrentHashMap<LanguageModel, LanguageModelFacade>();
    private int parallelism = 1;
    private ForkJoinPool executor;
    private final int cores = Runtime.getRuntime().availableProcessors();
    private final AtomicInteger jobs = new AtomicInteger(0);
    private final int maxJobs = this.cores * 100;
    private final Object lock = new Object();

    public LanguageModelChat(TransformMeta transformMeta, LanguageModelChatMeta meta, LanguageModelChatData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        Object object = this.lock;
        synchronized (object) {
            while (this.jobs.get() > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.executor != null) {
            try {
                while (this.executor.hasQueuedSubmissions() || this.executor.getActiveThreadCount() > 0) {
                    TimeUnit.SECONDS.sleep(5L);
                }
            }
            catch (InterruptedException e) {
                this.logError(e.getMessage(), e);
            }
        }
        this.facadeMap.clear();
        this.setOutputDone();
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.finish();
            return false;
        }
        if (this.first) {
            int parallelism;
            this.first = false;
            ((LanguageModelChatData)this.data).previousRowMeta = this.getInputRowMeta().clone();
            ((LanguageModelChatData)this.data).nrPrevFields = ((LanguageModelChatData)this.data).previousRowMeta.size();
            ((LanguageModelChatData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((LanguageModelChatMeta)this.meta).getFields(((LanguageModelChatData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            this.facadeMap.put(new LanguageModel((LanguageModelChatMeta)this.meta), new LanguageModelFacade(this.variables, (LanguageModelChatMeta)this.meta));
            int n = parallelism = ((LanguageModelChatMeta)this.meta).getParallelism() <= 0 ? Runtime.getRuntime().availableProcessors() : ((LanguageModelChatMeta)this.meta).getParallelism();
            if (parallelism != 0 && this.parallelism != parallelism || this.executor == null) {
                if (this.executor != null) {
                    this.executor.shutdownNow();
                }
                this.executor = (ForkJoinPool)Executors.newWorkStealingPool(parallelism);
            }
            if (Utils.isEmpty((CharSequence)((LanguageModelChatMeta)this.meta).getInputField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"LanguageModelChat.Error.InputFieldMissing", (String[])new String[0]));
            }
            this.cacheIndexPositions();
        }
        try {
            this.process(r);
            if (this.isRowLevel()) {
                this.logRowlevel(i18nUtil.i18n("LanguageModelChat.LineNumber", this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)));
            }
        }
        catch (Exception e) {
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                this.logError(i18nUtil.i18n("LanguageModelChat.ErrorInTransformRunning") + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            String errorMessage = e.toString();
            this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((LanguageModelChatMeta)this.meta).getInputField(), "LanguageModelChat001");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Object[] inputRow) {
        String message = StringUtils.trim((String)((String)inputRow[((LanguageModelChatData)this.data).indexOfInputField]));
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.jobs.get() > this.maxJobs) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ForkJoinPool exec = ((LanguageModelChatMeta)this.meta).getParallelism() == 0 ? ForkJoinPool.commonPool() : this.executor;
        exec.submit(() -> {
            try {
                this.processSync(inputRow, message);
                this.jobs.decrementAndGet();
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            catch (Exception e) {
                try {
                    this.processError(inputRow, e);
                }
                catch (HopTransformException ex) {
                    this.logError(e.getMessage(), e);
                    this.logError(ex.getMessage(), ex);
                }
            }
        });
        this.jobs.incrementAndGet();
    }

    private void processError(Object[] inputRow, Exception e) throws HopTransformException {
        this.logError(e.getMessage(), e);
        int newFields = 8;
        Object[] outputRow = new Object[inputRow.length + newFields + 10];
        System.arraycopy(inputRow, 0, outputRow, 0, inputRow.length);
        LanguageModel model = new LanguageModel((LanguageModelChatMeta)this.meta);
        outputRow[((LanguageModelChatData)this.data).indexOfModelType] = model.getType().code();
        outputRow[((LanguageModelChatData)this.data).indexOfModelName] = model.getName();
        outputRow[((LanguageModelChatData)this.data).indexOfFinishReason] = "error";
        outputRow[((LanguageModelChatData)this.data).indexOfInputTokenCount] = null;
        outputRow[((LanguageModelChatData)this.data).indexOfOutputTokenCount] = null;
        outputRow[((LanguageModelChatData)this.data).indexOfTotalTokenCount] = null;
        outputRow[((LanguageModelChatData)this.data).indexOfInferenceTime] = null;
        outputRow[((LanguageModelChatData)this.data).indexOfOutput] = ExceptionUtils.getRootCauseMessage((Throwable)e);
        this.putRow(((LanguageModelChatData)this.data).outputRowMeta, outputRow);
    }

    private void processSync(Object[] inputRow, String message) throws HopTransformException, HopValueException {
        Long inputTokenCount = null;
        Long outputTokenCount = null;
        Long totalTokenCount = null;
        Long inferenceTime = null;
        String finishReason = null;
        String output = null;
        LanguageModel model = new LanguageModel((LanguageModelChatMeta)this.meta);
        LanguageModelFacade facade = this.facadeMap.get(model);
        List<ChatMessage> messageList = facade.inputToChatMessages(message);
        if (((LanguageModelChatMeta)this.meta).isMock()) {
            inputTokenCount = -1L;
            outputTokenCount = -1L;
            totalTokenCount = -1L;
            inferenceTime = -1L;
            finishReason = "MOCK";
            output = ((LanguageModelChatMeta)this.meta).isOutputChatJson() ? facade.messagesToOutput(messageList, ((LanguageModelChatMeta)this.meta).getMockOutputValue()) : ((LanguageModelChatMeta)this.meta).getMockOutputValue();
        } else {
            Instant inferenceStart = Instant.now();
            try {
                Response<AiMessage> ai = facade.generate(messageList);
                inferenceTime = Duration.between(inferenceStart, Instant.now()).toMillis();
                inputTokenCount = ai.tokenUsage() == null || ai.tokenUsage().inputTokenCount() == null ? null : Long.valueOf(ai.tokenUsage().inputTokenCount().longValue());
                outputTokenCount = ai.tokenUsage() == null || ai.tokenUsage().outputTokenCount() == null ? null : Long.valueOf(ai.tokenUsage().outputTokenCount().longValue());
                totalTokenCount = ai.tokenUsage() == null || ai.tokenUsage().totalTokenCount() == null ? null : Long.valueOf(ai.tokenUsage().totalTokenCount().longValue());
                String string = finishReason = ai.finishReason() == null ? null : ai.finishReason().name();
                output = ((LanguageModelChatMeta)this.meta).isOutputChatJson() ? facade.messagesToOutput(messageList, ((AiMessage)ai.content()).text()) : ((AiMessage)ai.content()).text();
            }
            catch (Exception e) {
                inferenceTime = Duration.between(inferenceStart, Instant.now()).toMillis();
                finishReason = "ERROR";
                output = e.getMessage();
            }
        }
        int newFields = 8;
        Object[] outputRow = new Object[inputRow.length + newFields + 10];
        System.arraycopy(inputRow, 0, outputRow, 0, inputRow.length);
        outputRow[((LanguageModelChatData)this.data).indexOfIdentifier] = StringUtils.isNotBlank((CharSequence)((LanguageModelChatMeta)this.meta).getIdentifierValue()) ? ((LanguageModelChatMeta)this.meta).getIdentifierValue() : model.getName();
        outputRow[((LanguageModelChatData)this.data).indexOfModelType] = model.getType().code();
        outputRow[((LanguageModelChatData)this.data).indexOfModelName] = model.getName();
        outputRow[((LanguageModelChatData)this.data).indexOfFinishReason] = finishReason;
        outputRow[((LanguageModelChatData)this.data).indexOfInputTokenCount] = inputTokenCount;
        outputRow[((LanguageModelChatData)this.data).indexOfOutputTokenCount] = outputTokenCount;
        outputRow[((LanguageModelChatData)this.data).indexOfTotalTokenCount] = totalTokenCount;
        outputRow[((LanguageModelChatData)this.data).indexOfInferenceTime] = inferenceTime;
        outputRow[((LanguageModelChatData)this.data).indexOfOutput] = output;
        this.putRow(((LanguageModelChatData)this.data).outputRowMeta, outputRow);
    }

    private void cacheIndexPositions() throws HopException {
        if (((LanguageModelChatData)this.data).indexOfInputField < 0) {
            ((LanguageModelChatData)this.data).indexOfInputField = ((LanguageModelChatData)this.data).previousRowMeta.indexOfValue(((LanguageModelChatMeta)this.meta).getInputField());
            if (((LanguageModelChatData)this.data).indexOfInputField < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, ((LanguageModelChatMeta)this.meta).getInputField()));
            }
        }
        String outputPrefix = ((LanguageModelChatMeta)this.meta).getOutputFieldNamePrefix();
        if (((LanguageModelChatData)this.data).indexOfIdentifier < 0) {
            ((LanguageModelChatData)this.data).indexOfIdentifier = ((LanguageModelChatData)this.data).outputRowMeta.indexOfValue(outputPrefix + "identifier");
            if (((LanguageModelChatData)this.data).indexOfIdentifier < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, CONST_MODEL_TYPE));
            }
        }
        if (((LanguageModelChatData)this.data).indexOfModelType < 0) {
            ((LanguageModelChatData)this.data).indexOfModelType = ((LanguageModelChatData)this.data).outputRowMeta.indexOfValue(outputPrefix + CONST_MODEL_TYPE);
            if (((LanguageModelChatData)this.data).indexOfModelType < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, CONST_MODEL_TYPE));
            }
        }
        if (((LanguageModelChatData)this.data).indexOfModelName < 0) {
            ((LanguageModelChatData)this.data).indexOfModelName = ((LanguageModelChatData)this.data).outputRowMeta.indexOfValue(outputPrefix + "model_name");
            if (((LanguageModelChatData)this.data).indexOfModelName < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, "model_name"));
            }
        }
        if (((LanguageModelChatData)this.data).indexOfFinishReason < 0) {
            ((LanguageModelChatData)this.data).indexOfFinishReason = ((LanguageModelChatData)this.data).outputRowMeta.indexOfValue(outputPrefix + "finish_reason");
            if (((LanguageModelChatData)this.data).indexOfFinishReason < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, "finish_reason"));
            }
        }
        if (((LanguageModelChatData)this.data).indexOfInputTokenCount < 0) {
            ((LanguageModelChatData)this.data).indexOfInputTokenCount = ((LanguageModelChatData)this.data).outputRowMeta.indexOfValue(outputPrefix + "input_token_count");
            if (((LanguageModelChatData)this.data).indexOfInputTokenCount < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, "input_token_count"));
            }
        }
        if (((LanguageModelChatData)this.data).indexOfOutputTokenCount < 0) {
            ((LanguageModelChatData)this.data).indexOfOutputTokenCount = ((LanguageModelChatData)this.data).outputRowMeta.indexOfValue(outputPrefix + "output_token_count");
            if (((LanguageModelChatData)this.data).indexOfOutputTokenCount < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, "output_token_count"));
            }
        }
        if (((LanguageModelChatData)this.data).indexOfTotalTokenCount < 0) {
            ((LanguageModelChatData)this.data).indexOfTotalTokenCount = ((LanguageModelChatData)this.data).outputRowMeta.indexOfValue(outputPrefix + "total_token_count");
            if (((LanguageModelChatData)this.data).indexOfTotalTokenCount < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, "total_token_count"));
            }
        }
        if (((LanguageModelChatData)this.data).indexOfInferenceTime < 0) {
            ((LanguageModelChatData)this.data).indexOfInferenceTime = ((LanguageModelChatData)this.data).outputRowMeta.indexOfValue(outputPrefix + "inference_time");
            if (((LanguageModelChatData)this.data).indexOfInferenceTime < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, "inference_time"));
            }
        }
        if (((LanguageModelChatData)this.data).indexOfOutput < 0) {
            ((LanguageModelChatData)this.data).indexOfOutput = ((LanguageModelChatData)this.data).outputRowMeta.indexOfValue(outputPrefix + "output");
            if (((LanguageModelChatData)this.data).indexOfOutput < 0) {
                throw new HopException(i18nUtil.i18n(CONST_LANGUAGE_MODEL_CHAT_EXCEPTION_COULDNOT_FIND_FIELD, "output"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRow(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        LanguageModelChat languageModelChat = this;
        synchronized (languageModelChat) {
            super.putRow(rowMeta, row);
        }
    }
}

