/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.ProxyException;
import com.ibm.as400.access.PxPeerConnection;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Verbose;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class PSLoadBalancer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private PSLoad load_ = null;
    private Vector peers_ = null;

    public PSLoadBalancer(PSLoad load) {
        this.load_ = load;
        this.peers_ = new Vector();
    }

    public String accept(int rejections) {
        String peer = null;
        int activeConnections = this.load_.getActiveConnections();
        peer = activeConnections < this.load_.getEffectiveBalanceThreshold() ? null : (activeConnections < this.load_.getEffectiveMaxConnections() ? (rejections > 0 ? null : this.getLeastBusyPeer(true)) : this.getLeastBusyPeer(false));
        return peer;
    }

    private String getLeastBusyPeer(boolean includeThis) {
        double smallestBusyFactor = Double.MAX_VALUE;
        String leastBusyPeer = "";
        Vector peersClone = (Vector)this.peers_.clone();
        Enumeration list = peersClone.elements();
        while (list.hasMoreElements()) {
            PSLoad load;
            String peer = (String)list.nextElement();
            try {
                PxPeerConnection peerConnection = new PxPeerConnection(peer);
                load = peerConnection.load();
                peerConnection.close();
            }
            catch (ProxyException e) {
                Verbose.println(ResourceBundleLoader.getText("PROXY_PEER_NOT_RESPONDING", peer));
                this.peers_.removeElement(peer);
                continue;
            }
            double busyFactor = load.getBusyFactor();
            if (!(busyFactor < smallestBusyFactor)) continue;
            smallestBusyFactor = busyFactor;
            leastBusyPeer = peer;
        }
        if (includeThis && this.load_.getBusyFactor() < smallestBusyFactor) {
            leastBusyPeer = null;
        }
        return leastBusyPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPeers() {
        Vector vector = this.peers_;
        synchronized (vector) {
            Object[] peersAsArray = new String[this.peers_.size()];
            this.peers_.copyInto(peersAsArray);
            return peersAsArray;
        }
    }

    public void setPeers(String peers) {
        StringTokenizer tokenizer = new StringTokenizer(peers, ";, ");
        int count = tokenizer.countTokens();
        Vector<String> temp = new Vector<String>(count);
        while (tokenizer.hasMoreTokens()) {
            String nextPeer = tokenizer.nextToken();
            if (temp.contains(nextPeer)) continue;
            temp.addElement(nextPeer);
        }
        this.peers_ = (Vector)temp.clone();
    }

    public void setPeers(String[] peers) {
        Vector<String> temp = new Vector<String>(peers.length);
        for (int i = 0; i < peers.length; ++i) {
            if (temp.contains(peers[i])) continue;
            temp.addElement(peers[i]);
        }
        this.peers_ = (Vector)temp.clone();
    }
}

