/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.hop.core.util.AddClosureArrayList;
import org.apache.hop.core.util.Assert;
import org.apache.hop.core.util.KeyValue;

public class KeyValueSet
implements Iterable<KeyValue<?>>,
Serializable {
    private static final long serialVersionUID = 925133158112717153L;
    private final Map<String, KeyValue<?>> entries = new TreeMap();

    public KeyValueSet add(KeyValue<?> ... keyValues) {
        for (KeyValue<?> keyValue : keyValues) {
            if (this.entries.containsKey(keyValue.getKey())) {
                throw new IllegalArgumentException("Key already added [key=" + keyValue.getKey() + "]");
            }
            this.entries.put(keyValue.getKey(), keyValue);
        }
        return this;
    }

    @Override
    public Iterator<KeyValue<?>> iterator() {
        return this.keyValues().iterator();
    }

    public KeyValue<?> get(String key) {
        if (key == null) {
            return null;
        }
        return this.entries.get(StringUtils.lowerCase((String)key));
    }

    public List<KeyValue<?>> get(Predicate filter) throws IllegalArgumentException {
        AddClosureArrayList result = new AddClosureArrayList();
        this.walk(result, filter);
        return result;
    }

    public KeyValue<?> getRequired(String key) {
        KeyValue<?> keyValue = this.get(key);
        if (keyValue == null) {
            throw new IllegalArgumentException("Entry not found [key=" + key + "]");
        }
        return keyValue;
    }

    public List<String> keys() {
        return new ArrayList<String>(this.entries.keySet());
    }

    public List<KeyValue<?>> keyValues() {
        return new ArrayList(this.entries.values());
    }

    public List<Object> values() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (KeyValue<?> keyValue : this.entries.values()) {
            result.add(keyValue.getValue());
        }
        return result;
    }

    public Map<String, Object> toMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (KeyValue<?> keyValue : this.entries.values()) {
            map.put(keyValue.getKey(), keyValue.getValue());
        }
        return map;
    }

    public void walk(Closure handler, Predicate filter) throws IllegalArgumentException {
        Assert.assertNotNull(handler, "IHandler cannot be null");
        Assert.assertNotNull(filter, "Filter cannot be null");
        for (KeyValue<?> keyValue : this.entries.values()) {
            if (!filter.evaluate(keyValue)) continue;
            handler.execute(keyValue);
        }
    }

    public void walk(Closure handler) throws IllegalArgumentException {
        this.walk(handler, TruePredicate.INSTANCE);
    }

    public KeyValue<?> remove(String key) {
        if (key == null) {
            return null;
        }
        return this.entries.remove(key);
    }

    public boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        return this.entries.containsKey(key);
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public KeyValueSet clear() {
        this.entries.clear();
        return this;
    }

    public String toMultiLineString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        for (KeyValue<?> keyValue : this.entries.values()) {
            builder.append(keyValue.getKey(), keyValue.getValue());
        }
        return builder.toString();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("size", this.size());
        return builder.toString();
    }
}

