/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.hive;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

@DatabaseMetaPlugin(type="HIVE", typeDescription="Apache Hive", documentationUrl="/database/databases/apache-hive.html")
@GuiPlugin(id="GUI-HiveDatabaseMeta")
public class HiveDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    private static final Class<?> PKG = HiveDatabaseMeta.class;
    @GuiWidgetElement(id="tablePartitions", order="10", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::DatabaseDialog.label.TablePartitions", toolTip="i18n::DatabaseDialog.tooltip.TablePartitions")
    @HopMetadataProperty
    private String tablePartitions;

    public String getSqlInsertClauseBeforeFields(IVariables variables, String schemaTable) {
        String[] tableParts;
        if (StringUtils.isEmpty((String)this.tablePartitions)) {
            return null;
        }
        for (String tablePart : tableParts = variables.resolve(this.tablePartitions).split(";")) {
            String prefix = schemaTable + "(";
            if (!tablePart.startsWith(prefix)) continue;
            return "PARTITION" + tablePart.substring(prefix.length() - 1);
        }
        return null;
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 10000;
        }
        return -1;
    }

    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.isSupportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        return "org.apache.hive.jdbc.HiveDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        ArrayList<String> hostnames = new ArrayList<String>();
        ArrayList<String> ports = new ArrayList<String>();
        for (String hostnamePart : hostname.split(",")) {
            hostnames.add(StringUtils.strip((String)hostnamePart));
        }
        for (String portPart : port.split(",")) {
            ports.add(StringUtils.strip((String)portPart));
        }
        StringBuilder jdbc = new StringBuilder().append("jdbc:hive2://");
        for (int i = 0; i < hostnames.size(); ++i) {
            String portPart;
            if (i > 0) {
                jdbc.append(',');
            }
            String hostnamePart = (String)hostnames.get(i);
            jdbc.append(hostnamePart);
            if (i >= ports.size() || !StringUtils.isNotEmpty((String)(portPart = (String)ports.get(i)))) continue;
            jdbc.append(":").append(portPart);
        }
        return jdbc.append("/").append(databaseName).toString();
    }

    public String getExtraOptionSeparator() {
        return "&";
    }

    public String getExtraOptionIndicator() {
        return "?";
    }

    public boolean isSupportsTransactions() {
        return false;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsViews() {
        return true;
    }

    public boolean isSupportsSynonyms() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCR) {
        Object retval = "";
        String fieldname = v.getName();
        if (v.getLength() == 9999999) {
            v.setLength(this.getMaxTextFieldLength());
        }
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    retval = (String)retval + "BOOLEAN";
                    break;
                }
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = (String)retval + "BIGINT AUTO_INCREMENT NOT NULL PRIMARY KEY";
                        break;
                    }
                    retval = (String)retval + "BIGINT NOT NULL PRIMARY KEY";
                    break;
                }
                if (type == 5) {
                    if (length < 3) {
                        retval = (String)retval + "TINYINT";
                        break;
                    }
                    if (length < 5) {
                        retval = (String)retval + "SMALLINT";
                        break;
                    }
                    if (length < 10) {
                        retval = (String)retval + "INT";
                        break;
                    }
                    if (length < 20) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    retval = (String)retval + "DECIMAL(" + length + ")";
                    break;
                }
                if (type == 6) {
                    if (length < 1) {
                        length = 16;
                    }
                    if (precision < 1) {
                        precision = 16;
                    }
                    retval = (String)retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = (String)retval + "DOUBLE";
                break;
            }
            case 2: {
                retval = (String)retval + "STRING";
                break;
            }
            case 8: {
                retval = (String)retval + "BINARY";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCR) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return new String[]{"ALL", "ALTER", "AND", "ARRAY", "AS", "AUTHORIZATION", "BETWEEN", "BIGINT", "BINARY", "BOOLEAN", "BOTH", "BY", "CACHE", "CASE", "CAST", "CHAR", "COLUMN", "COMMIT", "CONF", "CONSTRAINT", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_TIMESTAMP", "CURSOR", "DATABASE", "DATE", "DAYOFWEEK", "DECIMAL", "DELETE", "DESCRIBE", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "EXCHANGE", "EXISTS", "EXTENDED", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FLOAT", "FLOOR", "FOLLOWING", "FOR", "FOREIGN", "FROM", "FULL", "FUNCTION", "GRANT", "GROUP", "GROUPING", "HAVING", "IF", "IMPORT", "IN", "INNER", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LESS", "LIKE", "LOCAL", "MACRO", "MAP", "MORE", "NONE", "NOT", "NULL", "OF", "ON", "ONLY", "OR", "ORDER", "OUT", "OUTER", "OVER", "PARTIALSCAN", "PARTITION", "PERCENT", "PRECEDING", "PRECISION", "PRESERVE", "PRIMARY", "PROCEDURE", "RANGE", "READS", "REDUCE", "REFERENCES", "REGEXP", "REVOKE", "RIGHT", "RLIKE", "ROLLBACK", "ROLLUP", "ROW", "ROWS", "SELECT", "SET", "SMALLINT", "START", "TABLE", "TABLESAMPLE", "THEN", "TIMESTAMP", "TO", "TRANSFORM", "TRIGGER", "TRUE", "TRUNCATE", "UNBOUNDED", "UNION", "UNIQUEJOIN", "UPDATE", "USER", "USING", "UTC_TMESTAMP", "VALUES", "VARCHAR", "VIEWS", "WHEN", "WHERE", "WINDOW", "WITH"};
    }

    public String getStartQuote() {
        return "`";
    }

    public String getEndQuote() {
        return "`";
    }

    public String getSqlLockTables(String[] tableNames) {
        Object sql = "LOCK TABLES ";
        for (int i = 0; i < tableNames.length; ++i) {
            if (i > 0) {
                sql = (String)sql + ", ";
            }
            sql = (String)sql + tableNames[i] + " WRITE";
        }
        sql = (String)sql + ";" + Const.CR;
        return sql;
    }

    public String getSqlUnlockTables(String[] tableName) {
        return "UNLOCK TABLES";
    }

    public String getExtraOptionsHelpText() {
        return "https://docs.cloudera.com/HDPDocuments/HDP3/HDP-3.1.5/integrating-hive/content/hive_connection_string_url_syntax.html";
    }

    public boolean isSystemTable(String tableName) {
        return false;
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (1, 1)";
    }

    public String quoteSqlString(String string) {
        string = string.replace("'", "\\\\'");
        string = string.replace("\\n", "\\\\n");
        string = string.replace("\\r", "\\\\r");
        return "'" + string + "'";
    }

    public boolean isMySqlVariant() {
        return false;
    }

    public boolean isReleaseSavepoint() {
        return false;
    }

    public boolean IsSupportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    public void addDefaultOptions() {
        this.setForcingIdentifiersToLowerCase(true);
        this.setSupportsTimestampDataType(true);
        this.setSupportsBooleanDataType(true);
    }

    public int getMaxVARCHARLength() {
        return Integer.MAX_VALUE;
    }

    public int getMaxTextFieldLength() {
        return Integer.MAX_VALUE;
    }

    public String getTablePartitions() {
        return this.tablePartitions;
    }

    public void setTablePartitions(String tablePartitions) {
        this.tablePartitions = tablePartitions;
    }
}

