/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class NPConversation {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private ConverterImplRemote converter_ = null;
    private AS400ImplRemote system_ = null;
    private AS400Server server_;
    private NPCPAttribute serverAttributes_ = new NPCPAttribute();

    NPConversation(AS400ImplRemote aSystem, AS400Server aServer) throws AS400Exception, ErrorCompletingRequestException, IOException, InterruptedException {
        this.system_ = aSystem;
        this.server_ = aServer;
        try {
            this.retrieveServerAttributes();
        }
        catch (RequestNotSupportedException e) {
            throw new ErrorCompletingRequestException(1);
        }
    }

    AS400Server getServer() {
        return this.server_;
    }

    String getAttribute(int attributeID) {
        return this.serverAttributes_.getStringValue(attributeID);
    }

    ConverterImpl getConverter() {
        return this.converter_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int makeRequest(NPDataStream request, NPDataStream reply) throws AS400Exception, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        DataStream ds;
        int rc = 0;
        int correlation = this.server_.newCorrelationId();
        request.setConverter(this.converter_);
        reply.setConverter(this.converter_);
        reply.setCorrelation(correlation);
        AS400Server aS400Server = this.server_;
        synchronized (aS400Server) {
            this.server_.clearInstanceReplyStreams();
            this.server_.addInstanceReplyStream(reply);
            this.server_.send(request, correlation);
            Trace.log(1, "makeRequest: send request with correlation" + correlation);
            ds = this.server_.receive(correlation);
        }
        if (ds != null && !(ds instanceof NPDataStream)) {
            Trace.log(2, "Unknown reply data stream:" + ds.getClass().getName(), ds.data_);
            throw new InternalErrorException(2);
        }
        reply = (NPDataStream)ds;
        if (reply == null) {
            Trace.log(2, "Didn't get me datastream back!");
            throw new NullPointerException();
        }
        rc = reply.getReturnCode();
        if (rc != 0) {
            switch (rc) {
                case 9: {
                    NPCPAttribute cpCPFMessage = (NPCPAttribute)reply.getCodePoint(8);
                    if (cpCPFMessage != null) {
                        AS400Message msg;
                        String msgFileName = "";
                        String msgLibraryName = "";
                        String msgDate = cpCPFMessage.getStringValue(34);
                        String msgTime = cpCPFMessage.getStringValue(110);
                        String strCPFMessageID = cpCPFMessage.getStringValue(147);
                        String strCPFMessageText = cpCPFMessage.getStringValue(128);
                        String strCPFMessageHelp = cpCPFMessage.getStringValue(129);
                        String strCPFMessageDefaultReply = cpCPFMessage.getStringValue(130);
                        Integer intCPFMessageSeverity = cpCPFMessage.getIntValue(159);
                        String strCPFMessageType = cpCPFMessage.getStringValue(142);
                        byte[] substitutionData = new byte[cpCPFMessage.getLength()];
                        Integer intCPFMessageType = Integer.valueOf(strCPFMessageType);
                        Trace.log(2, "CPF Message(" + strCPFMessageID + ") = " + strCPFMessageText + ", HelpText= " + strCPFMessageHelp);
                        if (intCPFMessageSeverity != null && intCPFMessageType != null) {
                            msg = new AS400Message(strCPFMessageID, strCPFMessageText, msgFileName, msgLibraryName, intCPFMessageSeverity, intCPFMessageType, substitutionData, strCPFMessageHelp, msgDate, msgTime, strCPFMessageDefaultReply);
                        } else {
                            msg = new AS400Message(strCPFMessageID, strCPFMessageText);
                            msg.setHelp(strCPFMessageHelp);
                        }
                        throw new AS400Exception(msg);
                    }
                }
                case 4: 
                case 14: 
                case 19: 
                case 20: 
                case 21: 
                case 32: 
                case 33: {
                    break;
                }
                case 28: {
                    Trace.log(4, "NetPrint DataStream host cannot change to our NLV.  RC = " + rc);
                    break;
                }
                case 3: {
                    Trace.log(2, "NetPrint DataStream RC = " + rc);
                    throw new RequestNotSupportedException(this.getAttribute(141), 1);
                }
                default: {
                    Trace.log(2, "NetPrint DataStream RC = " + rc);
                    throw new ErrorCompletingRequestException(1);
                }
            }
        }
        return rc;
    }

    private void retrieveServerAttributes() throws AS400Exception, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream req = new NPDataStream(8);
        NPDataStream reply = new NPDataStream(8);
        NPCPAttributeIDList attrsToRetrieve = new NPCPAttributeIDList();
        NPCPAttribute sendAttrs = new NPCPAttribute();
        NPCPAttribute recvAttrs = new NPCPAttribute();
        sendAttrs.setAttrValue(138, ExecutionEnvironment.getCcsid());
        attrsToRetrieve.addAttrID(138);
        req.setAction(15);
        req.addCodePoint(sendAttrs);
        req.addCodePoint(attrsToRetrieve);
        reply.addCodePoint(recvAttrs);
        int rc = this.makeRequest(req, reply);
        if (rc == 0) {
            Integer serverCCSID = recvAttrs.getIntValue(138);
            if (serverCCSID != null) {
                int hostCCSID = serverCCSID;
                this.serverAttributes_.setAttrValue(138, hostCCSID);
                this.converter_ = ConverterImplRemote.getConverter(hostCCSID, this.system_);
            }
            sendAttrs.reset();
            attrsToRetrieve.reset();
            sendAttrs.setAttrValue(180, this.system_.getNLV());
            attrsToRetrieve.addAttrID(180);
            req.setAction(14);
            req.resetCodePoints();
            req.addCodePoint(sendAttrs);
            req.addCodePoint(attrsToRetrieve);
            recvAttrs.reset();
            reply.resetCodePoints();
            reply.addCodePoint(recvAttrs);
            this.makeRequest(req, reply);
            this.serverAttributes_.addUpdateAttributes(recvAttrs);
            attrsToRetrieve.reset();
            attrsToRetrieve.addAttrID(141);
            attrsToRetrieve.addAttrID(59);
            attrsToRetrieve.addAttrID(62);
            attrsToRetrieve.addAttrID(60);
            req.setAction(15);
            req.resetCodePoints();
            req.addCodePoint(attrsToRetrieve);
            recvAttrs.reset();
            reply.resetCodePoints();
            reply.addCodePoint(recvAttrs);
            rc = this.makeRequest(req, reply);
            if (rc == 0) {
                this.serverAttributes_.addUpdateAttributes(recvAttrs);
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, " Network Print Server started ");
                    Trace.log(3, "   NetPrint Server info (System/Job#/JobUser/JobName): " + this.serverAttributes_.getStringValue(60) + "/" + this.serverAttributes_.getStringValue(62) + "/" + this.serverAttributes_.getStringValue(59));
                    Trace.log(3, "   NetPrint Server VRM = " + this.serverAttributes_.getStringValue(141));
                }
            }
        }
    }
}

