/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AS400PackedDecimal
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int digits_;
    private int scale_;
    private static final long defaultValue = 0L;
    static final boolean HIGH_NIBBLE = true;
    static final boolean LOW_NIBBLE = false;
    private boolean useDouble_ = false;

    public AS400PackedDecimal(int numDigits, int numDecimalPositions) {
        if (numDigits < 1 || numDigits > 63) {
            throw new ExtendedIllegalArgumentException("numDigits (" + String.valueOf(numDigits) + ")", 4);
        }
        if (numDecimalPositions < 0 || numDecimalPositions > numDigits) {
            throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(numDecimalPositions) + ")", 4);
        }
        this.digits_ = numDigits;
        this.scale_ = numDecimalPositions;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return this.digits_ / 2 + 1;
    }

    @Override
    public Object getDefaultValue() {
        return BigDecimal.valueOf(0L);
    }

    @Override
    public int getInstanceType() {
        return 7;
    }

    @Override
    public Class getJavaType() {
        return BigDecimal.class;
    }

    public int getNumberOfDigits() {
        return this.digits_;
    }

    public int getNumberOfDecimalPositions() {
        return this.scale_;
    }

    public boolean isUseDouble() {
        return this.useDouble_;
    }

    public void setUseDouble(boolean b) {
        this.useDouble_ = b;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[this.digits_ / 2 + 1];
        this.toBytes(javaValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        return this.toBytes(javaValue, as400Value, 0);
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        int firstNibble;
        int outDigits = this.digits_;
        int outDecimalPlaces = this.scale_;
        int outLength = outDigits / 2 + 1;
        BigDecimal inValue = null;
        try {
            inValue = (BigDecimal)javaValue;
        }
        catch (ClassCastException e) {
            Trace.log(2, "ClassCastException when attempting to cast a " + javaValue.getClass().getName() + " to a BigDecimal", (Throwable)e);
            throw e;
        }
        if (inValue.scale() > outDecimalPlaces) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 1);
        }
        int sign = inValue.signum();
        char[] inChars = inValue.abs().movePointRight(outDecimalPlaces).toBigInteger().toString().toCharArray();
        int inLength = inChars.length;
        if (inLength > outDigits) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 1);
        }
        int inPosition = 0;
        int leadingZeros = outDigits % 2 == 0 ? outDigits - inLength + 1 : outDigits - inLength;
        for (int i = 0; i < leadingZeros - 1; i += 2) {
            as400Value[offset++] = 0;
        }
        if (leadingZeros > 0) {
            if (leadingZeros % 2 != 0) {
                as400Value[offset++] = (byte)(inChars[inPosition++] & 0xF);
            }
        } else if (Trace.traceOn_) {
            Trace.log(1, "The calculated number of leading zeros is negative.", leadingZeros);
        }
        while (inPosition < inChars.length - 1) {
            firstNibble = (inChars[inPosition++] & 0xF) << 4;
            int secondNibble = inChars[inPosition++] & 0xF;
            as400Value[offset++] = (byte)(firstNibble + secondNibble);
        }
        firstNibble = (inChars[inPosition++] & 0xF) << 4;
        as400Value[offset++] = sign != -1 ? (byte)(firstNibble + 15) : (byte)(firstNibble + 13);
        return outLength;
    }

    public byte[] toBytes(double doubleValue) {
        byte[] as400Value = new byte[this.digits_ / 2 + 1];
        this.toBytes(doubleValue, as400Value, 0);
        return as400Value;
    }

    public int toBytes(double doubleValue, byte[] as400Value) {
        return this.toBytes(doubleValue, as400Value, 0);
    }

    public int toBytes(double doubleValue, byte[] as400Value, int offset) {
        int nextDigit;
        double absValue = Math.abs(doubleValue);
        if (absValue > 9.223372036854776E18) {
            throw new ExtendedIllegalArgumentException("doubleValue", 1);
        }
        long leftSide = (long)absValue;
        int effectiveScale = this.scale_ > 15 ? 15 : this.scale_;
        long rightSide = Math.round((absValue - (double)leftSide) * Math.pow(10.0, effectiveScale));
        int length = this.digits_ / 2;
        int b = offset + length;
        boolean nibble = true;
        int scaleDifference = this.scale_ - effectiveScale;
        for (int i = 1; i <= scaleDifference; ++i) {
            if (nibble) {
                int n = b--;
                as400Value[n] = (byte)(as400Value[n] & 0xF);
            } else {
                int n = b;
                as400Value[n] = (byte)(as400Value[n] & 0xFFFFFFF0);
            }
            nibble = !nibble;
        }
        for (int i = 1; i <= effectiveScale; ++i) {
            nextDigit = (int)(rightSide % 10L);
            if (nibble) {
                int n = b;
                as400Value[n] = (byte)(as400Value[n] & 0xF);
                int n2 = b--;
                as400Value[n2] = (byte)(as400Value[n2] | (byte)nextDigit << 4);
            } else {
                int n = b;
                as400Value[n] = (byte)(as400Value[n] & 0xFFFFFFF0);
                int n3 = b;
                as400Value[n3] = (byte)(as400Value[n3] | (byte)nextDigit);
            }
            nibble = !nibble;
            rightSide /= 10L;
        }
        int leftSideDigits = this.digits_ - this.scale_;
        for (int i = 1; i <= leftSideDigits; ++i) {
            nextDigit = (int)(leftSide % 10L);
            if (nibble) {
                int n = b;
                as400Value[n] = (byte)(as400Value[n] & 0xF);
                int n4 = b--;
                as400Value[n4] = (byte)(as400Value[n4] | (byte)nextDigit << 4);
            } else {
                int n = b;
                as400Value[n] = (byte)(as400Value[n] & 0xFFFFFFF0);
                int n5 = b;
                as400Value[n5] = (byte)(as400Value[n5] | (byte)nextDigit);
            }
            nibble = !nibble;
            leftSide /= 10L;
        }
        while (b >= offset) {
            if (nibble) {
                int n = b--;
                as400Value[n] = (byte)(as400Value[n] & 0xF);
            } else {
                int n = b;
                as400Value[n] = (byte)(as400Value[n] & 0xFFFFFFF0);
            }
            nibble = !nibble;
        }
        int n = b = offset + length;
        as400Value[n] = (byte)(as400Value[n] & 0xFFFFFFF0);
        int n6 = b;
        as400Value[n6] = (byte)(as400Value[n6] | (byte)(doubleValue >= 0.0 ? 15 : 13));
        if (leftSide > 0L) {
            throw new ExtendedIllegalArgumentException("doubleValue", 1);
        }
        return length + 1;
    }

    public double toDouble(byte[] as400Value) {
        return this.toDouble(as400Value, 0);
    }

    public double toDouble(byte[] as400Value, int offset) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(offset));
        }
        double doubleValue = 0.0;
        double multiplier = Math.pow(10.0, -this.scale_);
        int rightMostOffset = offset + this.digits_ / 2;
        boolean nibble = true;
        int i = rightMostOffset;
        while (i >= offset) {
            if (nibble) {
                doubleValue += (double)((byte)((as400Value[i] & 0xF0) >> 4)) * multiplier;
                --i;
            } else {
                doubleValue += (double)((byte)(as400Value[i] & 0xF)) * multiplier;
            }
            multiplier *= 10.0;
            nibble = !nibble;
        }
        switch (as400Value[rightMostOffset] & 0xF) {
            case 11: 
            case 13: {
                doubleValue *= -1.0;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                AS400PackedDecimal.throwNumberFormatException(false, rightMostOffset, as400Value[rightMostOffset] & 0xFF, as400Value);
            }
        }
        return doubleValue;
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return this.toObject(as400Value, 0);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        return this.toObject(as400Value, offset, false);
    }

    public Object toObject(byte[] as400Value, int offset, boolean ignoreErrors) {
        int startOffset = offset;
        if (this.useDouble_) {
            return this.toDouble(as400Value, offset);
        }
        if (offset < 0) {
            if (ignoreErrors) {
                return null;
            }
            throw new ArrayIndexOutOfBoundsException(String.valueOf(offset));
        }
        int numDigits = this.digits_;
        int inputSize = numDigits / 2 + 1;
        if (numDigits % 2 == 0) {
            ++numDigits;
        }
        char[] outputData = null;
        int outputPosition = 0;
        int nibble = as400Value[offset + inputSize - 1] & 0xF;
        switch (nibble) {
            case 11: 
            case 13: {
                outputData = new char[numDigits + 1];
                outputData[outputPosition++] = 45;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                outputData = new char[numDigits];
                break;
            }
            default: {
                if (ignoreErrors) {
                    return null;
                }
                AS400PackedDecimal.throwNumberFormatException(false, offset + inputSize - 1, as400Value[offset + inputSize - 1] & 0xFF, as400Value);
                return null;
            }
        }
        while (outputPosition < outputData.length - 1) {
            nibble = (as400Value[offset] & 0xFF) >>> 4;
            if (nibble > 9) {
                if (ignoreErrors) {
                    return null;
                }
                AS400PackedDecimal.throwNumberFormatException(true, offset, as400Value[offset] & 0xFF, as400Value);
            }
            outputData[outputPosition] = (char)(nibble | 0x30);
            ++outputPosition;
            nibble = as400Value[offset] & 0xF;
            if (nibble > 9) {
                if (Trace.traceOn_) {
                    Trace.log(2, " outputPosition=" + outputPosition + " outputData.length=" + outputData.length + " numDigits = " + numDigits + " this.digits = " + this.digits_ + " offset = " + offset + " startOffset = " + startOffset);
                }
                if (ignoreErrors) {
                    return null;
                }
                AS400PackedDecimal.throwNumberFormatException(false, offset, as400Value[offset] & 0xFF, as400Value);
            }
            ++offset;
            outputData[outputPosition] = (char)(nibble | 0x30);
            ++outputPosition;
        }
        nibble = (as400Value[offset] & 0xFF) >>> 4;
        if (nibble > 9) {
            if (ignoreErrors) {
                return null;
            }
            AS400PackedDecimal.throwNumberFormatException(true, offset, as400Value[offset] & 0xFF, as400Value);
        }
        outputData[outputPosition] = (char)(nibble | 0x30);
        return new BigDecimal(new BigInteger(new String(outputData)), this.scale_);
    }

    static final void throwNumberFormatException(boolean highNibble, int byteOffset, int byteValue, byte[] fieldBytes) throws NumberFormatException {
        String text = highNibble ? ResourceBundleLoader.getText("EXC_HIGH_NIBBLE_NOT_VALID", Integer.toString(byteOffset), AS400PackedDecimal.byteToString(byteValue)) : ResourceBundleLoader.getText("EXC_LOW_NIBBLE_NOT_VALID", Integer.toString(byteOffset), AS400PackedDecimal.byteToString(byteValue));
        if (Trace.traceOn_) {
            Trace.log(2, "Byte sequence is not valid for a field of type 'packed decimal':", fieldBytes);
        }
        NumberFormatException nfe = new NumberFormatException(text);
        if (Trace.traceOn_) {
            Trace.log(2, nfe);
        }
        throw nfe;
    }

    private static final String byteToString(int byteVal) {
        int leftDigitValue = byteVal >>> 4 & 0xF;
        int rightDigitValue = byteVal & 0xF;
        char[] digitChars = new char[]{leftDigitValue < 10 ? (char)(48 + leftDigitValue) : (char)(leftDigitValue - 10 + 65), rightDigitValue < 10 ? (char)(48 + rightDigitValue) : (char)(rightDigitValue - 10 + 65)};
        return new String(digitChars);
    }
}

