/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import java.sql.SQLException;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.util.Try;

public class CreateIndexCommand
implements ICommand {
    private final String indexName;
    private final String tableName;
    private final String execId;

    public CreateIndexCommand(String _indexName, String _tableName, String _execId) {
        this.indexName = _indexName;
        this.tableName = _tableName;
        this.execId = _execId;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public ICommand.CommandType getType() {
        return ICommand.CommandType.DDL;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        Try.catching(() -> new Persist2Jet().createIndex(this.tableName, this.indexName)).orThrow(UcanaccessSQLException::new);
        return null;
    }

    @Override
    public IFeedbackAction rollback() {
        return null;
    }
}

