/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.JMException;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.manager.zk.ZKHelixManager;
import org.apache.helix.monitoring.mbeans.ThreadPoolExecutorMonitor;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.task.TaskFactory;
import org.apache.helix.task.TaskStateModel;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStateModelFactory
extends StateModelFactory<TaskStateModel> {
    private static Logger LOG = LoggerFactory.getLogger(TaskStateModelFactory.class);
    private static final int ZKCLIENT_OPERATION_RETRY_TIMEOUT = 5;
    private final HelixManager _manager;
    private final Map<String, TaskFactory> _taskFactoryRegistry;
    private final ScheduledExecutorService _taskExecutor;
    private final ScheduledExecutorService _timerTaskExecutor;
    private ThreadPoolExecutorMonitor _monitor;

    public TaskStateModelFactory(HelixManager manager, Map<String, TaskFactory> taskFactoryRegistry) {
        this(manager, taskFactoryRegistry, TaskStateModelFactory.createThreadPoolExecutor(manager));
    }

    @Deprecated
    public TaskStateModelFactory(HelixManager manager, Map<String, TaskFactory> taskFactoryRegistry, ScheduledExecutorService taskExecutor) {
        this._manager = manager;
        this._taskFactoryRegistry = taskFactoryRegistry;
        this._taskExecutor = taskExecutor;
        this._timerTaskExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TaskStateModelFactory-timeTask_thread");
            }
        });
        if (this._taskExecutor instanceof ThreadPoolExecutor) {
            try {
                this._monitor = new ThreadPoolExecutorMonitor("Task", (ThreadPoolExecutor)((Object)this._taskExecutor));
            }
            catch (JMException e) {
                LOG.warn("Error in creating ThreadPoolExecutorMonitor for TaskStateModelFactory.", (Throwable)e);
            }
        }
    }

    @Override
    public TaskStateModel createNewStateModel(String resourceName, String partitionKey) {
        return new TaskStateModel(this._manager, this._taskFactoryRegistry, this._taskExecutor, this._timerTaskExecutor);
    }

    public void shutdown() {
        if (this._monitor != null) {
            this._monitor.unregister();
        }
        this._taskExecutor.shutdown();
        this._timerTaskExecutor.shutdown();
        if (this._monitor != null) {
            this._monitor.unregister();
        }
    }

    @VisibleForTesting
    void shutdownNow() {
        this._taskExecutor.shutdownNow();
        this._timerTaskExecutor.shutdownNow();
        if (this._monitor != null) {
            this._monitor.unregister();
        }
    }

    public boolean isShutdown() {
        return this._taskExecutor.isShutdown();
    }

    public boolean isTerminated() {
        return this._taskExecutor.isTerminated();
    }

    protected static RealmAwareZkClient createZkClient(HelixManager manager) {
        if (!(manager instanceof ZKHelixManager)) {
            throw new UnsupportedOperationException("Only ZKHelixManager is supported for configurable thread pool.");
        }
        RealmAwareZkClient.RealmAwareZkClientConfig clientConfig = new RealmAwareZkClient.RealmAwareZkClientConfig().setZkSerializer(new ZNRecordSerializer());
        clientConfig.setOperationRetryTimeout(Duration.ofMinutes(5L).toMillis());
        String zkAddress = manager.getMetadataStoreConnectionString();
        if (Boolean.getBoolean("helix.multiZkEnabled") || zkAddress == null) {
            RealmAwareZkClient.RealmAwareZkConnectionConfig zkConnectionConfig = ((ZKHelixManager)manager).getRealmAwareZkConnectionConfig();
            if (zkConnectionConfig == null) {
                String clusterName = manager.getClusterName();
                String shardingKey = HelixUtil.clusterNameToShardingKey(clusterName);
                zkConnectionConfig = new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder().setRealmMode(RealmAwareZkClient.RealmMode.SINGLE_REALM).setZkRealmShardingKey(shardingKey).build();
            }
            try {
                return new FederatedZkClient(zkConnectionConfig, clientConfig);
            }
            catch (IllegalArgumentException | InvalidRoutingDataException e) {
                throw new HelixException("Failed to create FederatedZkClient!", e);
            }
        }
        return SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress), clientConfig.createHelixZkClientConfig());
    }

    private static ScheduledExecutorService createThreadPoolExecutor(HelixManager manager) {
        int targetThreadPoolSize;
        try (RealmAwareZkClient zkClient = TaskStateModelFactory.createZkClient(manager);){
            targetThreadPoolSize = TaskUtil.getTargetThreadPoolSize(zkClient, manager.getClusterName(), manager.getInstanceName());
        }
        LOG.info("Obtained target thread pool size: {} from cluster {} for instance {}. Creating thread pool.", new Object[]{targetThreadPoolSize, manager.getClusterName(), manager.getInstanceName()});
        return Executors.newScheduledThreadPool(targetThreadPoolSize, new ThreadFactoryBuilder().setNameFormat("TaskStateModelFactory-task_thread-%d").build());
    }
}

