/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.List;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterResource.class);

    public ClusterResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            presentation = this.getClusterRepresentation(clusterName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Exception in get cluster", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getClusterRepresentation(String clusterName) throws JsonGenerationException, JsonMappingException, IOException {
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
        List instances = setupTool.getClusterManagementTool().getInstancesInCluster(clusterName);
        ZNRecord clusterSummayRecord = new ZNRecord("Cluster Summary");
        clusterSummayRecord.setListField("participants", instances);
        List resources = setupTool.getClusterManagementTool().getResourcesInCluster(clusterName);
        clusterSummayRecord.setListField("resources", resources);
        List models = setupTool.getClusterManagementTool().getStateModelDefs(clusterName);
        clusterSummayRecord.setListField("stateModelDefs", models);
        HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        LiveInstance leader = (LiveInstance)accessor.getProperty(keyBuilder.controllerLeader());
        if (leader != null) {
            clusterSummayRecord.setSimpleField("LEADER", leader.getInstanceName());
        } else {
            clusterSummayRecord.setSimpleField("LEADER", "");
        }
        StringRepresentation representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(clusterSummayRecord), MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation post(Representation entity) {
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            if (command == null) {
                throw new HelixException("Could NOT find 'command' in parameterMap: " + jsonParameters._parameterMap);
            }
            if (command.equalsIgnoreCase("activateCluster") || JsonParameters.CLUSTERSETUP_COMMAND_ALIASES.get("activateCluster").contains(command)) {
                jsonParameters.verifyCommand("activateCluster");
                boolean enabled = true;
                if (jsonParameters.getParameter("enabled") != null) {
                    enabled = Boolean.parseBoolean(jsonParameters.getParameter("enabled"));
                }
                String grandCluster = jsonParameters.getParameter("grandCluster");
                setupTool.activateCluster(clusterName, grandCluster, enabled);
            } else if (command.equalsIgnoreCase("expandCluster")) {
                setupTool.expandCluster(clusterName);
            } else {
                throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "activateCluster" + ", " + "expandCluster" + "]");
            }
            this.getResponse().setEntity((Representation)this.getClusterRepresentation(clusterName));
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        return this.getResponseEntity();
    }

    public Representation delete() {
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
            setupTool.deleteCluster(clusterName);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        return null;
    }
}

