/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixManager;
import org.apache.helix.common.caches.TaskDataCache;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.rebalancer.util.RebalanceScheduler;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.monitoring.mbeans.JobMonitor;
import org.apache.helix.task.AssignableInstanceManager;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.RuntimeJobDag;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskAssignmentCalculator;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTaskDispatcher.class);
    private static final String TASK_LATENCY_TAG = "Latency";
    protected HelixManager _manager;
    protected static RebalanceScheduler _rebalanceScheduler = new RebalanceScheduler();
    protected ClusterStatusMonitor _clusterStatusMonitor;

    public void init(HelixManager manager) {
        this._manager = manager;
    }

    /*
     * Unable to fully structure code
     */
    public void updatePreviousAssignedTasksStatus(Map<String, SortedSet<Integer>> prevInstanceToTaskAssignments, Set<String> excludedInstances, String jobResource, CurrentStateOutput currStateOutput, JobContext jobCtx, JobConfig jobCfg, ResourceAssignment prevTaskToInstanceStateAssignment, TaskState jobState, Map<String, Set<Integer>> assignedPartitions, Set<Integer> partitionsToDropFromIs, Map<Integer, PartitionAssignment> paMap, TargetState jobTgtState, Set<Integer> skippedPartitions, WorkflowControllerDataProvider cache, Map<String, Set<Integer>> tasksToDrop) {
        assignableInstanceManager = cache.getAssignableInstanceManager();
        for (String instance : prevInstanceToTaskAssignments.keySet()) {
            assignedPartitions.put(instance, new HashSet<E>());
            if (tasksToDrop.containsKey(instance)) {
                for (int pIdToDrop : tasksToDrop.get(instance)) {
                    paMap.put(pIdToDrop, new PartitionAssignment(instance, TaskPartitionState.DROPPED.name()));
                    assignedPartitions.get(instance).add(pIdToDrop);
                }
            }
            if (excludedInstances.contains(instance)) continue;
            pSet = prevInstanceToTaskAssignments.get(instance);
            if (tasksToDrop.containsKey(instance)) {
                pSet.removeAll((Collection)tasksToDrop.get(instance));
            }
            donePartitions = new TreeSet<Integer>();
            var21_22 = pSet.iterator();
            block10: while (var21_22.hasNext()) {
                pId = (Integer)var21_22.next();
                pName = this.pName(jobResource, pId);
                currState = this.updateJobContextAndGetTaskCurrentState(currStateOutput, jobResource, pId, pName, instance, jobCtx, jobTgtState);
                if (currState == TaskPartitionState.ERROR || currState == TaskPartitionState.TASK_ERROR || currState == TaskPartitionState.TIMED_OUT || currState == TaskPartitionState.TASK_ABORTED) {
                    AbstractTaskDispatcher.markPartitionError(jobCtx, pId, currState);
                }
                if ((pendingMessage = currStateOutput.getPendingMessage(jobResource, new Partition(pName), instance)) != null && !pendingMessage.getToState().equals(currState.name())) {
                    this.processTaskWithPendingMessage(prevTaskToInstanceStateAssignment, pId, pName, instance, pendingMessage, jobState, currState, paMap, assignedPartitions);
                    continue;
                }
                quotaType = jobCfg.getJobType();
                taskId = TaskUtil.isGenericTaskJob(jobCfg) != false ? jobCtx.getTaskIdForPartition(pId) : pName;
                taskConfig = jobCfg.getTaskConfig(taskId);
                requestedStateStr = currStateOutput.getRequestedState(jobResource, new Partition(pName), instance);
                if (requestedStateStr != null && !requestedStateStr.isEmpty()) {
                    requestedState = TaskPartitionState.valueOf(requestedStateStr);
                    if (requestedState.equals((Object)currState)) {
                        AbstractTaskDispatcher.LOG.warn(String.format("Requested state %s is the same as the current state for instance %s.", new Object[]{requestedState, instance}));
                    }
                    if (currState == TaskPartitionState.STOPPED && jobTgtState == TargetState.STOP) {
                        assignableInstanceManager.release(instance, taskConfig, quotaType);
                        continue;
                    }
                    if (!paMap.containsKey(pId)) {
                        paMap.put(pId, new PartitionAssignment(instance, requestedState.name()));
                    }
                    assignedPartitions.get(instance).add(pId);
                    if (!AbstractTaskDispatcher.LOG.isDebugEnabled()) continue;
                    AbstractTaskDispatcher.LOG.debug(String.format("Instance %s requested a state transition to %s for partition %s.", new Object[]{instance, requestedState, pName}));
                    continue;
                }
                switch (1.$SwitchMap$org$apache$helix$task$TaskPartitionState[currState.ordinal()]) {
                    case 1: {
                        nextState = TaskPartitionState.RUNNING;
                        if (jobState == TaskState.TIMING_OUT) {
                            nextState = TaskPartitionState.TASK_ABORTED;
                        } else if (jobTgtState == TargetState.STOP) {
                            nextState = TaskPartitionState.STOPPED;
                        } else if (jobState == TaskState.ABORTED || jobState == TaskState.FAILED || jobState == TaskState.FAILING || jobState == TaskState.TIMED_OUT) {
                            paMap.put(pId, new PartitionAssignment(instance, TaskPartitionState.DROPPED.name()));
                            break;
                        }
                        paMap.put(pId, new PartitionAssignment(instance, nextState.name()));
                        assignedPartitions.get(instance).add(pId);
                        if (!AbstractTaskDispatcher.LOG.isDebugEnabled()) continue block10;
                        AbstractTaskDispatcher.LOG.debug(String.format("Setting task partition %s state to %s on instance %s.", new Object[]{pName, nextState, instance}));
                        break;
                    }
                    case 2: {
                        if (jobTgtState.equals((Object)TargetState.START)) {
                            nextState = TaskPartitionState.RUNNING;
                        } else {
                            nextState = TaskPartitionState.STOPPED;
                            assignableInstanceManager.release(instance, taskConfig, quotaType);
                        }
                        paMap.put(pId, new PartitionAssignment(instance, nextState.name()));
                        assignedPartitions.get(instance).add(pId);
                        if (!AbstractTaskDispatcher.LOG.isDebugEnabled()) continue block10;
                        AbstractTaskDispatcher.LOG.debug(String.format("Setting task partition %s state to %s on instance %s.", new Object[]{pName, nextState, instance}));
                        break;
                    }
                    case 3: {
                        donePartitions.add(pId);
                        if (AbstractTaskDispatcher.LOG.isDebugEnabled()) {
                            AbstractTaskDispatcher.LOG.debug(String.format("Task partition %s has completed with state %s. Marking as such in rebalancer context.", new Object[]{pName, currState}));
                        }
                        partitionsToDropFromIs.add(pId);
                        AbstractTaskDispatcher.markPartitionCompleted(jobCtx, pId);
                        assignableInstanceManager.release(instance, taskConfig, quotaType);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        donePartitions.add(pId);
                        if (AbstractTaskDispatcher.LOG.isDebugEnabled()) {
                            AbstractTaskDispatcher.LOG.debug(String.format("Task partition %s has error state %s with msg %s. Marking as such in rebalancer context.", new Object[]{pName, currState, jobCtx.getPartitionInfo(pId)}));
                        }
                        if (jobState != TaskState.TIMED_OUT && jobState != TaskState.TIMING_OUT) {
                            if (jobCtx.getPartitionNumAttempts(pId) >= jobCfg.getMaxAttemptsPerTask() || currState.equals((Object)TaskPartitionState.TASK_ABORTED) || currState.equals((Object)TaskPartitionState.ERROR)) {
                                skippedPartitions.add(pId);
                                partitionsToDropFromIs.add(pId);
                                if (AbstractTaskDispatcher.LOG.isDebugEnabled()) {
                                    AbstractTaskDispatcher.LOG.debug("skippedPartitions:" + skippedPartitions);
                                }
                            } else {
                                AbstractTaskDispatcher.markPartitionDelayed(jobCfg, jobCtx, pId);
                            }
                        }
                        assignableInstanceManager.release(instance, taskConfig, quotaType);
                        break;
                    }
                    case 8: {
                        if (jobState != TaskState.TIMED_OUT && jobState != TaskState.TIMING_OUT && jobTgtState != TargetState.DELETE) ** GOTO lbl113
                        partitionsToDropFromIs.add(pId);
                        assignableInstanceManager.release(instance, taskConfig, quotaType);
                        ** GOTO lbl118
lbl113:
                        // 1 sources

                        if (jobState == TaskState.IN_PROGRESS && jobTgtState != TargetState.STOP && jobTgtState != TargetState.DELETE) {
                            paMap.put(pId, new PartitionAssignment(instance, TaskPartitionState.RUNNING.name()));
                            assignedPartitions.get(instance).add(pId);
                        }
                    }
lbl118:
                    // 5 sources

                    case 9: {
                        donePartitions.add(pId);
                        if (AbstractTaskDispatcher.LOG.isDebugEnabled()) {
                            AbstractTaskDispatcher.LOG.debug(String.format("Task partition %s has state %s. It will be dropped from the current ideal state.", new Object[]{pName, currState}));
                        }
                        if (currState != TaskPartitionState.DROPPED) continue block10;
                        assignableInstanceManager.release(instance, taskConfig, quotaType);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown enum symbol: " + (Object)currState));
                    }
                }
            }
            pSet.removeAll(donePartitions);
        }
    }

    protected String pName(String resource, int pId) {
        return String.format("%s_%s", resource, pId);
    }

    private TaskPartitionState updateJobContextAndGetTaskCurrentState(CurrentStateOutput currentStateOutput, String jobResource, Integer pId, String pName, String instance, JobContext jobCtx, TargetState jobTgtState) {
        String currentStateString = currentStateOutput.getCurrentState(jobResource, new Partition(pName), instance);
        if (currentStateString == null) {
            TaskPartitionState stateFromContext = jobCtx.getPartitionState(pId);
            if (jobTgtState == TargetState.STOP && (stateFromContext == TaskPartitionState.RUNNING || stateFromContext == TaskPartitionState.INIT)) {
                jobCtx.setPartitionState(pId, TaskPartitionState.STOPPED);
                return TaskPartitionState.STOPPED;
            }
            return stateFromContext == null ? TaskPartitionState.INIT : stateFromContext;
        }
        TaskPartitionState currentState = TaskPartitionState.valueOf(currentStateString);
        jobCtx.setPartitionState(pId, currentState);
        String taskMsg = currentStateOutput.getInfo(jobResource, new Partition(pName), instance);
        if (taskMsg != null) {
            jobCtx.setPartitionInfo(pId, taskMsg);
        }
        return currentState;
    }

    private void processTaskWithPendingMessage(ResourceAssignment prevAssignment, Integer pId, String pName, String instance, Message pendingMessage, TaskState jobState, TaskPartitionState currState, Map<Integer, PartitionAssignment> paMap, Map<String, Set<Integer>> assignedPartitions) {
        Map<String, String> stateMap = prevAssignment.getReplicaMap(new Partition(pName));
        if (stateMap != null) {
            String prevState = stateMap.get(instance);
            if (!pendingMessage.getToState().equals(prevState)) {
                LOG.warn(String.format("Task pending to-state is %s while previous assigned state is %s. This should nothappen.", pendingMessage.getToState(), prevState));
            }
            if (jobState == TaskState.TIMING_OUT && currState == TaskPartitionState.INIT && prevState.equals(TaskPartitionState.RUNNING.name())) {
                paMap.put(pId, new PartitionAssignment(instance, TaskPartitionState.INIT.name()));
                assignedPartitions.get(instance).add(pId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Task partition %s has a pending state transition on instance %s INIT->RUNNING. Previous state %sSetting it back to INIT so that Helix can cancel the transition(if enabled).", pName, instance, prevState));
                }
            } else {
                paMap.put(pId, new PartitionAssignment(instance, prevState));
                assignedPartitions.get(instance).add(pId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Task partition %s has a pending state transition on instance %s. Using the previous ideal state which was %s.", pName, instance, prevState));
                }
            }
        }
    }

    protected static void markPartitionCompleted(JobContext ctx, int pId) {
        ctx.setPartitionState(pId, TaskPartitionState.COMPLETED);
        ctx.setPartitionFinishTime(pId, System.currentTimeMillis());
    }

    protected static void markPartitionError(JobContext ctx, int pId, TaskPartitionState state) {
        ctx.setPartitionState(pId, state);
        ctx.setPartitionFinishTime(pId, System.currentTimeMillis());
    }

    protected static void markAllPartitionsError(JobContext ctx) {
        for (int pId : ctx.getPartitionSet()) {
            AbstractTaskDispatcher.markPartitionError(ctx, pId, TaskPartitionState.ERROR);
        }
    }

    protected static void markPartitionDelayed(JobConfig cfg, JobContext ctx, int p) {
        long delayInterval = cfg.getTaskRetryDelay();
        if (delayInterval <= 0L) {
            return;
        }
        long nextStartTime = ctx.getPartitionFinishTime(p) + delayInterval;
        ctx.setNextRetryTime(p, nextStartTime);
    }

    protected void handleJobTimeout(JobContext jobCtx, WorkflowContext workflowCtx, String jobResource, JobConfig jobCfg) {
        jobCtx.setFinishTime(System.currentTimeMillis());
        workflowCtx.setJobState(jobResource, TaskState.TIMED_OUT);
        for (int pId : jobCtx.getPartitionSet()) {
            if (jobCtx.getPartitionState(pId) != TaskPartitionState.INIT) continue;
            jobCtx.setPartitionState(pId, TaskPartitionState.TASK_ABORTED);
        }
        this._clusterStatusMonitor.updateJobCounters(jobCfg, TaskState.TIMED_OUT);
        _rebalanceScheduler.removeScheduledRebalance(jobResource);
        TaskUtil.cleanupJobIdealStateExtView(this._manager.getHelixDataAccessor(), jobResource);
    }

    protected void failJob(String jobName, WorkflowContext workflowContext, JobContext jobContext, WorkflowConfig workflowConfig, Map<String, JobConfig> jobConfigMap, WorkflowControllerDataProvider dataProvider) {
        this.markJobFailed(jobName, jobContext, workflowConfig, workflowContext, jobConfigMap, dataProvider);
        for (int pId : jobContext.getPartitionSet()) {
            if (jobContext.getPartitionState(pId) != TaskPartitionState.INIT) continue;
            jobContext.setPartitionState(pId, TaskPartitionState.TASK_ABORTED);
        }
        this._clusterStatusMonitor.updateJobCounters(jobConfigMap.get(jobName), TaskState.FAILED);
        _rebalanceScheduler.removeScheduledRebalance(jobName);
        TaskUtil.cleanupJobIdealStateExtView(this._manager.getHelixDataAccessor(), jobName);
    }

    protected void handleAdditionalTaskAssignment(Map<String, SortedSet<Integer>> prevInstanceToTaskAssignments, Set<String> excludedInstances, String jobResource, CurrentStateOutput currStateOutput, JobContext jobCtx, JobConfig jobCfg, WorkflowConfig workflowConfig, WorkflowContext workflowCtx, WorkflowControllerDataProvider cache, ResourceAssignment prevTaskToInstanceStateAssignment, Map<String, Set<Integer>> assignedPartitions, Map<Integer, PartitionAssignment> paMap, Set<Integer> skippedPartitions, TaskAssignmentCalculator taskAssignmentCal, Set<Integer> allPartitions, long currentTime, Collection<String> liveInstances) {
        boolean existsLiveInstanceOrCurrentStateChange = cache.getExistsLiveInstanceOrCurrentStateChange();
        TreeSet excludeSet = Sets.newTreeSet();
        for (Set<Integer> assignedSet : assignedPartitions.values()) {
            excludeSet.addAll(assignedSet);
        }
        AbstractTaskDispatcher.addCompletedTasks(excludeSet, jobCtx, allPartitions);
        AbstractTaskDispatcher.addGiveupPartitions(excludeSet, jobCtx, allPartitions, jobCfg);
        excludeSet.addAll(skippedPartitions);
        Set<Integer> partitionsWithDelay = TaskUtil.getNonReadyPartitions(jobCtx, currentTime);
        excludeSet.addAll(partitionsWithDelay);
        Set<Integer> filteredTaskPartitionNumbers = this.filterTasks(allPartitions, jobCtx, liveInstances);
        filteredTaskPartitionNumbers.removeAll(excludeSet);
        HashSet<Integer> partitionsToRetryOnLiveInstanceChangeForTargetedJob = new HashSet<Integer>();
        if (!TaskUtil.isGenericTaskJob(jobCfg) && existsLiveInstanceOrCurrentStateChange) {
            for (int partitionNum : allPartitions) {
                TaskPartitionState taskPartitionState = jobCtx.getPartitionState(partitionNum);
                if (!this.isTaskNotInTerminalState(taskPartitionState) || partitionsWithDelay.contains(partitionNum)) continue;
                partitionsToRetryOnLiveInstanceChangeForTargetedJob.add(partitionNum);
            }
        }
        filteredTaskPartitionNumbers.addAll(partitionsToRetryOnLiveInstanceChangeForTargetedJob);
        Map<String, SortedSet<Integer>> tgtPartitionAssignments = taskAssignmentCal.getTaskAssignment(currStateOutput, prevTaskToInstanceStateAssignment, liveInstances, jobCfg, jobCtx, workflowConfig, workflowCtx, filteredTaskPartitionNumbers, cache.getIdealStates());
        if (!TaskUtil.isGenericTaskJob(jobCfg) && jobCfg.isRebalanceRunningTask()) {
            this.dropRebalancedRunningTasks(tgtPartitionAssignments, prevInstanceToTaskAssignments, paMap, jobCtx);
        }
        if (!TaskUtil.isGenericTaskJob(jobCfg) && existsLiveInstanceOrCurrentStateChange) {
            this.dropRebalancedRunningTasks(tgtPartitionAssignments, prevInstanceToTaskAssignments, paMap, jobCtx);
        }
        for (Map.Entry<String, SortedSet<Integer>> entry : prevInstanceToTaskAssignments.entrySet()) {
            String instance = entry.getKey();
            if (!tgtPartitionAssignments.containsKey(instance)) continue;
            if (excludedInstances.contains(instance)) {
                if (!cache.getAssignableInstanceManager().getAssignableInstanceMap().containsKey(instance)) continue;
                AssignableInstanceManager assignableInstanceManager = cache.getAssignableInstanceManager();
                String quotaType = jobCfg.getJobType();
                Iterator iterator = tgtPartitionAssignments.get(instance).iterator();
                while (iterator.hasNext()) {
                    int partitionNum = (Integer)iterator.next();
                    String taskId = this.getTaskId(jobCfg, jobCtx, partitionNum);
                    TaskConfig taskConfig = jobCfg.getTaskConfig(taskId);
                    assignableInstanceManager.release(instance, taskConfig, quotaType);
                }
                continue;
            }
            int jobCfgLimitation = jobCfg.getNumConcurrentTasksPerInstance() - assignedPartitions.get(instance).size();
            int participantCapacity = cache.getInstanceConfigMap().get(instance).getMaxConcurrentTask();
            if (participantCapacity == -1) {
                participantCapacity = cache.getClusterConfig().getMaxConcurrentTaskPerInstance();
            }
            int participantLimitation = participantCapacity - cache.getParticipantActiveTaskCount(instance);
            int numToAssign = Math.min(jobCfgLimitation, participantLimitation);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Throttle tasks to be assigned to instance %s using limitation: Job Concurrent Task(%d), Participant Max Task(%d). Remaining capacity %d.", instance, jobCfgLimitation, participantCapacity, numToAssign));
            }
            HashSet<Integer> throttledSet = new HashSet<Integer>();
            if (numToAssign > 0) {
                List<Integer> nextPartitions = AbstractTaskDispatcher.getNextPartitions(tgtPartitionAssignments.get(instance), excludeSet, throttledSet, numToAssign);
                for (Integer pId : nextPartitions) {
                    String pName = this.pName(jobResource, pId);
                    paMap.put(pId, new PartitionAssignment(instance, TaskPartitionState.RUNNING.name()));
                    excludeSet.add(pId);
                    jobCtx.setAssignedParticipant(pId, instance);
                    jobCtx.setPartitionState(pId, TaskPartitionState.INIT);
                    long currentTimestamp = System.currentTimeMillis();
                    jobCtx.setPartitionStartTime(pId, currentTimestamp);
                    if (jobCtx.getExecutionStartTime() == -1L) {
                        jobCtx.setExecutionStartTime(currentTimestamp);
                        AbstractTaskDispatcher.reportSubmissionToScheduleDelay(cache, this._clusterStatusMonitor, workflowConfig, jobCfg, currentTimestamp);
                    }
                    jobCtx.incrementNumAttempts(pId);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(String.format("Setting task partition %s state to %s on instance %s.", new Object[]{pName, TaskPartitionState.RUNNING, instance}));
                }
                cache.setParticipantActiveTaskCount(instance, cache.getParticipantActiveTaskCount(instance) + nextPartitions.size());
            } else {
                HashSet throttledSetWithExcludeSet = new HashSet(tgtPartitionAssignments.get(instance));
                throttledSetWithExcludeSet.removeAll(excludeSet);
                throttledSet.addAll(throttledSetWithExcludeSet);
            }
            if (throttledSet.isEmpty() || !cache.getAssignableInstanceManager().getAssignableInstanceMap().containsKey(instance)) continue;
            AssignableInstanceManager assignableInstanceManager = cache.getAssignableInstanceManager();
            String quotaType = jobCfg.getJobType();
            Iterator iterator = throttledSet.iterator();
            while (iterator.hasNext()) {
                int partitionNum = (Integer)iterator.next();
                String taskId = this.getTaskId(jobCfg, jobCtx, partitionNum);
                TaskConfig taskConfig = jobCfg.getTaskConfig(taskId);
                assignableInstanceManager.release(instance, taskConfig, quotaType);
            }
            LOG.debug(throttledSet.size() + "tasks are ready but throttled when assigned to participant.");
        }
    }

    protected void scheduleForNextTask(String job, JobContext jobCtx, long now) {
        long scheduledTime;
        boolean shouldSchedule = false;
        long earliestTime = Long.MAX_VALUE;
        for (int p : jobCtx.getPartitionSet()) {
            long retryTime = jobCtx.getNextRetryTime(p);
            TaskPartitionState state = jobCtx.getPartitionState(p);
            TaskPartitionState taskPartitionState = state = state != null ? state : TaskPartitionState.INIT;
            HashSet errorStates = Sets.newHashSet((Object[])new TaskPartitionState[]{TaskPartitionState.ERROR, TaskPartitionState.TASK_ERROR, TaskPartitionState.TIMED_OUT});
            if (!errorStates.contains((Object)state) || retryTime <= now || retryTime >= earliestTime) continue;
            earliestTime = retryTime;
            shouldSchedule = true;
        }
        if (shouldSchedule && ((scheduledTime = _rebalanceScheduler.getRebalanceTime(job)) == -1L || earliestTime < scheduledTime)) {
            _rebalanceScheduler.scheduleRebalance(this._manager, job, earliestTime);
        }
    }

    protected static void addGiveupPartitions(Set<Integer> set, JobContext ctx, Iterable<Integer> pIds, JobConfig cfg) {
        for (Integer pId : pIds) {
            if (!AbstractTaskDispatcher.isTaskGivenup(ctx, cfg, pId)) continue;
            set.add(pId);
        }
    }

    private static List<Integer> getNextPartitions(SortedSet<Integer> candidatePartitions, Set<Integer> excluded, Set<Integer> throttled, int n) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer pId : candidatePartitions) {
            if (excluded.contains(pId)) continue;
            if (result.size() < n) {
                result.add(pId);
                continue;
            }
            throttled.add(pId);
        }
        return result;
    }

    private static void addCompletedTasks(Set<Integer> set, JobContext ctx, Iterable<Integer> pIds) {
        for (Integer pId : pIds) {
            TaskPartitionState state = ctx.getPartitionState(pId);
            if (state != TaskPartitionState.COMPLETED) continue;
            set.add(pId);
        }
    }

    private Set<Integer> filterTasks(Iterable<Integer> allPartitions, JobContext jobContext, Collection<String> liveInstances) {
        HashSet<Integer> filteredTasks = new HashSet<Integer>();
        for (int partitionNumber : allPartitions) {
            String assignedParticipant;
            TaskPartitionState state = jobContext.getPartitionState(partitionNumber);
            if (state == null || state == TaskPartitionState.STOPPED || state == TaskPartitionState.TIMED_OUT || state == TaskPartitionState.TASK_ERROR || state == TaskPartitionState.DROPPED) {
                filteredTasks.add(partitionNumber);
            }
            if (!this.isTaskNotInTerminalState(state) || (assignedParticipant = jobContext.getAssignedParticipant(partitionNumber)) == null || liveInstances.contains(assignedParticipant)) continue;
            jobContext.setPartitionState(partitionNumber, TaskPartitionState.DROPPED);
            filteredTasks.add(partitionNumber);
        }
        return filteredTasks;
    }

    private boolean isTaskNotInTerminalState(TaskPartitionState state) {
        return state != TaskPartitionState.COMPLETED && state != TaskPartitionState.TASK_ABORTED && state != TaskPartitionState.DROPPED && state != TaskPartitionState.ERROR;
    }

    protected static boolean isTaskGivenup(JobContext ctx, JobConfig cfg, int pId) {
        TaskPartitionState state = ctx.getPartitionState(pId);
        if (state == TaskPartitionState.TASK_ABORTED || state == TaskPartitionState.ERROR) {
            return true;
        }
        if (state == TaskPartitionState.TIMED_OUT || state == TaskPartitionState.TASK_ERROR) {
            return ctx.getPartitionNumAttempts(pId) >= cfg.getMaxAttemptsPerTask();
        }
        return false;
    }

    private void dropRebalancedRunningTasks(Map<String, SortedSet<Integer>> newAssignment, Map<String, SortedSet<Integer>> oldAssignment, Map<Integer, PartitionAssignment> paMap, JobContext jobContext) {
        for (String instance : oldAssignment.keySet()) {
            Iterator iterator = oldAssignment.get(instance).iterator();
            while (iterator.hasNext()) {
                int pId = (Integer)iterator.next();
                if (jobContext.getPartitionState(pId) != TaskPartitionState.RUNNING) continue;
                boolean existsInNewAssignment = false;
                for (Map.Entry<String, SortedSet<Integer>> entry : newAssignment.entrySet()) {
                    if (entry.getKey().equals(instance) || !entry.getValue().contains(pId)) continue;
                    existsInNewAssignment = true;
                    LOG.info("Currently running task partition number: {} is being dropped from instance: {} and will be newly assigned to instance: {}. This is due to a LiveInstance/CurrentState change, and because this is a targeted task.", new Object[]{pId, instance, entry.getKey()});
                    break;
                }
                if (!existsInNewAssignment) continue;
                paMap.put(pId, new PartitionAssignment(instance, TaskPartitionState.DROPPED.name()));
                jobContext.setPartitionState(pId, TaskPartitionState.DROPPED);
            }
        }
    }

    protected void markJobComplete(String jobName, JobContext jobContext, WorkflowConfig workflowConfig, WorkflowContext workflowContext, Map<String, JobConfig> jobConfigMap, WorkflowControllerDataProvider dataProvider) {
        this.finishJobInRuntimeJobDag(dataProvider.getTaskDataCache(), workflowConfig.getWorkflowId(), jobName);
        long currentTime = System.currentTimeMillis();
        workflowContext.setJobState(jobName, TaskState.COMPLETED);
        jobContext.setFinishTime(currentTime);
        if (this.isWorkflowFinished(workflowContext, workflowConfig, jobConfigMap, dataProvider)) {
            workflowContext.setFinishTime(currentTime);
            this.updateWorkflowMonitor(workflowContext, workflowConfig);
        }
        this.scheduleJobCleanUp(jobConfigMap.get(jobName), workflowConfig, currentTime);
        JobConfig jobConfig = jobConfigMap.get(jobName);
        if (jobConfig != null) {
            AbstractTaskDispatcher.reportControllerInducedDelay(dataProvider, this._clusterStatusMonitor, workflowConfig, jobConfig, currentTime);
        }
    }

    protected void markJobFailed(String jobName, JobContext jobContext, WorkflowConfig workflowConfig, WorkflowContext workflowContext, Map<String, JobConfig> jobConfigMap, WorkflowControllerDataProvider clusterDataCache) {
        this.finishJobInRuntimeJobDag(clusterDataCache.getTaskDataCache(), workflowConfig.getWorkflowId(), jobName);
        long currentTime = System.currentTimeMillis();
        workflowContext.setJobState(jobName, TaskState.FAILED);
        if (jobContext != null) {
            jobContext.setFinishTime(currentTime);
        }
        if (this.isWorkflowFinished(workflowContext, workflowConfig, jobConfigMap, clusterDataCache)) {
            workflowContext.setFinishTime(currentTime);
            this.updateWorkflowMonitor(workflowContext, workflowConfig);
        }
        this.scheduleJobCleanUp(jobConfigMap.get(jobName), workflowConfig, currentTime);
    }

    protected void scheduleJobCleanUp(JobConfig jobConfig, WorkflowConfig workflowConfig, long currentTime) {
        long currentScheduledTime;
        long l = currentScheduledTime = _rebalanceScheduler.getRebalanceTime(workflowConfig.getWorkflowId()) == -1L ? Long.MAX_VALUE : _rebalanceScheduler.getRebalanceTime(workflowConfig.getWorkflowId());
        if (currentTime + jobConfig.getExpiry() < currentScheduledTime) {
            _rebalanceScheduler.scheduleRebalance(this._manager, workflowConfig.getWorkflowId(), currentTime + jobConfig.getExpiry());
        }
    }

    protected boolean isWorkflowFinished(WorkflowContext ctx, WorkflowConfig cfg, Map<String, JobConfig> jobConfigMap, WorkflowControllerDataProvider clusterDataCache) {
        boolean incomplete = false;
        TaskState workflowState = ctx.getWorkflowState();
        if (TaskState.TIMED_OUT.equals((Object)workflowState)) {
            return true;
        }
        int failedJobs = 0;
        for (String job : cfg.getJobDag().getAllNodes()) {
            TaskState jobState = ctx.getJobState(job);
            if (!(jobState != TaskState.FAILED && jobState != TaskState.TIMED_OUT || cfg.isJobQueue() || ++failedJobs <= cfg.getFailureThreshold())) {
                ctx.setWorkflowState(TaskState.FAILED);
                LOG.info("Workflow {} reached the failure threshold, so setting its state to FAILED.", (Object)cfg.getWorkflowId());
                for (String jobToFail : cfg.getJobDag().getAllNodes()) {
                    if (ctx.getJobState(jobToFail) != TaskState.IN_PROGRESS) continue;
                    ctx.setJobState(jobToFail, TaskState.ABORTED);
                    if (this._clusterStatusMonitor != null) {
                        this._clusterStatusMonitor.updateJobCounters(jobConfigMap.get(jobToFail), TaskState.ABORTED);
                    }
                    if (clusterDataCache == null) continue;
                    AssignableInstanceManager assignableInstanceManager = clusterDataCache.getAssignableInstanceManager();
                    JobConfig jobConfig = jobConfigMap.get(jobToFail);
                    String quotaType = jobConfig.getJobType();
                    Map<String, TaskConfig> taskConfigMap = jobConfig.getTaskConfigMap();
                    for (Map.Entry<String, TaskConfig> taskEntry : taskConfigMap.entrySet()) {
                        TaskConfig taskConfig = taskEntry.getValue();
                        for (String assignableInstanceName : assignableInstanceManager.getAssignableInstanceNames()) {
                            assignableInstanceManager.release(assignableInstanceName, taskConfig, quotaType);
                        }
                    }
                }
                return true;
            }
            if (jobState == TaskState.COMPLETED || jobState == TaskState.FAILED || jobState == TaskState.TIMED_OUT) continue;
            incomplete = true;
        }
        if (!incomplete && cfg.isTerminable()) {
            ctx.setWorkflowState(TaskState.COMPLETED);
            return true;
        }
        return false;
    }

    protected void updateWorkflowMonitor(WorkflowContext context, WorkflowConfig config) {
        if (this._clusterStatusMonitor != null) {
            this._clusterStatusMonitor.updateWorkflowCounters(config, context.getWorkflowState(), context.getFinishTime() - context.getStartTime());
        }
    }

    protected Set<String> getExcludedInstances(String currentJobName, WorkflowConfig workflowCfg, WorkflowContext workflowContext, WorkflowControllerDataProvider cache) {
        HashSet<String> ret = new HashSet<String>();
        if (!workflowCfg.isAllowOverlapJobAssignment()) {
            for (String jobName : workflowCfg.getJobDag().getAllNodes()) {
                TaskState jobState;
                JobContext jobContext;
                if (jobName.equals(currentJobName) || (jobContext = cache.getJobContext(jobName)) == null || (jobState = workflowContext.getJobState(jobName)) != TaskState.IN_PROGRESS) continue;
                for (int pId : jobContext.getPartitionSet()) {
                    TaskPartitionState partitionState = jobContext.getPartitionState(pId);
                    if (partitionState != TaskPartitionState.INIT && partitionState != TaskPartitionState.RUNNING) continue;
                    ret.add(jobContext.getAssignedParticipant(pId));
                }
            }
        }
        return ret;
    }

    protected void scheduleRebalanceForTimeout(String resourceId, long startTime, long timeoutPeriod) {
        long nextTimeout = this.getTimeoutTime(startTime, timeoutPeriod);
        long nextRebalanceTime = _rebalanceScheduler.getRebalanceTime(resourceId);
        if (nextTimeout >= System.currentTimeMillis() && (nextRebalanceTime == -1L || nextTimeout < nextRebalanceTime)) {
            _rebalanceScheduler.scheduleRebalance(this._manager, resourceId, nextTimeout);
        }
    }

    protected boolean isTimeout(long startTime, long timeoutPeriod) {
        long nextTimeout = this.getTimeoutTime(startTime, timeoutPeriod);
        return nextTimeout != -1L && nextTimeout <= System.currentTimeMillis();
    }

    private long getTimeoutTime(long startTime, long timeoutPeriod) {
        return timeoutPeriod == -1L || timeoutPeriod > Long.MAX_VALUE - startTime ? -1L : startTime + timeoutPeriod;
    }

    public void setClusterStatusMonitor(ClusterStatusMonitor clusterStatusMonitor) {
        this._clusterStatusMonitor = clusterStatusMonitor;
    }

    private String getTaskId(JobConfig jobCfg, JobContext jobCtx, int partitionNum) {
        if (TaskUtil.isGenericTaskJob(jobCfg)) {
            return jobCtx.getTaskIdForPartition(partitionNum);
        }
        return this.pName(jobCfg.getJobId(), partitionNum);
    }

    protected boolean isWorkflowStopped(WorkflowContext ctx, WorkflowConfig cfg) {
        if (cfg.isRecurring()) {
            return cfg.getTargetState() == TargetState.STOP;
        }
        for (String job : cfg.getJobDag().getAllNodes()) {
            TaskState jobState = ctx.getJobState(job);
            if (jobState == null || !jobState.equals((Object)TaskState.IN_PROGRESS) && !jobState.equals((Object)TaskState.STOPPING)) continue;
            return false;
        }
        return true;
    }

    protected ResourceAssignment buildEmptyAssignment(String name, CurrentStateOutput currStateOutput) {
        ResourceAssignment assignment = new ResourceAssignment(name);
        Set<Partition> partitions = currStateOutput.getCurrentStateMappedPartitions(name);
        for (Partition partition : partitions) {
            Map<String, String> currentStateMap = currStateOutput.getCurrentStateMap(name, partition);
            HashMap replicaMap = Maps.newHashMap();
            for (String instanceName : currentStateMap.keySet()) {
                replicaMap.put(instanceName, HelixDefinedState.DROPPED.toString());
            }
            assignment.addReplicaMap(partition, replicaMap);
        }
        return assignment;
    }

    protected boolean isJobReadyToSchedule(String job, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, int incompleteAllCount, Map<String, JobConfig> jobConfigMap, WorkflowControllerDataProvider clusterDataCache, AssignableInstanceManager assignableInstanceManager) {
        int notStartedCount = 0;
        int failedOrTimeoutCount = 0;
        int incompleteParentCount = 0;
        JobConfig jobConfig = jobConfigMap.get(job);
        if (jobConfig == null) {
            LOG.error(String.format("The job config is missing for job %s", job));
            return false;
        }
        String quotaType = TaskAssignmentCalculator.getQuotaType(workflowCfg, jobConfig);
        if (quotaType == null || !assignableInstanceManager.hasQuotaType(quotaType)) {
            quotaType = "DEFAULT";
        }
        if (!assignableInstanceManager.hasGlobalCapacity(quotaType)) {
            LOG.info(String.format("Job %s not ready to schedule due to not having enough quota for quota type %s", job, quotaType));
            return false;
        }
        for (String parent : workflowCfg.getJobDag().getDirectParents(job)) {
            TaskState jobState = workflowCtx.getJobState(parent);
            if (jobState == null || jobState == TaskState.NOT_STARTED) {
                ++notStartedCount;
                continue;
            }
            if (jobState == TaskState.FAILED || jobState == TaskState.TIMED_OUT) {
                ++failedOrTimeoutCount;
                continue;
            }
            if (jobState == TaskState.COMPLETED) continue;
            ++incompleteParentCount;
        }
        if (notStartedCount > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Job %s is not ready to start, notStartedParent(s)=%d.", job, notStartedCount));
            }
            return false;
        }
        if (failedOrTimeoutCount > 0 && !jobConfig.isIgnoreDependentJobFailure()) {
            this.markJobFailed(job, null, workflowCfg, workflowCtx, jobConfigMap, clusterDataCache);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Job %s is not ready to start, failedCount(s)=%d.", job, failedOrTimeoutCount));
            }
            return false;
        }
        if (workflowCfg.isJobQueue()) {
            if (incompleteAllCount >= workflowCfg.getParallelJobs()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Job %s is not ready to schedule, inCompleteJobs(s)=%d.", job, incompleteAllCount));
                }
                return false;
            }
        } else if (incompleteParentCount > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Job %s is not ready to start, notFinishedParent(s)=%d.", job, incompleteParentCount));
            }
            return false;
        }
        return true;
    }

    protected boolean isWorkflowReadyForSchedule(WorkflowConfig workflowCfg) {
        Date startTime = workflowCfg.getStartTime();
        return startTime == null || startTime.getTime() <= System.currentTimeMillis();
    }

    public void updateBestPossibleStateOutput(String resource, ResourceAssignment partitionStateAssignment, BestPossibleStateOutput output) {
        for (Partition partition : partitionStateAssignment.getMappedPartitions()) {
            Map<String, String> newStateMap = partitionStateAssignment.getReplicaMap(partition);
            output.setState(resource, partition, newStateMap);
        }
    }

    protected void finishJobInRuntimeJobDag(TaskDataCache clusterDataCache, String workflowName, String jobName) {
        RuntimeJobDag runtimeJobDag = clusterDataCache.getRuntimeJobDag(workflowName);
        if (runtimeJobDag != null) {
            runtimeJobDag.finishJob(jobName);
            LOG.debug(String.format("Finish job %s of workflow %s for runtime job DAG", jobName, workflowName));
        } else {
            LOG.warn(String.format("Failed to find runtime job DAG for workflow %s and job %s", workflowName, jobName));
        }
    }

    protected static void reportSubmissionToProcessDelay(BaseControllerDataProvider dataProvider, ClusterStatusMonitor clusterStatusMonitor, WorkflowConfig workflowConfig, JobConfig jobConfig, long currentTimestamp) {
        AbstractBaseStage.asyncExecute(dataProvider.getAsyncTasksThreadPool(), () -> {
            JobMonitor jobMonitor = clusterStatusMonitor.getJobMonitor(TaskAssignmentCalculator.getQuotaType(workflowConfig, jobConfig));
            if (jobMonitor == null) {
                return null;
            }
            long submissionToProcessDelay = currentTimestamp - jobConfig.getStat().getCreationTime();
            jobMonitor.updateSubmissionToProcessDelayGauge(submissionToProcessDelay);
            return null;
        });
    }

    private static void reportSubmissionToScheduleDelay(BaseControllerDataProvider dataProvider, ClusterStatusMonitor clusterStatusMonitor, WorkflowConfig workflowConfig, JobConfig jobConfig, long currentTimestamp) {
        AbstractBaseStage.asyncExecute(dataProvider.getAsyncTasksThreadPool(), () -> {
            JobMonitor jobMonitor = clusterStatusMonitor.getJobMonitor(TaskAssignmentCalculator.getQuotaType(workflowConfig, jobConfig));
            if (jobMonitor == null) {
                return null;
            }
            long submissionToStartDelay = currentTimestamp - jobConfig.getStat().getCreationTime();
            jobMonitor.updateSubmissionToScheduleDelayGauge(submissionToStartDelay);
            return null;
        });
    }

    private static void reportControllerInducedDelay(BaseControllerDataProvider dataProvider, ClusterStatusMonitor clusterStatusMonitor, WorkflowConfig workflowConfig, JobConfig jobConfig, long currentTimestamp) {
        AbstractBaseStage.asyncExecute(dataProvider.getAsyncTasksThreadPool(), () -> {
            JobMonitor jobMonitor = clusterStatusMonitor.getJobMonitor(TaskAssignmentCalculator.getQuotaType(workflowConfig, jobConfig));
            if (jobMonitor == null) {
                return null;
            }
            String firstTask = jobConfig.getTaskConfigMap().keySet().iterator().next();
            if (jobConfig.getTaskConfig(firstTask).getConfigMap().containsKey(TASK_LATENCY_TAG)) {
                long taskDuration = Long.valueOf(jobConfig.getTaskConfig(firstTask).getConfigMap().get(TASK_LATENCY_TAG));
                long controllerInducedDelay = currentTimestamp - jobConfig.getStat().getCreationTime() - taskDuration;
                jobMonitor.updateControllerInducedDelayGauge(controllerInducedDelay);
            }
            return null;
        });
    }

    protected static class PartitionAssignment {
        public final String _instance;
        public final String _state;

        PartitionAssignment(String instance, String state) {
            this._instance = instance;
            this._state = state;
        }
    }
}

