/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.ZNRecord;

public class ZNRecordRow {
    public static final String SIMPLE_KEY = "simpleKey";
    public static final String SIMPLE_VALUE = "simpleValue";
    public static final String LIST_KEY = "listKey";
    public static final String LIST_VALUE = "listValue";
    public static final String LIST_VALUE_INDEX = "listValueIndex";
    public static final String MAP_KEY = "mapKey";
    public static final String MAP_SUBKEY = "mapSubKey";
    public static final String MAP_VALUE = "mapValue";
    public static final String ZNRECORD_ID = "recordId";
    final Map<String, String> _rowDataMap = new HashMap<String, String>();

    public ZNRecordRow() {
        this._rowDataMap.put(SIMPLE_KEY, "");
        this._rowDataMap.put(SIMPLE_VALUE, "");
        this._rowDataMap.put(LIST_KEY, "");
        this._rowDataMap.put(LIST_VALUE, "");
        this._rowDataMap.put(LIST_VALUE_INDEX, "");
        this._rowDataMap.put(MAP_KEY, "");
        this._rowDataMap.put(MAP_SUBKEY, "");
        this._rowDataMap.put(MAP_VALUE, "");
        this._rowDataMap.put(ZNRECORD_ID, "");
    }

    public String getField(String rowField) {
        return this._rowDataMap.get(rowField);
    }

    public void putField(String fieldName, String fieldValue) {
        this._rowDataMap.put(fieldName, fieldValue);
    }

    public String getListValueIndex() {
        return this.getField(LIST_VALUE_INDEX);
    }

    public String getSimpleKey() {
        return this.getField(SIMPLE_KEY);
    }

    public String getSimpleValue() {
        return this.getField(SIMPLE_VALUE);
    }

    public String getListKey() {
        return this.getField(LIST_KEY);
    }

    public String getListValue() {
        return this.getField(LIST_VALUE);
    }

    public String getMapKey() {
        return this.getField(MAP_KEY);
    }

    public String getMapSubKey() {
        return this.getField(MAP_SUBKEY);
    }

    public String getMapValue() {
        return this.getField(MAP_VALUE);
    }

    public String getRecordId() {
        return this.getField(ZNRECORD_ID);
    }

    public static String getField(ZNRecordRow row, String rowField) {
        return row.getField(rowField);
    }

    public static List<ZNRecordRow> convertSimpleFields(ZNRecord record) {
        ArrayList<ZNRecordRow> result = new ArrayList<ZNRecordRow>();
        for (String key : record.getSimpleFields().keySet()) {
            ZNRecordRow row = new ZNRecordRow();
            row.putField(ZNRECORD_ID, record.getId());
            row.putField(SIMPLE_KEY, key);
            row.putField(SIMPLE_VALUE, record.getSimpleField(key));
            result.add(row);
        }
        return result;
    }

    public static List<ZNRecordRow> convertListFields(ZNRecord record) {
        ArrayList<ZNRecordRow> result = new ArrayList<ZNRecordRow>();
        for (String key : record.getListFields().keySet()) {
            int order = 0;
            for (String value : record.getListField(key)) {
                ZNRecordRow row = new ZNRecordRow();
                row.putField(ZNRECORD_ID, record.getId());
                row.putField(LIST_KEY, key);
                row.putField(LIST_VALUE, record.getSimpleField(key));
                row.putField(LIST_VALUE_INDEX, "" + order);
                ++order;
                result.add(row);
            }
        }
        return result;
    }

    public static List<ZNRecordRow> convertMapFields(ZNRecord record) {
        ArrayList<ZNRecordRow> result = new ArrayList<ZNRecordRow>();
        for (String key0 : record.getMapFields().keySet()) {
            for (String key1 : record.getMapField(key0).keySet()) {
                ZNRecordRow row = new ZNRecordRow();
                row.putField(ZNRECORD_ID, record.getId());
                row.putField(MAP_KEY, key0);
                row.putField(MAP_SUBKEY, key1);
                row.putField(MAP_VALUE, record.getMapField(key0).get(key1));
                result.add(row);
            }
        }
        return result;
    }

    public static List<ZNRecordRow> flatten(ZNRecord record) {
        List<ZNRecordRow> result = ZNRecordRow.convertMapFields(record);
        result.addAll(ZNRecordRow.convertListFields(record));
        result.addAll(ZNRecordRow.convertSimpleFields(record));
        return result;
    }

    public static List<ZNRecordRow> flatten(Collection<ZNRecord> recordList) {
        ArrayList<ZNRecordRow> result = new ArrayList<ZNRecordRow>();
        for (ZNRecord record : recordList) {
            result.addAll(ZNRecordRow.flatten(record));
        }
        return result;
    }

    public static List<ZNRecordRow> getRowListFromMap(Map<String, List<ZNRecordRow>> rowMap, String key) {
        return rowMap.get(key);
    }

    public String toString() {
        return this._rowDataMap.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof ZNRecordRow) {
            ZNRecordRow that = (ZNRecordRow)other;
            return this._rowDataMap.equals(that._rowDataMap);
        }
        return false;
    }

    public int hashCode() {
        return this._rowDataMap.hashCode();
    }
}

