/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.hadoop.util.Timer;

public class LogThrottlingHelper {
    public static final LogAction DO_NOT_LOG = new NoLogAction();
    private static final String DEFAULT_RECORDER_NAME = "__DEFAULT_RECORDER_NAME__";
    private final long minLogPeriodMs;
    private String primaryRecorderName;
    private final Timer timer;
    private final Map<String, LoggingAction> currentLogs;
    private long lastLogTimestampMs = Long.MIN_VALUE;

    public LogThrottlingHelper(long minLogPeriodMs) {
        this(minLogPeriodMs, null);
    }

    public LogThrottlingHelper(long minLogPeriodMs, String primaryRecorderName) {
        this(minLogPeriodMs, primaryRecorderName, new Timer());
    }

    @VisibleForTesting
    LogThrottlingHelper(long minLogPeriodMs, String primaryRecorderName, Timer timer) {
        this.minLogPeriodMs = minLogPeriodMs;
        this.primaryRecorderName = primaryRecorderName;
        this.timer = timer;
        this.currentLogs = new HashMap<String, LoggingAction>();
    }

    public LogAction record(double ... values) {
        return this.record(DEFAULT_RECORDER_NAME, this.timer.monotonicNow(), values);
    }

    public LogAction record(String recorderName, long currentTimeMs, double ... values) {
        LoggingAction currentLog;
        if (this.primaryRecorderName == null) {
            this.primaryRecorderName = recorderName;
        }
        if ((currentLog = this.currentLogs.get(recorderName)) == null || currentLog.hasLogged()) {
            currentLog = new LoggingAction(values.length);
            if (!this.currentLogs.containsKey(recorderName)) {
                currentLog.setShouldLog();
            }
            this.currentLogs.put(recorderName, currentLog);
        }
        currentLog.recordValues(values);
        if (this.primaryRecorderName.equals(recorderName) && currentTimeMs - this.minLogPeriodMs >= this.lastLogTimestampMs) {
            this.lastLogTimestampMs = currentTimeMs;
            for (LoggingAction log : this.currentLogs.values()) {
                log.setShouldLog();
            }
        }
        if (currentLog.shouldLog()) {
            currentLog.setHasLogged();
            return currentLog;
        }
        return DO_NOT_LOG;
    }

    public static String getLogSupressionMessage(LogAction action) {
        if (action.getCount() > 1) {
            return " (suppressed logging " + (action.getCount() - 1) + " times)";
        }
        return "";
    }

    private static class NoLogAction
    implements LogAction {
        private NoLogAction() {
        }

        @Override
        public int getCount() {
            throw new IllegalStateException("Cannot be logged yet!");
        }

        @Override
        public SummaryStatistics getStats(int idx) {
            throw new IllegalStateException("Cannot be logged yet!");
        }

        @Override
        public boolean shouldLog() {
            return false;
        }
    }

    private static class LoggingAction
    implements LogAction {
        private int count = 0;
        private final SummaryStatistics[] stats;
        private boolean shouldLog = false;
        private boolean hasLogged = false;

        LoggingAction(int valueCount) {
            this.stats = new SummaryStatistics[valueCount];
            for (int i = 0; i < this.stats.length; ++i) {
                this.stats[i] = new SummaryStatistics();
            }
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public SummaryStatistics getStats(int idx) {
            if (idx < 0 || idx >= this.stats.length) {
                throw new IllegalArgumentException("Requested stats at idx " + idx + " but this log only maintains " + this.stats.length + " stats");
            }
            return this.stats[idx];
        }

        @Override
        public boolean shouldLog() {
            return this.shouldLog;
        }

        private void setShouldLog() {
            this.shouldLog = true;
        }

        private boolean hasLogged() {
            return this.hasLogged;
        }

        private void setHasLogged() {
            this.hasLogged = true;
        }

        private void recordValues(double ... values) {
            if (values.length != this.stats.length) {
                throw new IllegalArgumentException("received " + values.length + " values but expected " + this.stats.length);
            }
            ++this.count;
            for (int i = 0; i < values.length; ++i) {
                this.stats[i].addValue(values[i]);
            }
        }
    }

    public static interface LogAction {
        public int getCount();

        public SummaryStatistics getStats(int var1);

        public boolean shouldLog();
    }
}

