/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.gravitino.iceberg.common.cache.BaseTableMetadataCache;
import org.apache.gravitino.iceberg.common.cache.SupportsMetadataLocation;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.TableIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTableMetadataCache
extends BaseTableMetadataCache {
    public static final Logger LOG = LoggerFactory.getLogger(LocalTableMetadataCache.class);
    private Cache<TableIdentifier, TableMetadata> tableMetadataCache;

    @Override
    public void initialize(int capacity, int expireMinutes, Map<String, String> catalogProperties, SupportsMetadataLocation supportsMetadataLocation) {
        super.initialize(supportsMetadataLocation);
        this.tableMetadataCache = Caffeine.newBuilder().maximumSize((long)capacity).expireAfterAccess((long)expireMinutes, TimeUnit.MINUTES).executor(Runnable::run).build();
    }

    @Override
    public void invalidate(TableIdentifier tableIdentifier) {
        LOG.debug("Invalidate table cache, table identifier: {}", (Object)tableIdentifier);
        this.tableMetadataCache.invalidate((Object)tableIdentifier);
    }

    @Override
    public void updateTableMetadata(TableIdentifier tableIdentifier, TableMetadata tableMetadata) {
        LOG.debug("Update table cache, table identifier: {}, table metadata location: {}", (Object)tableIdentifier, (Object)tableMetadata.metadataFileLocation());
        this.tableMetadataCache.put((Object)tableIdentifier, (Object)tableMetadata);
    }

    @Override
    public void close() throws IOException {
        LOG.info("Close Iceberg table metadata cache");
        if (this.tableMetadataCache != null) {
            this.tableMetadataCache.invalidateAll();
            this.tableMetadataCache.cleanUp();
        }
    }

    @Override
    protected Optional<TableMetadata> doGetTableMetadata(TableIdentifier tableIdentifier) {
        return Optional.ofNullable((TableMetadata)this.tableMetadataCache.getIfPresent((Object)tableIdentifier));
    }

    @VisibleForTesting
    int size() {
        return this.tableMetadataCache.asMap().size();
    }
}

