/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.shaded.guava.collect;

import com.lancedb.lance.shaded.guava.annotations.GwtIncompatible;
import com.lancedb.lance.shaded.guava.annotations.J2ktIncompatible;
import com.lancedb.lance.shaded.guava.collect.BoundType;
import com.lancedb.lance.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import com.lancedb.lance.shaded.guava.collect.ImmutableCollection;
import com.lancedb.lance.shaded.guava.collect.ImmutableSortedMultiset;
import com.lancedb.lance.shaded.guava.collect.ImmutableSortedSet;
import com.lancedb.lance.shaded.guava.collect.Multiset;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class DescendingImmutableSortedMultiset<E>
extends ImmutableSortedMultiset<E> {
    private final transient ImmutableSortedMultiset<E> forward;

    DescendingImmutableSortedMultiset(ImmutableSortedMultiset<E> forward) {
        this.forward = forward;
    }

    @Override
    public int count(@CheckForNull Object element) {
        return this.forward.count(element);
    }

    @Override
    @CheckForNull
    public Multiset.Entry<E> firstEntry() {
        return this.forward.lastEntry();
    }

    @Override
    @CheckForNull
    public Multiset.Entry<E> lastEntry() {
        return this.forward.firstEntry();
    }

    @Override
    public int size() {
        return this.forward.size();
    }

    @Override
    public ImmutableSortedSet<E> elementSet() {
        return ((ImmutableSortedSet)this.forward.elementSet()).descendingSet();
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return (Multiset.Entry)((ImmutableCollection)((Object)this.forward.entrySet())).asList().reverse().get(index);
    }

    @Override
    public ImmutableSortedMultiset<E> descendingMultiset() {
        return this.forward;
    }

    @Override
    public ImmutableSortedMultiset<E> headMultiset(E upperBound, BoundType boundType) {
        return ((ImmutableSortedMultiset)this.forward.tailMultiset((Object)upperBound, boundType)).descendingMultiset();
    }

    @Override
    public ImmutableSortedMultiset<E> tailMultiset(E lowerBound, BoundType boundType) {
        return ((ImmutableSortedMultiset)this.forward.headMultiset((Object)lowerBound, boundType)).descendingMultiset();
    }

    @Override
    boolean isPartialView() {
        return this.forward.isPartialView();
    }

    @Override
    @J2ktIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

