/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gravitino.cli.ParsedType;
import org.apache.gravitino.cli.TypeConverter;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class ParseType {
    public static ParsedType parseBasicType(String datatype) {
        Pattern pattern = Pattern.compile("^(\\w+)\\s*\\(\\s*(\\d+)\\s*(?:,\\s*(\\d+)\\s*)?\\)$");
        Matcher matcher = pattern.matcher(datatype);
        if (matcher.matches()) {
            Integer scale;
            String typeName = matcher.group(1);
            Integer lengthOrPrecision = Integer.parseInt(matcher.group(2));
            Integer n = scale = matcher.group(3) != null ? Integer.valueOf(Integer.parseInt(matcher.group(3))) : null;
            if (lengthOrPrecision != null && scale != null) {
                return new ParsedType(typeName, lengthOrPrecision, scale);
            }
            if (lengthOrPrecision != null) {
                return new ParsedType(typeName, lengthOrPrecision);
            }
            throw new IllegalArgumentException("Unsupported/malformed data type: " + typeName);
        }
        return null;
    }

    private static Type toBasicType(String datatype) {
        ParsedType parsed = ParseType.parseBasicType(datatype);
        if (parsed != null) {
            if ("decimal".equalsIgnoreCase(parsed.getTypeName())) {
                if (parsed.getPrecision() != null && parsed.getScale() != null) {
                    return TypeConverter.convert(datatype, parsed.getPrecision(), parsed.getScale());
                }
                if (parsed.getLength() != null) {
                    int precision = parsed.getLength();
                    return Types.DecimalType.of(precision, 0);
                }
            }
            if (parsed.getPrecision() != null && parsed.getScale() != null) {
                return TypeConverter.convert(datatype, parsed.getPrecision(), parsed.getScale());
            }
            if (parsed.getLength() != null) {
                return TypeConverter.convert(datatype, parsed.getLength());
            }
        }
        return TypeConverter.convert(datatype);
    }

    private static Type toListType(String datatype) {
        Pattern pattern = Pattern.compile("^list\\s*\\(\\s*(.+?)\\s*\\)$");
        Matcher matcher = pattern.matcher(datatype);
        if (matcher.matches()) {
            Type elementType = ParseType.toType(matcher.group(1).trim());
            return Types.ListType.of(elementType, false);
        }
        throw new IllegalArgumentException("Malformed list type: " + datatype);
    }

    private static Type toMapType(String datatype) {
        Pattern pattern = Pattern.compile("^map\\s*\\(\\s*(.+?)\\s*,\\s*(.+?)\\s*\\)$");
        Matcher matcher = pattern.matcher(datatype);
        if (matcher.matches()) {
            Type keyType = ParseType.toType(matcher.group(1).trim());
            Type valueType = ParseType.toType(matcher.group(2).trim());
            return Types.MapType.of(keyType, valueType, false);
        }
        throw new IllegalArgumentException("Malformed map type: " + datatype);
    }

    public static Type toType(String datatype) {
        String dt = datatype.trim();
        if (dt.startsWith("list")) {
            return ParseType.toListType(dt);
        }
        if (dt.startsWith("map")) {
            return ParseType.toMapType(dt);
        }
        return ParseType.toBasicType(dt);
    }
}

