/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.JobTemplateEntity;

public class JobTemplatePO {
    private Long jobTemplateId;
    private String jobTemplateName;
    private Long metalakeId;
    private String jobTemplateComment;
    private String jobTemplateContent;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public JobTemplatePO() {
    }

    private JobTemplatePO(Long jobTemplateId, String jobTemplateName, Long metalakeId, String jobTemplateComment, String jobTemplateContent, String auditInfo, Long currentVersion, Long lastVersion, Long deletedAt) {
        Preconditions.checkArgument((jobTemplateId != null ? 1 : 0) != 0, (Object)"jobTemplateId cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jobTemplateName), (Object)"jobTemplateName cannot be blank");
        Preconditions.checkArgument((metalakeId != null ? 1 : 0) != 0, (Object)"metalakeId cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jobTemplateContent), (Object)"jobTemplateContent cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)auditInfo), (Object)"auditInfo cannot be blank");
        Preconditions.checkArgument((currentVersion != null ? 1 : 0) != 0, (Object)"currentVersion cannot be null");
        Preconditions.checkArgument((lastVersion != null ? 1 : 0) != 0, (Object)"lastVersion cannot be null");
        Preconditions.checkArgument((deletedAt != null ? 1 : 0) != 0, (Object)"deletedAt cannot be null");
        this.jobTemplateId = jobTemplateId;
        this.jobTemplateName = jobTemplateName;
        this.metalakeId = metalakeId;
        this.jobTemplateComment = jobTemplateComment;
        this.jobTemplateContent = jobTemplateContent;
        this.auditInfo = auditInfo;
        this.currentVersion = currentVersion;
        this.lastVersion = lastVersion;
        this.deletedAt = deletedAt;
    }

    public static JobTemplatePO initializeJobTemplatePO(JobTemplateEntity jobTemplateEntity, JobTemplatePOBuilder builder) {
        try {
            return builder.withJobTemplateId(jobTemplateEntity.id()).withJobTemplateName(jobTemplateEntity.name()).withJobTemplateComment(jobTemplateEntity.comment()).withJobTemplateContent(JsonUtils.anyFieldMapper().writeValueAsString((Object)jobTemplateEntity.templateContent())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)jobTemplateEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize job template entity", e);
        }
    }

    public static JobTemplatePO updateJobTemplatePO(JobTemplatePO oldJobTemplatePO, JobTemplateEntity newJobTemplateEntity, JobTemplatePOBuilder builder) {
        try {
            Long lastVersion;
            Long currentVersion = lastVersion = Long.valueOf(oldJobTemplatePO.lastVersion() + 1L);
            return builder.withJobTemplateId(newJobTemplateEntity.id()).withJobTemplateName(newJobTemplateEntity.name()).withJobTemplateComment(newJobTemplateEntity.comment()).withJobTemplateContent(JsonUtils.anyFieldMapper().writeValueAsString((Object)newJobTemplateEntity.templateContent())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newJobTemplateEntity.auditInfo())).withCurrentVersion(currentVersion).withLastVersion(lastVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize job template entity", e);
        }
    }

    public static JobTemplateEntity fromJobTemplatePO(JobTemplatePO jobTemplatePO, Namespace namespace) {
        try {
            return JobTemplateEntity.builder().withId(jobTemplatePO.jobTemplateId()).withName(jobTemplatePO.jobTemplateName()).withNamespace(namespace).withComment(jobTemplatePO.jobTemplateComment()).withTemplateContent((JobTemplateEntity.TemplateContent)JsonUtils.anyFieldMapper().readValue(jobTemplatePO.jobTemplateContent(), JobTemplateEntity.TemplateContent.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(jobTemplatePO.auditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize job template PO", e);
        }
    }

    public static JobTemplatePOBuilder builder() {
        return new JobTemplatePOBuilder();
    }

    public Long jobTemplateId() {
        return this.jobTemplateId;
    }

    public String jobTemplateName() {
        return this.jobTemplateName;
    }

    public Long metalakeId() {
        return this.metalakeId;
    }

    public String jobTemplateComment() {
        return this.jobTemplateComment;
    }

    public String jobTemplateContent() {
        return this.jobTemplateContent;
    }

    public String auditInfo() {
        return this.auditInfo;
    }

    public Long currentVersion() {
        return this.currentVersion;
    }

    public Long lastVersion() {
        return this.lastVersion;
    }

    public Long deletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobTemplatePO)) {
            return false;
        }
        JobTemplatePO other = (JobTemplatePO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$jobTemplateId = this.jobTemplateId();
        Long other$jobTemplateId = other.jobTemplateId();
        if (this$jobTemplateId == null ? other$jobTemplateId != null : !((Object)this$jobTemplateId).equals(other$jobTemplateId)) {
            return false;
        }
        Long this$metalakeId = this.metalakeId();
        Long other$metalakeId = other.metalakeId();
        if (this$metalakeId == null ? other$metalakeId != null : !((Object)this$metalakeId).equals(other$metalakeId)) {
            return false;
        }
        Long this$currentVersion = this.currentVersion();
        Long other$currentVersion = other.currentVersion();
        if (this$currentVersion == null ? other$currentVersion != null : !((Object)this$currentVersion).equals(other$currentVersion)) {
            return false;
        }
        Long this$lastVersion = this.lastVersion();
        Long other$lastVersion = other.lastVersion();
        if (this$lastVersion == null ? other$lastVersion != null : !((Object)this$lastVersion).equals(other$lastVersion)) {
            return false;
        }
        Long this$deletedAt = this.deletedAt();
        Long other$deletedAt = other.deletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        String this$jobTemplateName = this.jobTemplateName();
        String other$jobTemplateName = other.jobTemplateName();
        if (this$jobTemplateName == null ? other$jobTemplateName != null : !this$jobTemplateName.equals(other$jobTemplateName)) {
            return false;
        }
        String this$jobTemplateComment = this.jobTemplateComment();
        String other$jobTemplateComment = other.jobTemplateComment();
        if (this$jobTemplateComment == null ? other$jobTemplateComment != null : !this$jobTemplateComment.equals(other$jobTemplateComment)) {
            return false;
        }
        String this$jobTemplateContent = this.jobTemplateContent();
        String other$jobTemplateContent = other.jobTemplateContent();
        if (this$jobTemplateContent == null ? other$jobTemplateContent != null : !this$jobTemplateContent.equals(other$jobTemplateContent)) {
            return false;
        }
        String this$auditInfo = this.auditInfo();
        String other$auditInfo = other.auditInfo();
        return !(this$auditInfo == null ? other$auditInfo != null : !this$auditInfo.equals(other$auditInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobTemplatePO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $jobTemplateId = this.jobTemplateId();
        result = result * 59 + ($jobTemplateId == null ? 43 : ((Object)$jobTemplateId).hashCode());
        Long $metalakeId = this.metalakeId();
        result = result * 59 + ($metalakeId == null ? 43 : ((Object)$metalakeId).hashCode());
        Long $currentVersion = this.currentVersion();
        result = result * 59 + ($currentVersion == null ? 43 : ((Object)$currentVersion).hashCode());
        Long $lastVersion = this.lastVersion();
        result = result * 59 + ($lastVersion == null ? 43 : ((Object)$lastVersion).hashCode());
        Long $deletedAt = this.deletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        String $jobTemplateName = this.jobTemplateName();
        result = result * 59 + ($jobTemplateName == null ? 43 : $jobTemplateName.hashCode());
        String $jobTemplateComment = this.jobTemplateComment();
        result = result * 59 + ($jobTemplateComment == null ? 43 : $jobTemplateComment.hashCode());
        String $jobTemplateContent = this.jobTemplateContent();
        result = result * 59 + ($jobTemplateContent == null ? 43 : $jobTemplateContent.hashCode());
        String $auditInfo = this.auditInfo();
        result = result * 59 + ($auditInfo == null ? 43 : $auditInfo.hashCode());
        return result;
    }

    public String toString() {
        return "JobTemplatePO(jobTemplateId=" + this.jobTemplateId() + ", jobTemplateName=" + this.jobTemplateName() + ", metalakeId=" + this.metalakeId() + ", jobTemplateComment=" + this.jobTemplateComment() + ", jobTemplateContent=" + this.jobTemplateContent() + ", auditInfo=" + this.auditInfo() + ", currentVersion=" + this.currentVersion() + ", lastVersion=" + this.lastVersion() + ", deletedAt=" + this.deletedAt() + ")";
    }

    public static class JobTemplatePOBuilder {
        private Long jobTemplateId;
        private String jobTemplateName;
        private Long metalakeId;
        private String jobTemplateComment;
        private String jobTemplateContent;
        private String auditInfo;
        private Long currentVersion;
        private Long lastVersion;
        private Long deletedAt;

        JobTemplatePOBuilder() {
        }

        public JobTemplatePOBuilder withJobTemplateId(Long jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
            return this;
        }

        public JobTemplatePOBuilder withJobTemplateName(String jobTemplateName) {
            this.jobTemplateName = jobTemplateName;
            return this;
        }

        public JobTemplatePOBuilder withMetalakeId(Long metalakeId) {
            this.metalakeId = metalakeId;
            return this;
        }

        public JobTemplatePOBuilder withJobTemplateComment(String jobTemplateComment) {
            this.jobTemplateComment = jobTemplateComment;
            return this;
        }

        public JobTemplatePOBuilder withJobTemplateContent(String jobTemplateContent) {
            this.jobTemplateContent = jobTemplateContent;
            return this;
        }

        public JobTemplatePOBuilder withAuditInfo(String auditInfo) {
            this.auditInfo = auditInfo;
            return this;
        }

        public JobTemplatePOBuilder withCurrentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public JobTemplatePOBuilder withLastVersion(Long lastVersion) {
            this.lastVersion = lastVersion;
            return this;
        }

        public JobTemplatePOBuilder withDeletedAt(Long deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public JobTemplatePO build() {
            return new JobTemplatePO(this.jobTemplateId, this.jobTemplateName, this.metalakeId, this.jobTemplateComment, this.jobTemplateContent, this.auditInfo, this.currentVersion, this.lastVersion, this.deletedAt);
        }

        public String toString() {
            return "JobTemplatePO.JobTemplatePOBuilder(jobTemplateId=" + this.jobTemplateId + ", jobTemplateName=" + this.jobTemplateName + ", metalakeId=" + this.metalakeId + ", jobTemplateComment=" + this.jobTemplateComment + ", jobTemplateContent=" + this.jobTemplateContent + ", auditInfo=" + this.auditInfo + ", currentVersion=" + this.currentVersion + ", lastVersion=" + this.lastVersion + ", deletedAt=" + this.deletedAt + ")";
        }
    }
}

