/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.LongColumnVector;
import org.apache.paimon.data.columnar.TimestampColumnVector;
import org.apache.paimon.utils.Preconditions;

public class ParquetTimestampVector
implements TimestampColumnVector {
    private final ColumnVector vector;

    public ParquetTimestampVector(ColumnVector vector) {
        this.vector = vector;
    }

    public Timestamp getTimestamp(int i, int precision) {
        if (precision <= 3 && this.vector instanceof LongColumnVector) {
            return Timestamp.fromEpochMillis((long)((LongColumnVector)this.vector).getLong(i));
        }
        if (precision <= 6 && this.vector instanceof LongColumnVector) {
            return Timestamp.fromMicros((long)((LongColumnVector)this.vector).getLong(i));
        }
        Preconditions.checkArgument((boolean)(this.vector instanceof TimestampColumnVector), (String)"Reading timestamp type occur unsupported vector type: %s", (Object[])new Object[]{this.vector.getClass()});
        return ((TimestampColumnVector)this.vector).getTimestamp(i, precision);
    }

    public ColumnVector getVector() {
        return this.vector;
    }

    public boolean isNullAt(int i) {
        return this.vector.isNullAt(i);
    }
}

