/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.gravitino.dto.credential.CredentialDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class CredentialResponse
extends BaseResponse {
    @JsonProperty(value="credentials")
    private final CredentialDTO[] credentials;

    public CredentialResponse(CredentialDTO[] credentials) {
        super(0);
        this.credentials = credentials;
    }

    public CredentialResponse() {
        this.credentials = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.credentials != null ? 1 : 0) != 0, (Object)"\"credentials\" must not be null");
    }

    public CredentialDTO[] getCredentials() {
        return this.credentials;
    }

    @Override
    public String toString() {
        return "CredentialResponse(credentials=" + Arrays.deepToString(this.getCredentials()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CredentialResponse)) {
            return false;
        }
        CredentialResponse other = (CredentialResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getCredentials(), other.getCredentials());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CredentialResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getCredentials());
        return result;
    }
}

