/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinarySection;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.DataSetters;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

public final class NestedRow
extends BinarySection
implements InternalRow,
DataSetters {
    private static final long serialVersionUID = 1L;
    private final int arity;
    private final int nullBitsSizeInBytes;

    public NestedRow(int arity) {
        Preconditions.checkArgument((arity >= 0 ? 1 : 0) != 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRow.calculateBitSetWidthInBytes(arity);
    }

    private int getFieldOffset(int pos) {
        return this.offset + this.nullBitsSizeInBytes + pos * 8;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.arity) : "index (" + index + ") should < " + this.arity;
    }

    @Override
    public int getFieldCount() {
        return this.arity;
    }

    @Override
    public RowKind getRowKind() {
        byte kindValue = MemorySegmentUtils.getByte(this.segments, this.offset);
        return RowKind.fromByteValue((byte)kindValue);
    }

    @Override
    public void setRowKind(RowKind kind) {
        MemorySegmentUtils.setByte(this.segments, this.offset, kind.toByteValue());
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        MemorySegmentUtils.bitUnSet(this.segments, this.offset, i + 8);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        MemorySegmentUtils.bitSet(this.segments, this.offset, i + 8);
        MemorySegmentUtils.setLong(this.segments, this.getFieldOffset(i), 0L);
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setInt(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setLong(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setDouble(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            this.setLong(pos, value.toUnscaledLong());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(MemorySegmentUtils.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            MemorySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
            MemorySegmentUtils.setLong(this.segments, this.offset + cursor + 8, 0L);
            if (value == null) {
                this.setNullAt(pos);
                MemorySegmentUtils.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                MemorySegmentUtils.copyFromBytes(this.segments, this.offset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setTimestamp(int pos, Timestamp value, int precision) {
        this.assertIndexIsValid(pos);
        if (Timestamp.isCompact(precision)) {
            this.setLong(pos, value.getMillisecond());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(MemorySegmentUtils.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            if (value == null) {
                this.setNullAt(pos);
                MemorySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
                MemorySegmentUtils.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                MemorySegmentUtils.setLong(this.segments, this.offset + cursor, value.getMillisecond());
                this.setLong(pos, (long)cursor << 32 | (long)value.getNanoOfMillisecond());
            }
        }
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setBoolean(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setShort(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setByte(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setFloat(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.bitGet(this.segments, this.offset, pos + 8);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getBoolean(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getByte(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getShort(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getInt(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getLong(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getFloat(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getDouble(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public BinaryString getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readBinaryString(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            return Decimal.fromUnscaledLong(MemorySegmentUtils.getLong(this.segments, this.getFieldOffset(pos)), precision, scale);
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readDecimal(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        this.assertIndexIsValid(pos);
        if (Timestamp.isCompact(precision)) {
            return Timestamp.fromEpochMillis(MemorySegmentUtils.getLong(this.segments, this.getFieldOffset(pos)));
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndNanoOfMilli = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readTimestampData(this.segments, this.offset, offsetAndNanoOfMilli);
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readBinary(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public Variant getVariant(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readVariant(this.segments, this.offset, offsetAndLen);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.readRowData(this.segments, numFields, this.offset, this.getLong(pos));
    }

    @Override
    public InternalArray getArray(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.readArrayData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public InternalMap getMap(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.readMapData(this.segments, this.offset, this.getLong(pos));
    }

    public NestedRow copy() {
        return this.copy(new NestedRow(this.arity));
    }

    public NestedRow copy(InternalRow reuse) {
        return this.copyInternal((NestedRow)reuse);
    }

    private NestedRow copyInternal(NestedRow reuse) {
        byte[] bytes = MemorySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegment.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NestedRow) && !(o instanceof BinaryRow)) {
            return false;
        }
        BinarySection that = (BinarySection)o;
        return this.sizeInBytes == that.sizeInBytes && MemorySegmentUtils.equals(this.segments, this.offset, that.segments, that.offset, this.sizeInBytes);
    }

    @Override
    public int hashCode() {
        return MemorySegmentUtils.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }
}

