/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.listener.api.event.GroupEvent;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.info.GroupInfo;
import org.apache.gravitino.utils.NameIdentifierUtil;

@DeveloperApi
public class RevokeGroupRolesEvent
extends GroupEvent {
    private final GroupInfo revokedGroupInfo;
    private final List<String> roles;

    public RevokeGroupRolesEvent(String initiator, String metalake, GroupInfo revokedGroupInfo, List<String> roles) {
        super(initiator, NameIdentifierUtil.ofGroup(metalake, revokedGroupInfo.name()));
        this.revokedGroupInfo = revokedGroupInfo;
        this.roles = roles == null ? null : ImmutableList.copyOf(roles);
    }

    public GroupInfo revokedGroupInfo() {
        return this.revokedGroupInfo;
    }

    public List<String> roles() {
        return this.roles;
    }

    @Override
    public OperationType operationType() {
        return OperationType.REVOKE_GROUP_ROLES;
    }
}

